(function (){
	'use strict';
	angular
	.module('viki-controllers')
	.constant('HOME_PAGE' ,{
        'TITLE' : 'Home'
    })
	.controller('appHomeController', ['HOME_PAGE', '$rootScope', '$scope', '$filter', '$parse', 'getData', 'api', 'preloadData', function(HOME_PAGE, $rootScope, $scope, $filter, $parse, getData, api) {
		window.screen.mozLockOrientation("portrait");
		$scope.title = HOME_PAGE.TITLE;
		function loadMore(videos,url,scopeVar) {
			if(url){
				getData.fromUrl(url.replace(api.app_url,'') + '&t=' + api.currentTime()).then(function(requested){
					var next = requested.data.pagination.next;
					for (var i = 0; i < requested.data.response.length; i++) {
						videos.push(requested.data.response[i]);
					}
					videos = $filter('can_display')(videos);
					if(videos.length < 20){
						loadMore(videos,next,scopeVar);
					}
					else{
						var model = $parse(scopeVar);
						model.assign($scope, videos);
					}
				});
			}
			else{
				var model = $parse(scopeVar);
				model.assign($scope, videos);
			}
		}
		getData.fromUrl('/v4/lists/30l.json?with_paging=true&app=' + api.app_id + '&t=' + api.currentTime())
		.then(function(requested){
			var videos = $filter('can_display')(requested.data.response);
			$scope.mainSlider = videos;
		});
		getData.fromUrl('/v4/series.json?with_paging=true&sort=views_recent&app=' + api.app_id + '&t=' + api.currentTime())
		.then(function(requested){
			var videos = requested.data.response;
			var next = requested.data.pagination.next;
			if(videoCountCheck(videos)){
				$scope.popularShows = videos;
			}
			else{
				loadMore(videos,next,'popularShows');
			}
		});
		getData.fromUrl('/v4/lists/2l.json?with_paging=true&app=' + api.app_id + '&t=' + api.currentTime())
		.then(function(requested){
			var videos = requested.data.response;
			var next = requested.data.pagination.next;
			if(videoCountCheck(videos)){
				$scope.onAirTitles = videos;
			}
			else{
				loadMore(videos,next,'onAirTitles');
			}
		});
		getData.fromUrl('/v4/videos.json?with_paging=true&sort=trending&app=' + api.app_id + '&t=' + api.currentTime())
		.then(function(requested){
			var videos = requested.data.response;
			var next = requested.data.pagination.next;
			if(videoCountCheck(videos)){
				$scope.trendingWorldwide = videos;
			}
			else{
				loadMore(videos,next,'trendingWorldwide');
			}
		});
		getData.fromUrl('/v4/containers.json?with_paging=true&sort=created_at&app=' + api.app_id + '&t=' + api.currentTime())
		.then(function(requested){
			var videos = requested.data.response;
			var next = requested.data.pagination.next;
			if(videoCountCheck(videos)){
				$scope.recentVideos = videos;
			}
			else{
				loadMore(videos,next,'recentVideos');
			}
		});
		$scope.checker = api.process_url;
		$rootScope.prevToDetails = '';
		function videoCountCheck(videoObj){
			videoObj = $filter('can_display')(videoObj);
			if(videoObj.length < 20){
				return false;
			}
			else{
				return true;
			}
		}
	}]);
})();