(function (){
    'use strict';

    angular
    .module('viki-controllers')
    .constant('INFO_PAGE', {
        'SETTINGS' : true,
        'URL' : 'http://www.viki.com/'
    })
    .controller('appInfo', ['INFO_PAGE', '$scope', '$rootScope', '$state', '$stateParams', 'api', 'postData', function(INFO_PAGE,$scope,$rootScope,$state,$stateParams,api,postData){
        $scope.settings = INFO_PAGE.SETTINGS;
        $scope.av = false;
        $scope.fp = false;
        switch($stateParams.page){
            case 'tou':
                $scope.title = "Terms of Use";
                $scope.url = INFO_PAGE.URL + "mobile_terms_of_use";
                break;
            case 'pp':
                $scope.title = "Privacy Policy";
                $scope.url = INFO_PAGE.URL + "mobile_privacy";
                break;
            case 'av':
                $scope.title = "About Viki";
                $scope.av = true;
                break;
            case 'fp':
                $scope.title = 'Forgot your password?';
                $scope.fp = true;
                break;
            default:
            	break;
        }
        $scope.forgotPwd = function(email){
            postData.toUrl('/v4/reset_password_tokens.json?app=' + api.app_id + '&t=' + api.currentTime(), {"email": email})
            .then(function(requested){
                var status = {};
                if(requested.data.ok){
                    utils.status.show('Instruction to reset your password has been sent to your email.');
                    $state.go('login');
                }
                else{
                    utils.status.show('Invalid email address');
                }
            });
        };
    }]);
})();