 (function (){
    'use strict';
    angular
    .module('viki-controllers')
    .controller('appLoginController', ['$scope', '$rootScope', '$state', 'api', 'authService', function($scope,$rootScope,$state,api,authService){
        $scope.loginFields = JSON.parse(sessionStorage.getItem('tab')) === false ? false : true;
        $scope.error_submit = false;
        $scope.toSignUp = function(){
            $scope.loginFields = !$scope.loginFields;
            $scope.error_submit = false;
        };
        $scope.login = function(un,pwd){
            var data = {
                'username': un,
                'password': pwd
            };
            if (un && pwd) {
                authService.loginReq('/v5/sessions.json?app=' + api.app_id + '&t=' + api.currentTime(),data)
                .then(function(requested){
                    console.log('sign in data:',requested);
                    redirect(requested);
                });
            }
            else {
                $scope.error_message = 'Username and Password cannot be empty';
                $scope.error_submit = true;
            }
        };
        $scope.signup = function(user){
            $scope.error_submit = true;
            var filter = /^([a-zA-Z0-9_\.\-])+\@(([a-zA-Z0-9\-])+\.)+([a-zA-Z0-9]{2,4})+$/;
            if(!user){
                $scope.error_message = 'Please enter your name';
                return false;
            }
            if(!user.pass_1){
                $scope.error_message = 'Please enter a password';
                return false;
            }
            if(user.pass_1 !== user.pass_2){
                $scope.error_message = 'Passwords do not match';
                return false;
            }
            if(user.pass_1.length < 6){
                $scope.error_message = 'Password length is too short. Please enter at least six characters.';
                return false;
            }
            if(!user.email_1 || !filter.test(user.email_1)){
                $scope.error_message = 'Please enter a valid email address';
                return false;
            }
            if(user.email_1.toLowerCase() !== user.email_2.toLowerCase()){
                $scope.error_message = 'Email address does not match';
                return false;
            }
            var data = {
                "name": user.name,
                "email": user.email_1,
                "password": user.pass_1,
                "language": "en",
                "email_newsletter": 'true',
                "source": {
                    "device": "test",
                    "method": "standard",
                    "partner": "",
                    "platform": "firefoxOS"
                    },
                "incentives": ["1ict"]
            };
            authService.loginReq('/v4/users.json?app=' + api.app_id + '&t=' + api.currentTime(),data)
            .then(function(requested){
                console.log('signup data:',requested.data);
                redirect(requested);
            });
        };
        $scope.fbLogin = function(){
            window.location = 'https://www.facebook.com/dialog/oauth?client_id=145730428798132&redirect_uri=http://firefox.viki.com/redirect.php&response_type=token';
      
            $rootScope.$on('$locationChangeSuccess', function (){
                console.log('inside fb login');
                $rootScope.isFb = true;
                var hash = window.location.href,
                startPos = hash.indexOf('access_token=') + 'access_token='.length,
                endPos = Math.min(hash.indexOf('&expires_in=')),
                accessToken = hash.substring(startPos, endPos);
                $rootScope.fbToken = accessToken;
                if(!(accessToken.indexOf('app') > -1)){
                    var data = {
                        'facebook_token': accessToken
                    };
                    authService.loginReq('/v5/sessions.json?app=' + api.app_id + '&t=' + api.currentTime(),data)
                    .then(function(requested){
                        redirect(requested);
                    });
                }
            });
        };
        $scope.$on("$stateChangeStart", function(ev, to) {
            sessionStorage.setItem('tab', $scope.loginFields);
            if(to.name !== 'info'){
                sessionStorage.clear();
            }
        });
        function redirect(requested){
            if(requested.status !== 200 && requested.status !== 201){
             //   utils.status.show('Error logging in. Try again.');
             if(requested.data.vcode===7401){
                  utils.status.show("Account with this Email already exists");
             }else{
                utils.status.show(requested.data.error);
             }
                
                $scope.error_message =  requested.data.error;
                $scope.error_submit = true;
            }
            else{
                localStorage.setItem('authToken', requested.data.token);
                $rootScope.loginToken = requested.data.token;
                $rootScope.loginUser = requested.data.user;
                $rootScope.inSession = true;
                $state.go('activities');
            }
        }
    }]);
})();