(function (){
    'use strict';

    angular
    .module('viki-controllers')
    .controller('appVideoPlayer', ['$rootScope', '$scope', '$state', 'api', 'shareData', '$window', 'authService', 'postData', function($rootScope, $scope, $state, api, shareData, $window, authService, postData) {
        var watch_id;
        window.screen.mozLockOrientation("landscape");

     
        window.addEventListener("visibilitychange", function() {
               
            if(document.visibilityState!=="hidden" && $rootScope.currentState === 'player'){
               setFullScreenMode(); 
               
              window.screen.mozLockOrientation("landscape"); 
           
            }else{               
                     window.screen.mozLockOrientation("portrait");
                 }
            });
        window.addEventListener("resize", function() {
           console.log('window resized');
            if( $rootScope.currentState === 'player'){
                setFullScreenMode(); 
                
            }
        });
      
        var setFullScreenMode=function(){
            var elem = document.getElementById("player_page");
             
                if (elem.requestFullscreen) {
                  elem.requestFullscreen();
                  console.log("player:requestFullscreen();");
                } else if (elem.msRequestFullscreen) {
                 console.log("player:msRequestFullscreen();");
                  elem.msRequestFullscreen();
                } else if (elem.mozRequestFullScreen) {
                 console.log("player:mozRequestFullscreen();");
                  elem.mozRequestFullScreen();
                } else if (elem.webkitRequestFullscreen) {
                 console.log("player:webkitRequestFullscreen();");
                  elem.webkitRequestFullscreen();
                }    
        };
        setFullScreenMode();

        $scope.videoObj = shareData.getVideo() || {};
        if($scope.videoObj === undefined){
            $state.go('home');
        }
        if($scope.videoObj.watch_now){
            watch_id = $scope.videoObj.watch_now.id;
        }
        else{
            watch_id = $scope.videoObj.id;
        }
        if($rootScope.inSession){
            postData.toUrl('/v4/users/' + $rootScope.loginUser.id + '/activities.json?app=' + api.app_id + '&t=' + api.currentTime() + '&token=' + $rootScope.loginToken, {"type": "watch", "resource_id": watch_id});
        }
        if($scope.videoObj.embed){
            $scope.url = $scope.videoObj.embed.iframe.url+api.player_mobi_view+'&sl='+$rootScope.selectedLang+'&secondary_app_id=' + api.app_id + '&autostart=true';
        }
        else{
            $scope.url = api.player_url+$scope.videoObj.watch_now.id+api.player_mobi_view+'&sl='+$rootScope.selectedLang+'&secondary_app_id=' + api.app_id + '&autostart=true';
        }
        if($rootScope.subState === 'news'){
            $rootScope.prevToDetails = $rootScope.subState;
        }
        $scope.backto = function(){
            window.screen.mozLockOrientation("portrait");
     
            shareData.updateVideo($scope.videoObj);
            if($rootScope.previousState === 'home' || $rootScope.subState === 'news'){
                $state.go('detail-page');
            }
            else{
                $window.history.back();
            }
        };
    }]);
})();