(function (){
    'use strict';


    angular
    .module('viki-controllers')
    .controller('appSearchController', ['$scope', '$rootScope', '$window', 'api', 'getData', 'scrollVideos', function($scope, $rootScope, $window, api, getData, scrollVideos){
        var tempArrayOfVideos = [];

        $rootScope.$on("$routeChangeStart", function(){
            if (sessionStorage.restorestate === "true") {
                $rootScope.$broadcast('restorestate');
                //let everything know we need to restore state
                sessionStorage.restorestate = false;
            }
        });

        $scope.loadVideos = function(url,reset){
            if(reset){
                tempArrayOfVideos = [];
            }
            getData.fromUrl(url.replace(api.app_url,'') + '&t=' + api.currentTime()).then(function(requested){
                for (var i = 0; i < requested.data.response.length; i++) {
                    tempArrayOfVideos.push(requested.data.response[i]);
                }
                $scope.results = tempArrayOfVideos;
                $scope.next = requested.data.pagination.next;
            });
        };

        if($rootScope.query){
            $scope.isTyping = $scope.isTyping || ($rootScope.query.trim() !== '');
            if($rootScope.resultsFilter){

                $scope.searchFilter = [
                                { name1 : '', value : 'All'},
                                { name1 : 'series', name2 : 'episodes', value : 'Series'},
                                { name1 : 'film', name2 : 'movie', value : 'Movies'},
                                { name1 : 'news_clip', name2 : 'news', value : 'News Clips'}
                            ];

                $scope.searchFilter.forEach(function(obj, i){
                    if(obj.name1 === $rootScope.resultsFilter.name1 || obj.name1 === $rootScope.resultsFilter.name2){
                        $scope.resultsFilter = $scope.searchFilter[i];
                    }
                });
            }
            else if($scope.resultsFilter !== null || $scope.resultsFilter === ''){
                var pageObj = scrollVideos.getList() || {};
                if($.isEmptyObject(pageObj)){
                    var url = '/v4/search.json?term='+$rootScope.query+'&app=100350a&with_paging=true';
                    $scope.loadVideos(url,true);
                }else{
                    $scope.results = pageObj.loadedVideos;
                    tempArrayOfVideos = pageObj.loadedVideos;
                    $scope.next = pageObj.next;
                    setTimeout(function(){
                        angular.element('#videos_list').scrollTop(pageObj.position);
                    }, 100);
                }
            }
        }else{
            setTimeout(function(){
                // fix for syncing
                document.getElementById("search").focus();
            }, 100);
        }

        if(localStorage.getItem('history') !== null) {
            $scope.hasHistory = true;
            $scope.history = JSON.parse(localStorage.getItem('history'));
        }

        $scope.searchHistory = function(queryFromHistory) {
            document.getElementById('search').value = queryFromHistory;
            $scope.query = queryFromHistory;
            $scope.search('click');
        };

        if(!$rootScope.resultsFilter){
            $scope.searchFilter = [
                                { name1 : '', value : 'All'},
                                { name1 : 'series', name2 : 'episodes', value : 'Series'},
                                { name1 : 'film', name2 : 'movie', value : 'Movies'},
                                { name1 : 'news_clip', name2 : 'news', value : 'News Clips'}
                            ];
            $scope.resultsFilter = $scope.searchFilter[0];
        }

        $scope.updateFilter = function(){
            var url = '/v4/search.json?term='+$scope.query+'&app=100350a&with_paging=true';
            if($scope.resultsFilter.name1 !== ''){
                url += '&type='+ $scope.resultsFilter.name1;
            }
            $scope.loadVideos(url,true);
            $('#videos_list').scrollTop(0);
            $rootScope.resultsFilter = $scope.resultsFilter;
        };

        $scope.search = function() {
            if($scope.query.length <= 0){
                $scope.hasHistory = true;
                $scope.isTyping = false;
            }else{
                $scope.hasHistory = false;
                $scope.isTyping = true;
            }

            var url = '/v4/search.json?term='+$scope.query+'&app=100350a&with_paging=true';
            $scope.loadVideos(url,true);
            $rootScope.query = $scope.query;
        };

        // reset the filter when drawer is openned
        $scope.clearSearch = function(){
            document.getElementById("search").blur();
            $rootScope.results = "";
            $rootScope.resultsBackup = "";
            $rootScope.query = "";
            $rootScope.resultsFilter = '';

            $scope.results = "";
            $scope.resultsBackup = "";
            $scope.query = "";
            $scope.resultsFilter = '';
            setTimeout(function(){
                $window.history.back();
            },500);
        };

        $scope.checker = function(process_url1){
            $rootScope.results = $scope.results;
            api.process_url(process_url1);
        };

        $('main:not(.search-field)').bind('touchstart', function(){
            $('ul').focus();
        });

        $scope.$on("$stateChangeStart", function() {
            var temp = {
                loadedVideos : $scope.results,
                position : angular.element('.video-list').scrollTop(),
                next : $scope.next
            };
            scrollVideos.updateList(temp);
        });
    }]);

})();