(function(){
    'use strict';
    angular.module('all-directives', [])
    .directive('sidebar',function(){
        return {
            templateUrl : 'src/includes/sidebar.html',
            link: function(scope, element) {
                element.find("a").bind("click" , function(){
                     angular.element('.side-bars').trigger('click');
                });
            }
        };
    })
    .directive('header',function(){
        return {
            templateUrl : 'src/includes/header.html'
        };
    })
    .directive('searchbar',function(){
        return {
            templateUrl : 'src/includes/searchbar.html'
        };
    })
    .directive('drawer', function () {
        return {
            link: function ($scope, element) {
                element.bind('scroll', function () {
                    if(element[0].scrollTop === element[0].scrollHeight - element[0].clientHeight) {
                        $scope.loadVideos($scope.next,false);
                    }
                });
            }
        };
    })
    .directive('autoheight', ['$rootScope', function($rootScope){
        return {
            link: function(scope,element){
                if($rootScope.currentState !== 'search'){
                    window.screen.mozLockOrientation("portrait");
                    element.css('height', element.parent().outerHeight() - element.parent().children('header').outerHeight());
                }else{
                    element.css('height', element.parent().outerHeight() - element.parent().children('.main-header').outerHeight());
                }
            }
        };
    }])
    .directive('tick', function () {
        return {
            restrict : 'C',
            link: function(scope, element) {
                element.bind("click" , function(){
                     element.parent().find("li").removeClass("checked");
                     element.addClass("checked");
                });
            }
        };
    })
    .directive('headerColor', ['$rootScope', function ($rootScope) {
        return {
            restrict : 'C',
            link: function(scope, element) {
                switch($rootScope.previousState){
                    case 'home':
                        element.addClass('homeHeaderBG');
                        break;
                    case 'category':
                        if($rootScope.subState === 'movies'){
                            element.addClass('movieHeaderBG');
                        }
                        else if($rootScope.subState === 'tv'){
                            element.addClass('tvHeaderBG');
                        }
                        else if($rootScope.subState === 'news'){
                            element.addClass('newsHeaderBG');
                        }
                        break;
                    case 'player':
                    case 'detail-page':
                        if($rootScope.prevToDetails === 'movies'){
                            element.addClass('movieHeaderBG');
                        }
                        else if($rootScope.prevToDetails === 'tv'){
                            element.addClass('tvHeaderBG');
                        }
                        else if($rootScope.prevToDetails === 'news'){
                            element.addClass('newsHeaderBG');
                        }
                        break;
                    default:
                        element.addClass('homeHeaderBG');
                }
            }
        };
    }])
    .directive('loading',   ['$http' ,function ($http){
        return {
            restrict: 'A',
            link: function (scope, elm, attrs)
            {
                scope.isLoading = function () {
                    return $http.pendingRequests.length > 0;
                };

                scope.$watch(scope.isLoading, function (v)
                {
                    if(v){
                        elm.show();
                    }else{
                        elm.hide();
                    }
                });
            }
        };
    }]);
})();