/***	Common Elements - Header / Footer	***/
/***	Directives		***/
(function() {
	'use strict';
	
	var app = angular.module('slider', []);
	app
		.directive('bxSlider', function () {
		return {
			restrict: 'A',
			link: function (scope, element, attrs) {
				if(element.context.className == 'bxslider'){
					scope.$on('repeatFinished', function () { 
						element.bxSlider({
							mode: 'horizontal',
							auto: true,
							captions: true,
							touchEnabled: true, 
							pager: false, 
							controls: false, 
							minSlides: 1, 
							maxSlides:1,
							slideMargin:0, 
							infiniteLoop: true
						});
						
					});
				}
				else if(element.context.className == 'popularbxslider'){
					scope.$on('popularRepeatFinished', function () {
						element.bxSlider({
							mode: 'horizontal',
							touchEnabled: true, 
							captions: true,
							pager: false, 
							controls: false, 
							minSlides: 1, 
							maxSlides:3, 
							slideWidth: 110,
							//slideHeight: 50, 
							slideMargin:5, 
							infiniteLoop: false
						});
					
					});
				}
				else if(element.context.className == 'onairbxslider'){
					scope.$on('onairRepeatFinished', function () {
						element.bxSlider({
							mode: 'horizontal',
							captions: true,
							touchEnabled: true, 
							pager: false, 
							controls: false, 
							minSlides: 1, 
							maxSlides:3, 
							slideWidth: 110,
							//slideHeight: 50, 
							slideMargin:5, 
							infiniteLoop: false
						});
					
					});
				}
				else if(element.context.className == 'trendingbxslider'){
					scope.$on('trendingRepeatFinished', function () {
						element.bxSlider({
							mode: 'horizontal',
							captions: true,
							touchEnabled: true, 
							pager: false, 
							controls: false, 
							minSlides: 1, 
							maxSlides:3, 
							slideWidth: 110,
							//slideHeight: 50, 
							slideMargin:5, 
							infiniteLoop: false
						});
					
					});
				}
				else if(element.context.className == 'recentvideosbxslider'){
					scope.$on('recentVideosRepeatFinished', function () {
						element.bxSlider({
							mode: 'horizontal',
							captions: true,
							touchEnabled: true, 
							pager: false, 
							controls: false, 
							minSlides: 1, 
							maxSlides:3, 
							slideWidth: 110,
							//slideHeight: 50, 
							slideMargin:5, 
							infiniteLoop: false
						});
					
					});
				}
				else if(element.context.className == 'discovermorebxslider'){
					scope.$on('discoverMoreRepeatFinished', function () {
						element.bxSlider({
							mode: 'horizontal',
							captions: true,
							touchEnabled: true, 
							pager: false, 
							controls: false, 
							minSlides: 1, 
							maxSlides:3, 
							slideWidth: 110,
							//slideHeight: 50, 
							slideMargin:5, 
							infiniteLoop: false
						});
					
					});
				}
			}
		}
	})
	.directive('notifyWhenRepeatFinished', ['$timeout' ,function ($timeout) {
		return {
			restrict: 'A',
			link: function (scope, element, attr) {
				if (scope.$last === true) {
					if(element.context.classList[0] == 'slideElement'){
						$timeout(function () {
							scope.$emit('repeatFinished');
						});
					}
					else if(element.context.classList[0] == 'popularSlideElement'){
						$timeout(function () {
							scope.$emit('popularRepeatFinished');
						});
					}
					else if(element.context.classList[0] == 'onairSlideElement'){
						$timeout(function () {
							scope.$emit('onairRepeatFinished');
						});
					}
					else if(element.context.classList[0] == 'trendingSlideElement'){
						$timeout(function () {
							scope.$emit('trendingRepeatFinished');
						});
					}
					else if(element.context.classList[0] == 'recentVideosSlideElement'){
						$timeout(function () {
							scope.$emit('recentVideosRepeatFinished');
						});
					}
					else if(element.context.classList[0] == 'discoverMoreSlideElement'){
						$timeout(function () {
							scope.$emit('discoverMoreRepeatFinished');
						});
					}
				}
			}
		}
	}]);

})();
