(function(){
    'use strict';
    angular
    .module('all-filters', [])
    .filter('country_name', ['getData','api','$rootScope',function(getData,api,$rootScope) {
        return function (code) {
            if(code){
                return $rootScope.country[code].name.en;
            }
            else{
                return "NA";
            }
        };
    }])
    .filter('language_name', ['getData','api','$rootScope',function(getData,api,$rootScope) {
        return function (code) {
            if(code){
                return $rootScope.language[code].name.en;
            }
            else{
                return "NA";
            }
        };
    }])
    .filter('movie_type', function () {
        return function (type) {
        	var media = {
        			"TV": ["series", "episode"],
        			"NEWS": ["news_clip", "news"],
        			"MOVIE" : ["movie","film"]
        		};

        	for(var key in media) {
        		if(media.hasOwnProperty(key)) {
        			for(var i = 0, x = media[key].length; i < x; i++) {
        				if(media[key][i] === type){
        					return key;
        				}
        			}
        		}
        	}
        };
    })
    .filter('genre_name', ['getData','api','$rootScope',function(getData,api,$rootScope) {
        return function (id) {
            var genre = $rootScope.genre;
            if(id){
                for(var i=0; i<genre.length; i++){
                    if(genre[i].id === id){
                        return genre[i].name.en;
                    }
                }
            }
            else{
                return "NA";
            }
        };
    }])
    .filter('number_formatter', function () {
        return function (num) {
            return num.toString().replace(/\B(?=(\d{3})+(?!\d))/g, ",");
        };
    })
    .filter('heart_formatter', function () {
        return function (num) {
            if (num >= 1000){
                return num / 1000 + "k";
            }
            else{
                return num;
            }
        };
    })
    .filter('timeline', function () {
        return function (sec) {
            var diff = Math.floor(Date.now()/1000) - Math.round(new Date(sec)/1000);
            var i =0;
            var time = ['Just now', 'minute', 'hour', 'day', 'week', 'month', 'year'];
            if(diff>=60){
                diff/=60;
                i++;
                if(diff>=60){
                    diff/=60;
                    i++;
                    if(diff>=24){
                        diff/=24;
                        i++;
                        if(diff>=7){
                            diff/=7;
                            i++;
                            if(diff>=4){
                                diff/=4;
                                i++;
                                if(diff>=12){
                                    diff/=12;
                                    i++;
                                }
                            }
                        }
                    }
                }
            }
            else{
                return time[i];
            }
            if(Math.floor(diff)>1){
                time[i]+='s';
            }
            return Math.floor(diff) +' ' + time[i] + ' ago';
        };
    })
    .filter('main_slider_tile', function () {
        return function (url) {
            return url.replace(/x=b/i, "s=490x330&b=000000");
        };
    })
    .filter('mini_slider_tile', function () {
        return function (url) {
            return url.replace(/x=b/i, "s=320x200&b=000000");
        };
    })
    .filter('full_page_tile', function () {
        return function (url) {
            return url.replace(/x=b/i, "s=580x330&b=000000");
        };
    })
    .filter('preview_tile', function () {
        return function (url) {
            return url.replace(/x=b/i, "s=320x240&b=000000");
        };
    })
    .filter('can_display', function () {
        return function(videos){
            var filtered = [];
            angular.forEach(videos, function(video){

                if(!video.blocked && video.type === "film" || video.type === "news_clip" || video.type === "movie" || video.type === 'news' || video.type === 'episode' || (video.type === 'series' && video.episodes.count)){
                    filtered.push(video);
                }
                else if(!video.blocked && video.type === 'brick' && (video.resource.type === "film" || video.resource.type === "news_clip" || video.resource.type === "movie" || video.resource.type === 'news' || video.resource.type === 'episode' || (video.resource.type === 'series' && video.resource.episodes.count))){
                    filtered.push(video);
                }
            });
            return filtered;
        };
    });
})();