(function(){
    'use strict';
    angular
    .module('all-services', [])
    .service('getData', ['$http', 'api', function($http,api){
        this.fromUrl = function(path) {
            var requestedData = $http.get(api.app_url + path + '&sig=' + api.encryptPath(path),{ cache: true}).success(function(data){
                var getData = data;
                return getData;
            }).error(function(response){
                var getData = response;
                return getData;
            });
            return requestedData;
        };
    }])
    .service('preloadData', ['api','getData','$rootScope',function(api,getData,$rootScope){
        getData.fromUrl('/v4/countries.json?app=' + api.app_id + '&t=' + api.currentTime())
        .then(function(requested){
            $rootScope.country = requested.data;
        });
        getData.fromUrl('/v4/languages.json?app=' + api.app_id + '&t=' + api.currentTime())
        .then(function(requested){
            $rootScope.language = requested.data;
        });
        getData.fromUrl('/v4/containers/genres.json?app=' + api.app_id + '&t=' + api.currentTime())
        .then(function(requested){
            $rootScope.genre = requested.data;
        });
    }])
    .service('authService', ['$http', '$rootScope', '$state', '$q', 'api', function($http,$rootScope,$state,$q,api){
        var authService = {};
        authService.loginReq = function(url,body) {
            var authCall = $http.post(api.app_url + url + '&sig=' + api.encryptPath(url,body),body)
            .then(function(response){
                return response;
            })
            .catch(function(response){
                return response;
            });
            return authCall;
        };
        authService.retrieveSes = function(url) {
            var sessCall = $http.get(api.app_url + url + '&sig=' + api.encryptPath(url))
            .then(function(response){
                return response;
            })
            .catch(function(response){
                return response;
            });
            return sessCall;
        };
        authService.logoutReq = function() {
            var reqUrl = '/v5/sessions/'+ $rootScope.loginToken +'.json?token='+  $rootScope.loginToken + '&t=' + api.currentTime() + '&app=' + api.app_id;
            $http.delete(api.app_url + reqUrl + '&sig=' + api.encryptPath(reqUrl))
                .success(function(){
                    localStorage.removeItem('authToken');
                    $rootScope.inSession = false;
                    $rootScope.loginToken = '';
                    utils.status.show('Logged out successfully');
                  //  $state.go('home');
                })
                .error(function(){
                    utils.status.show('Error while logging out. Try again later.');
                });
        };
        return authService;
    }])
    .service('postData', ['$http', '$rootScope', '$q', 'api', function($http, $rootScope, $q, api){
        var postData = {};
        postData.toUrl = function(url,body) {
            var call = $http.post(api.app_url + url + '&sig=' + api.encryptPath(url,body),body)
            .then(function(response){
                return response;
            })
            .catch(function(response){
                return response;
            });
            return call;
        };
        postData.deleteItem = function(url) {
            var callStatus = $http.delete(api.app_url + url + '&sig=' + api.encryptPath(url))
            .success(function(response){
                return response;
            })
            .error(function(response){
                return response;
            });
            return callStatus;
        };
        return postData;
    }])
    .service('shareData', [function(){
        var videoDetails;

        var updateVideo = function(videoObj){
            videoDetails = videoObj;
        };

        var getVideo = function(){
            return videoDetails;
        };

        return {
            updateVideo: updateVideo,
            getVideo: getVideo
        };
    }])
    .service('shareFavorites', [function(){
        var videosList;

        var updateList = function(videosObj){
            videosList = videosObj;
        };

        var getList = function(){
            return videosList;
        };

        return {
            updateList: updateList,
            getList: getList
        };
    }])
    .service('scrollVideos', [function(){
        var videosList;

        var updateList = function(videosObj){
            videosList = videosObj;
        };

        var getList = function(){
            return videosList;
        };

        var destroyList = function(){
            videosList = null;
        };

        return {
            updateList: updateList,
            getList: getList,
            destroyList: destroyList
        };
    }]);
})();