(function(){
    'use strict';

    angular
    .module('api-params', [])
    .factory('api',['$state','shareData',function($state,shareData){
        return {
            app_id : '100350a',
            app_url : 'http://api.viki.io',
            app_urlv5 : 'http://api.viki.io/v5/',
            app_count : '20',
            player_url : 'http://www.viki.com/player/',
            player_mobi_view : '/?view_mobile=0',
            process_url : function(displayObj){
                            if(displayObj.type === 'episode' || displayObj.type === 'news_clip' || displayObj.type === 'movie'){
                                $state.transitionTo('player');
                                shareData.updateVideo(displayObj);
                            }
                            else{
                                $state.transitionTo('detail-page');
                                shareData.updateVideo(displayObj);
                            }
                        },
            currentTime : function(){
                return Math.floor(Date.now()/1000);
            },
            encryptPath : function(url,body){
                return CryptoJS.HmacSHA1(url + (body?JSON.stringify(body):''), '675333c444e4c64a9c07c466ee302f21c0127e7587992cd76d9416e109ad3d0b6013111cf420');
            }

        };
    }])
    .factory('searchState', ['$rootScope', function ($rootScope) {

        var service = {

            model: {
                query: '',
                results: '',
                filter: ''
            },

            SaveState: function () {
                sessionStorage.searchState = angular.toJson(service.model);
            },

            RestoreState: function () {
                service.model = angular.fromJson(sessionStorage.searchState);
            }
        };

        $rootScope.$on("savestate", service.SaveState);
        $rootScope.$on("restorestate", service.RestoreState);

        return service;
    }]);
})();