var vineApp = new function() {
	var _ = this;
	this.content = ".main-content";
	this.toolbar = ".title";
	this.searchInput = "#search-input";
	this.homeButton = "#home-button";
	this.currentURL = "";
	this.pageCount = 1;
	this.setNavTitle = function(title) {
		$(_.toolbar).html(title)
	}
	this.setLoadingState = function(element, state, appended) {
		if(state == "on" && ($(".icon-loading").length < 1)) {
			if(!appended) {
				$(element).html("<i class='icon-loading'></i>");
			}
			else {
				$("<div class='icon-loading-container'><i class='icon-loading relative'></i></div>").appendTo(element)
			}
		}
		else {
		}
	}
	this.localize = function(msg) {
  		return navigator.mozL10n.get(msg);
	}
	this.createAvatar = function(params) {
		var avatar = $("<div class='avatar'>").click(function() {
			if(params.onClick) {
				params.onClick()
			}
		});
		var icon = $("<img>").addClass("avatar-icon").attr("src",params.icon).appendTo(avatar);
		var name = $("<span class='author'>").html(params.name).appendTo(avatar);
		return avatar;
	}
	this.createVineCard = function(data) {
		var card = $("<div>").addClass("card").appendTo(_.content);
		var link = $("<a>").attr({"href":data.shareUrl,"target":"_blank"}).appendTo(card);
		var title = $("<h1>").html(data.description).appendTo(link);
		var video = $("<video>").attr({"controls":"","poster":data.thumbnailUrl}).html("<source src=\""+data.videoUrl+"\" type=\"video\/mp4\"><\/source>").appendTo(card);
		var avatar = _.createAvatar({
			"name":data.username,
			"icon":data.avatarUrl,
			"onClick": function() {
				_.loadUser(data.userId)
			}
		}).appendTo(card);
		var details = $("<div>").addClass("details").appendTo(card);
		var likes = $("<b>").html("<i class='icon-thumb-up'></i>"+data.likes.count).appendTo(details);
		var reposts = $("<b>").html("<i class='icon-share'></i>"+data.reposts.count).appendTo(details);
		var loops = $("<b>").html("<i class='icon-loop'></i>"+data.loops.count).appendTo(details);
	}
	this.loadTimeline = function(url,title, more) {
		var more = more || false;
		var state = more || false;
		_.setLoadingState(_.content, "on", state);
		$(".header").removeClass("persistent-search");
		if(!more) {
			_.pageCount = 1;
		}
		$.getJSON("http://query.yahooapis.com/v1/public/yql", 
		{
			q:      "select * from json where url=\""+url+"\"",
			format: "json"
		},
		function(data){
			if(!more) {
				$(_.content).html("")
			}
			else {
				$(".icon-loading, .icon-loading-container").remove();
			}

			if(data.query.results.json) {
				$.each(data.query.results.json.data.records, function(i,v) {
					_.createVineCard(v);
				});
			}
		}).error(function(data) {
			$(".icon-loading, .icon-loading-container").remove();
		}).fail(function(data) {
			$(".icon-loading, .icon-loading-container").remove();
		});
		_.currentURL = url;
		if(title) {
			_.setNavTitle(title);
		}
	}
	this.getUserData = function(id, callback) {
		var url = "https://api.vineapp.com/users/profiles/" + id;
		$.getJSON("http://query.yahooapis.com/v1/public/yql", 
		{
			q:      "select * from json where url=\""+url+"\"",
			format: "json"
		},
		function(data){
			callback(data.query.results.json.data);
		});
	}
	this.loadMore = function() {
		this.pageCount += 1;
		var url = this.currentURL + "?page=" + this.pageCount;
		_.loadTimeline(url, false, true);
	}
	this.loadUser = function(id) {
		$(_.toolbar).html("");
		_.setLoadingState(_.content, "on")
		_.getUserData(id, function(data) {
			var avatar = _.createAvatar({"icon": data.avatarUrl, "name":data.username});
			console.log(avatar, $("<div>").append(avatar.clone()).html())
			_.loadTimeline("https://api.vineapp.com/timelines/users/" + id, $("<div>").append(avatar.clone()).html());
		});
		
	}
	this.getPopular = function() {
		_.loadTimeline("https://api.vineapp.com/timelines/popular", _.localize("popular"));
	}
	this.searchQuery = function(query) {
		var url = "https://api.vineapp.com/timelines/tags/" + query;
		_.loadTimeline(url, _.localize("search"));
		$(".header").addClass("persistent-search")
	}
	this.init = function() {
		$(window).scroll(function() {
			if(($(window).scrollTop() == $(document).height() - $(window).height()) && ($(window).scrollTop() > ($(window).height() / 3))) {
				_.loadMore();
			}
		})
		$(".icon-search").on("click", function() {
			$(_.searchInput).focus();
			console.log("focus")
		})
		$(_.searchInput).val("").on("change", function() {
			_.searchQuery($(this).val());
			$(_.searchInput).blur();
		}).on("blur", function() {
			$(".header").removeClass("search")
		}).on("focus", function() {
			$(".header").addClass("search")
		})
		$(_.homeButton).on("click", function() {
			_.getPopular();
		})
		_.getPopular();
	}
}
$(function() {
	navigator.mozL10n.once(vineApp.init);
});