exports.init = function(globals) {

	return {
		
		silence: false,
		
		createSound: function(src) {
			
			var sound = new Audio(src);
			this.addBehavior(sound);
			return sound;
		},
		
		createLoop: function(src) {
			
			var sound = new Audio(src);
			sound.loop = true;
			
			this.addBehavior(sound);
			return sound;
		},
		
		addBehavior: function(sound) {
			
			sound.isPlaying = function() {
				
				var playing = !sound.paused;
				return playing;
			};
		}
		
	};
};
