function AdvMap(globals, startGamePlay){
	var view = {};
	var audioLoop = {};
	var win = Ti.UI.createWindow({
		orientationModes : [
	        Titanium.UI.LANDSCAPE_LEFT,
	        Titanium.UI.LANDSCAPE_RIGHT 
	    ]
	});

	win.setStarted = function(flag){
		advMap.started = flag;
	};
	var advMap = buildView(win, globals);
	
	advMap.startGamePlay = startGamePlay;
	
	win.addEventListener('close', advMap.onClose);
	
	advMap.show();
	return win;
}

exports.init = AdvMap;

function buildView(win, globals){
	var advMap = {
		view: {},
		scene: {},
		mapParts: {},
		audioLoop: {},
		target: 0,
		selectedId: 0,
		parts: [
			{x: 438, y: 333, w: 137, h: 104, cx: 75, cy: 54},
			{x: 434, y: 216, w: 91,  h: 156, cx: 44, cy: 117},
			{x: 507, y: 197, w: 85,  h: 184, cx: 40, cy: 152},
			{x: 599, y: 200, w: 134, h: 123, cx: 44, cy: 65},
			{x: 632, y: 305, w: 169, h: 179, cx: 58, cy: 69},
			{x: 704, y: 391, w: 192, h: 178, cx: 132, cy: 119},
			{x: 717, y: 276, w: 164, h: 165, cx: 99, cy: 96},
			{x: 716, y: 112, w: 166, h: 225, cx: 111, cy: 150},
			{x: 643, y: 76,  w: 206, h: 152, cx: 91, cy: 80},
			{x: 445, y: 78,  w: 215, h: 156, cx: 131, cy: 97},
			{x: 373, y: 154, w: 111, h: 203, cx: 67, cy: 127},
			{x: 277, y: 129, w: 165, h: 259, cx: 112, cy: 209},
			{x: 174, y: 140, w: 207, h: 281, cx: 146, cy: 198},
			{x: 65,  y: 171, w: 131, h: 342, cx: 84, cy: 184},
			{x: 167, y: 298, w: 176, h: 163, cx: 96, cy: 99},
			{x: 321, y: 327, w: 217, h: 169, cx: 81, cy: 96},
			{x: 516, y: 340, w: 189, h: 148, cx: 129, cy: 86},
			{x: 550, y: 434, w: 256, h: 92 , cx: 92, cy: 55},
			{x: 345, y: 427, w: 204, h: 105, cx: 118, cy: 56},
			{x: 168, y: 412, w: 195, h: 135, cx: 83, cy: 91},
			{x: 62,  y: 374, w: 126, h: 210, cx: 38, cy: 77}
		],
		hasToPlay: true,
		started: false,
		completed: false,
		popup: null,
		msgShown: false,
						
		show: function(){
			
			// view
			this.view = Ti.UI.createView({});
			//this.buildBackground();
			this.buildScene();
			this.buildNavigation();
			//this.buildBehavior();
			win.add(this.view);
			
			//audio
			var audioLoop = null;
			if (Ti.Platform.osname != "mobileweb") {
				audioLoop = Ti.Media.createSound({url: 'audio/menuB.mp3'});
			} else {
				audioLoop = globals.soundMgr.createLoop('audio/menuB.mp3');
			}
			this.audioLoop = audioLoop;
			
			win.addEventListener('android:back', this.goBack);
			win.addEventListener('postlayout', this.onPostLayout);
			win.addEventListener('focus', function(){
				if(globals.playsound && !advMap.audioLoop.isPlaying()){
					if(advMap.started){
						//advMap.audioLoop.setLooping(true);
						advMap.audioLoop.play();
					}else{
						advMap.hasToPlay = true;
						setTimeout(function(){
							if(advMap.hasToPlay){
								if(globals.playsound && !advMap.audioLoop.isPlaying()){
									//advMap.audioLoop.setLooping(true);
									advMap.audioLoop.play();
								}
							}
						}, 1000);
					}
				}
			});
			win.addEventListener('blur', function(){
				advMap.hasToPlay = false;
				if(globals.playsound && advMap.audioLoop.isPlaying()){
					//advMap.audioLoop.setLooping(false);
					advMap.audioLoop.pause();
				}
			});
			advMap.msgShown = Ti.App.Properties.getBool('msgShown');
		},
		
		onPostLayout: function(){
			if(!advMap.started){
				advMap.started = true;
				advMap.checkLevel();
				var mapParts = advMap.mapParts;
				//alert(mapParts.children.length);
				var lastpart = mapParts.children[mapParts.children.length-1];
				if (lastpart) {
					if (!globals.firefox) {
						advMap.animatePart(lastpart);
					}
				}
				if (advMap.startGamePlay) {
					var inf = globals.infantium;
					if (inf && inf.enabled) {
						var subcontent = inf.conf.subcontent_uuid.puzzles;
						globals.infantium.startGame(subcontent);
					}
				}
			}
		},
		
		animatePart: function(part){
			part.animate({
				width: part.width*1.3,
				height: part.height*1.3,
				duration: 500,
				autoreverse: true
			});
		},
		
		goBack: function(){
			
			if (advMap.popup && advMap.popup.opened) {
				advMap.popup.hide();
				return;
			}
			Ti.App.fireEvent('jumpTo', {target: globals.WIN_APPMENU, source: win, startInfantium: false});
		},
		
		onClose: function() {
			if (advMap.selectedId == 0) {
				var inf = globals.infantium;
				if (inf && inf.enabled) {
					globals.infantium.endGame();
				}
			}
			advMap.started = false;
			
			//remove view
			win.remove(advMap.view);
			
			/*
			advMap.audioLoop.setLooping(false);
			advMap.audioLoop.pause();
			var scene = advMap.view.children[2];
			var mapParts = scene.children[1];
			mapParts.remove(mapParts.children[0]);*/
		},
		
		jumpToPuzzle: function(id) {
			advMap.selectedId = id;
			advMap.stopSound();
			Ti.App.fireEvent('jumpTo', {target: globals.WIN_PUZZLE, puzzleId: id, source: win});
		},
		
		stopSound: function() {
			//if(globals.playsound && advMap.audioLoop.playing){
			if(globals.playsound && advMap.audioLoop.isPlaying()){
				//advMap.audioLoop.setLooping(false);
				advMap.audioLoop.pause();
			}
		},
		
		buildBackground: function(){
			advMap.view.add(Ti.UI.createImageView({
				image: '/images/common/advmap/map-off.jpg',
				//width: globals.platformWidth,
				//height: globals.platformHeight
				width: Math.floor(1.3*800*globals.screenRatio),
				height: Math.floor(1.3*480*globals.screenRatio)
			}));
		},
		
		buildScene: function(){
			
			var scrollView = Ti.UI.createScrollView({
				disableBounce: true,
				contentOffset: {
					x: Math.floor(0.5*1.3*800*globals.screenRatio - 0.5*globals.platformWidth),
					y: Math.floor(0.5*1.3*480*globals.screenRatio - 0.5*globals.platformHeight)
				}
			});
			var scene = Ti.UI.createView({
				width: Math.floor(1.3*800*globals.screenRatio),
				height: Math.floor(1.3*480*globals.screenRatio)
			});
			scene.add(Ti.UI.createImageView({
				image: '/images/common/advmap/map-off.jpg',
				width: Math.floor(1.3*800*globals.screenRatio),
				height: Math.floor(1.3*480*globals.screenRatio)
			}));
			advMap.scene = scene;
			scrollView.add(scene);
			advMap.view.add(scrollView);
		},
		
		buildNavigation: function(){
			
			var backButton = Ti.UI.createImageView({
				image:'/images/common/navigation/back.png',
				top:5*globals.screenRatio,
				left:5*globals.screenRatio,
				width:72*globals.screenRatio,
				height:72*globals.screenRatio,
				zIndex: 99
			});
			backButton.addEventListener('touchstart',function(){
				if(globals.playsound){
					globals.audioButton.play();
				}
				advMap.goBack();
			});
			advMap.view.add(backButton);
		},
		
		buildPart: function(part, id) {
			
			return Ti.UI.createImageView({
				puzzleId: id,
				image: '/images/common/advmap/'+id+'.png',
				width: Math.floor(1.3 * part.w * globals.screenRatio),
				height: Math.floor(1.3 * part.h * globals.screenRatio),
				/*center: {
					x: part.x * globals.widthRatio, 
					y: part.y * globals.screenRatio
				},*/
				left: 1.3 * (part.x - 0.5 * part.w) * globals.screenRatio,
				top: 1.3 * (part.y - 0.5 * part.h) * globals.screenRatio
			});
		},
		
		buildHandle: function(part, id) {
			var handle = Ti.UI.createView({
				puzzleId: id,
				width: 1.3 * 50 * globals.screenRatio,
				height: 1.3 * 50 * globals.screenRatio,
				/*center: {
					x: (part.x - 0.5*part.w + part.cx) * globals.widthRatio, 
					y: (part.y - 0.5*part.h + part.cy) * globals.screenRatio
				},*/
				//backgroundColor: '#fc0',
				//opacity: 0.5,
				left: 1.3 * (part.x - 0.5*part.w + part.cx - 25) * globals.screenRatio, 
				top: 1.3 * (part.y - 0.5*part.h + part.cy - 25) * globals.screenRatio
			});
			handle.addEventListener('touchstart', function() {
				if(globals.playsound){
					globals.audioButton.play();
				}
				if (!globals.fullversion && handle.puzzleId >= globals.puzzleIds.length + 1) {
					advMap.showCompleted();
				} else {
					advMap.jumpToPuzzle(globals.puzzleIds[handle.puzzleId-1]);
				}
			});
			return handle;
		},
		
		checkLevel: function(){
			
			var scene = advMap.scene;
			var mapParts = Ti.UI.createView({});
			var handles = Ti.UI.createView({});
			
			var nCurrentParts = mapParts.children.length;
			var currentLevel = Ti.App.Properties.getInt('currentLevel');
			if (!currentLevel || currentLevel<1) {
				currentLevel = 1;
			}
			for(var i=0; i<advMap.parts.length && i<currentLevel; i++){	
				var part = advMap.parts[i];
				var partView = advMap.buildPart(part, i+1);
				mapParts.add(partView);
				var handle = advMap.buildHandle(part, i+1);
				handles.add(handle);
			}
			advMap.scene.add(mapParts);
			advMap.mapParts = mapParts;
			advMap.scene.add(handles);
			if(currentLevel > globals.puzzleIds.length){
				advMap.completed = true;
				advMap.showCompleted();
			}
		},
		
		showCompleted: function() {
			var title, msg, link;
			if (globals.fullversion) {
				if (advMap.msgShown) {
					return;
				}
				title = (globals.firefox) ? 'Congratulations!' : L('finish_full_title');
				msg = (globals.firefox) ? 'You have solved all the puzzles of the adventure. Play again whenever you want!' : L('finish_full_msg');
			} else {
				title = (globals.firefox) ? 'More puzzles' : L('finish_lite_title');
				msg = (globals.firefox) ? 'Get more puzzles and characters in the full version of Vito Puzzles.' : L('finish_lite_msg');
			}
			var layout = Ti.UI.createView({
				layout: 'vertical',
				width: 400*globals.screenRatio,
				height: 220*globals.screenRatio
			});
			layout.add(Ti.UI.createLabel({
				text: title,
				height: 40*globals.screenRatio,
				top: 30*globals.screenRatio,
				textAlign: 'center',
				font: {fontSize: 34*globals.screenRatio, fontFamily: globals.fontFamily, fontWeight: 'bold'},
				color: '#fff'
			}));
			layout.add(Ti.UI.createLabel({
				text: msg,
				width: '90%',
				height: 110*globals.screenRatio,
				textAlign: 'left',
				font: {fontSize: 22*globals.screenRatio},
				color: '#333'
			}));
			var popup = require('ui/Popup').Popup(globals);
			popup.setLayout(layout);
			advMap.view.add(popup);
			advMap.popup = popup;
			popup.open({autoClose: true, exitOnTouch: true});
			advMap.msgShown = true;
			if (globals.fullversion) {
				Ti.App.Properties.setBool('msgShown', true);
			}
		}
		
	};
	return advMap;
}