
Ti.UI.orientation = Ti.UI.LANDSCAPE_LEFT;

// game conf

var withInfantium = false;
var fullversion = true;
var firefox = true;
var puzzleIds = fullversion ?
	['dog', 'farmgirl', 'farmboy', 'cat', 'sheep', 'scarecrow', 'skunk', 'squirrel', 'owl', 'crow', 'mouse', 'rabbit', 'hedgehog', 'goat', 'hen', 'turkey', 'pig', 'goose', 'cow', 'horse', 'wolf']
	:
	['dog', 'farmgirl', 'farmboy', 'cat', 'sheep', 'scarecrow', 'skunk', 'squirrel'];


// display props

var appMenu, practice, advMap, quickMap, puzzle, gallery;
//var currentWinId = 1;
var screenWidth = Ti.Platform.displayCaps.platformWidth;
var screenHeight = Ti.Platform.displayCaps.platformHeight;
if(screenWidth < screenHeight) {
	var tmp = screenWidth;
	screenWidth = screenHeight;
	screenHeight = tmp;
}
var contentWidth = 4/3 * screenHeight;
var contentMargin = 0.5 * (screenWidth - contentWidth);
		

// stored props

var playsound = Ti.App.Properties.getString('volume');
var storedWithInfantium = withInfantium ? Ti.App.Properties.getString('infantium') : null;
var currentLevel = Ti.App.Properties.getInt('currentLevel');
var globalLevel = Ti.App.Properties.getInt('globalLevel');

var soundMgr = require('SoundMgr').init();
var buttonSound = null;
if (Ti.Platform.osname != "mobileweb") {
	buttonSound = Ti.Media.createSound({url: 'audio/click.mp3', allowBackground: true});
} else {
	buttonSound = soundMgr.createSound('audio/click.mp3');
}


// globals

var globals = {
	platformWidth: screenWidth,
	platformHeight: screenHeight,
	widthRatio: screenWidth / 800,
	screenRatio: screenHeight / 480,
	audioButton: buttonSound,
	playsound: (playsound == 'Off') ? false : true,
	//playsound: true,
	currentLevel: currentLevel ? currentLevel : 0,
	globalLevel: globalLevel ? globalLevel : 0,
	puzzleIds: puzzleIds,
	fontFamily: 'PWFicelles',
	EXIT_APP: -1,
	WIN_APPMENU: 1,
	WIN_PRACTICE: 2,
	WIN_ADVMAP: 3,
	WIN_PUZZLE: 4,
	WIN_GALLERY: 5,
	infantium: withInfantium ? require('infantium3').init() : null,
	withInfantium: withInfantium,
	storedWithInfantium: (storedWithInfantium==='On'), 
	contentWidth: contentWidth,
	contentMargin: contentMargin,
	fullversion: fullversion,
	menuStarted: false,
	firefox: firefox,
	soundMgr: soundMgr
};


// app controller

Ti.App.addEventListener('jumpTo', function(data) {
	
	if(data.target == globals.EXIT_APP){
		mainwin.close();
	}else{
		var newwin;
		switch(data.target) {
			case globals.WIN_PRACTICE:
				newwin = require('shapes').init(globals);
				break;
			case globals.WIN_ADVMAP:
				newwin = require('advMap').init(globals, data.startGamePlay);
				newwin.setStarted(false);
				break;
			case globals.WIN_PUZZLE:
				newwin = require('puzzle').init(globals);
				newwin.setPuzzle(data);
				break;
			case globals.WIN_GALLERY:
				newwin = require('gallery').init(globals);
				break;
			default:
				newwin =  require('appMenu').init(globals, data.startInfantium);
		}
		newwin.started = false;
		newwin.addEventListener('postlayout', function() {
			if (!newwin.started && data.source) {
				data.source.close();
				data.source = null;
				newwin.started = true;
			}
		});
		newwin.open({animation: false});
	}
});


// root window

var appstarted = false;
var mainwin = Ti.UI.createWindow({
	title: L('app_title'),
	exitOnClose: true,
	navBarHidden: true,
	fullscreen: true,
	orientationModes : [
        Titanium.UI.LANDSCAPE_LEFT,
        Titanium.UI.LANDSCAPE_RIGHT 
    ],
    backgroundColor: '#fff'
});

if (globals.firefox) {
	if (screen.mozLockOrientation) {
		screen.mozLockOrientation("landscape");
	}
}
	
mainwin.addEventListener('postlayout', function() {
	
	
	
	if (!appstarted) {
	
		appstarted = true;
	
		/*if (globals.firefox) {
			if (screen.mozLockOrientation) {
				screen.mozLockOrientation("landscape");
			}
		}*/
		
		//appPresentation.open();
		if (globals.infantium) {
			this.activity.addEventListener('resume', function(e) {
				globals.infantium.sdk.resume();
			});
			this.activity.addEventListener('pause', function(e) {
				globals.infantium.sdk.pause();
			});
		}
	}
});

var appPresentation = require('appPresentation').init(globals);
//mainwin.open({animation: false});
appstarted = true;
appPresentation.open();


