exports.init = function(globals) {
	
	var win = Ti.UI.createWindow({
		backgroundColor: '#fff'/*,
		orientationModes : [
	        Titanium.UI.LANDSCAPE_LEFT,
	        Titanium.UI.LANDSCAPE_RIGHT 
	    ]*/
	});
	
	var appPresentation = buildView(win, globals);
	
	win.addEventListener('touchstart', function() {
		appPresentation.jumpToMenu();
	});
	win.addEventListener('android:back', function(){
		Titanium.Android.currentActivity.finish();
	});
	//win.addEventListener('postlayout', appPresentation.onPostLayout);
	
	appPresentation.show();
	return win;
};

function buildView(win, globals) {

	var appPresentation = {
		
		view: {},
		logo: {},
		started: false,
		closed: false,
		
		show: function(){

			appPresentation.view = Ti.UI.createView({});
			
			var logo = Ti.UI.createImageView({
				image: '/images/common/vitopuzzles.jpg',
				width: 200*globals.screenRatio,
				height: 247*globals.screenRatio
			});
			appPresentation.logo = logo;
			appPresentation.view.add(logo);
			
			win.addEventListener('postlayout', appPresentation.onPostLayout);
			
			win.add(appPresentation.view);
		},
		
		onPostLayout: function(){
			
			if(!appPresentation.started){
				appPresentation.started = true;
				//appPresentation.view.removeEventListener('postlayout', appPresentation.onPostLayout);
				appPresentation.startAnimation();
			}
		},
		
		jumpToMenu: function() {
			appPresentation.closed = true;
			Ti.App.fireEvent('jumpTo', {target: globals.WIN_APPMENU, source: win, startInfantium: true});
		},
		
		startAnimation: function() {
			appPresentation.logo.opacity = 1;
			appPresentation.logo.animate({
				opacity: 0,
				duration: 3000,
				delay: 1000
			}, function(){
				if (!appPresentation.closed) {
					appPresentation.logo.opacity = 0;
					appPresentation.jumpToMenu();
				}
			});
		}
	};
	return appPresentation;
}
