exports.init = function(globals) {

	var win = Ti.UI.createWindow({
		orientationModes : [
	        Titanium.UI.LANDSCAPE_LEFT,
	        Titanium.UI.LANDSCAPE_RIGHT 
	    ]
	});
	
	var obj = getViewObj(win, globals);
	
	win.addEventListener('android:back', obj.goBack);
	win.addEventListener('postlayout', obj.onPostLayout);
	win.addEventListener('close', obj.onClose);
	win.addEventListener('focus', obj.onFocus);
	win.addEventListener('blur', obj.onBlur);
	
	obj.buildView();
	return win;
};

var trashSound = null;
var pictureSound = null;
if (Ti.Platform.osname != "mobileweb") {
	trashSound = Ti.Media.createSound({url: 'audio/trash.mp3'});
	pictureSound = Ti.Media.createSound({url: 'audio/picture.mp3'});
} else {
	trashSound = soundMgr.createSound('audio/trash.mp3');
	pictureSound = soundMgr.createSound('audio/picture.mp3');
}

function getViewObj(win, globals){
	var gallery = {
		view: {},
		scene: {},
		popup: {},
		mosaic: {},
		backButton: {},
		picButton: {},
		trashButton: {},
		trashButtonBig: {},
		audioLoop: {},
		trashSound: trashSound,
		pictureSound: pictureSound,
		target: 0,
		maxPartIndex: 1,
		started: false,
		//mosaic
		mosaicId: 0,
		itemIds: [
			['dog', 'farmgirl', 'farmboy', 'cat', 'sheep', 'scarecrow', 'skunk', 'squirrel'],
			['owl', 'crow', 'mouse', 'rabbit', 'hedgehog', 'goat', 'hen', 'turkey'],
			['pig', 'goose', 'cow', 'horse', 'wolf', null, null, null] 
		],
		selectMosaic: null,
		backButton: null,
		nextButton: null,
		sound: {
			'dog' : {}, 
			'farmgirl' : {},
			'farmboy' : {},
			'cat' : {},
			'sheep' : {},
			'scarecrow' : {},
			'skunk' : {},
			'squirrel' : {},
			'owl' : {},
			'crow' : {},
			'mouse' : {},
			'rabbit' : {},
			'hedgehog' : {},
			'goat' : {},
			'hen' : {},
			'turkey' : {},
			'pig' : {},
			'goose' : {},
			'cow' : {},
			'horse' : {},
			'wolf' : {}
		},
		buildView: function(){
			
			// view
			this.view = Ti.UI.createView({});
			this.buildBackground();
			this.buildScene();
			this.resetGame();
			this.buildNavigation();
			this.buildMosaic();
			this.buildPopup();
			this.buildBehavior();
			win.add(this.view);
			
			// audio
			if (Ti.Platform.osname != "mobileweb") {
				this.audioLoop = Ti.Media.createSound({url: 'audio/game.mp3', volume: 0.5});
				gallery.loadSounds();
			} else {
				this.audioLoop = soundMgr.createLoop('audio/game.mp3'),
				gallery.loadWebSounds();
			}
		},
		
		goBack: function(){
			Ti.App.fireEvent('jumpTo', {target: globals.WIN_APPMENU, source: win, startInfantium: false});
		},
		
		onPostLayout: function(){
			if(!gallery.started){
				gallery.started = true;
				//gallery.resetGame();
				/*gallery.showStartPanel(function() {
					var inf = globals.infantium;
					if (inf && inf.enabled) {
						var subcontent = inf.conf.subcontent_uuid.gallery;
						inf.startGame(subcontent);
						globals.infantium.startTime();
					}
				});*/
			}
		},
		
		onClose: function() {
			var inf = globals.infantium;
			if (inf && inf.enabled) {
				globals.infantium.sendData();
				globals.infantium.endGame();
			}
			gallery.started = false;
		},
		
		onFocus: function() {
			if(globals.playsound && !gallery.audioLoop.isPlaying()){
				if(gallery.started){
					//gallery.audioLoop.setLooping(true);
					gallery.audioLoop.play();
				}else{
					gallery.hasToPlay = true;
					setTimeout(function(){
						if(gallery.hasToPlay && globals.playsound && !gallery.audioLoop.isPlaying()){
							//gallery.audioLoop.setLooping(true);
							gallery.audioLoop.play();
						}
					}, 1000);
				}
			}
		},
		
		onBlur: function() {
			gallery.hasToPlay = false;
			if(globals.playsound && gallery.audioLoop.isPlaying()){
				//gallery.audioLoop.setLooping(false);
				gallery.audioLoop.pause();
			}
		},
		
		loadSounds: function() {
			var ids = globals.puzzleIds;
			var nIds = ids.length;
			for (var i=0; i<nIds; i++) {
				var id = ids[i];
				gallery.sound[id] = {
					tracks: [
						Ti.Media.createSound({url: 'audio/voices/'+id+'1.mp3'}),
						Ti.Media.createSound({url: 'audio/voices/'+id+'2.mp3'}),
						Ti.Media.createSound({url: 'audio/voices/'+id+'3.mp3'})
					],
					num: 0
				}; 
			}
		},
		
		loadWebSounds: function() {
			var ids = globals.puzzleIds;
			var nIds = ids.length;
			for (var i=0; i<nIds; i++) {
				var id = ids[i];
				gallery.sound[id] = {
					tracks: [
						soundMgr.createSound('audio/voices/'+id+'1.mp3'),
						soundMgr.createSound('audio/voices/'+id+'2.mp3'),
						soundMgr.createSound('audio/voices/'+id+'3.mp3')
					],
					num: 0
				}; 
			}
		},
		
		playSound: function(id) {
			if (globals.playsound) {
				var sound = gallery.sound[id];
				if(sound.tracks[sound.num]){
					sound.tracks[sound.num].play();
				}
				sound.num = (sound.num > 1) ? 0 : sound.num + 1;
			}
		},
		
		buildBackground: function(){
			gallery.view.add(Ti.UI.createImageView({
				image: '/images/common/farm.jpg',
				width: Math.floor(1.3*800*globals.screenRatio),
				height: Math.floor(1.3*480*globals.screenRatio)
			}));
		},
		
		buildScene: function(){
			var scene = Ti.UI.createView({});
			scene.add(Ti.UI.createView({	// child[0] - puzzle title
			}));
			scene.add(Ti.UI.createView({}));	// child[1] - play area
			scene.add(Ti.UI.createView({		// child[2] - border
				borderColor: '#fff',
				borderWidth: 10*globals.screenRatio,
				visible: false
			}));	
			scene.add(Ti.UI.createView({}));	// child[3] - touch area
			
			// add scene
			gallery.scene = scene;
			gallery.view.add(scene);
			
			// popup
			var popup = require('ui/Popup').Popup(globals);
			gallery.popup = popup;
			gallery.view.add(popup);
		},
		
		buildNavigation: function(){
			
			// back button
			var backButton = Ti.UI.createImageView({
				image: '/images/common/navigation/back.png',
				top: 5*globals.screenRatio,
				left: 5*globals.screenRatio,
				width: 72*globals.screenRatio,
				height: 72*globals.screenRatio
			});
			backButton.addEventListener('touchstart',function(){
				if(globals.playsound){
					globals.audioButton.play();
				}
				gallery.goBack();
			});
			gallery.backButton = backButton;
			gallery.view.add(backButton);
			
			// picture button
			if (!globals.firefox) {
				var picButton = Ti.UI.createImageView({
					image: '/images/common/navigation/camera.png',
					top: 5*globals.screenRatio,
					right: 5*globals.screenRatio,
					width: 72*globals.screenRatio,
					height: 72*globals.screenRatio
				});
				picButton.addEventListener('touchstart',function(){
					if(globals.playsound){
						globals.audioButton.play();
					}
					gallery.takeScreenshot();
				});
				gallery.picButton = picButton;
				gallery.view.add(picButton);
			}
			
			// trash button
			var trashButton = Ti.UI.createImageView({
				image:'/images/common/wolf-trash-off.png',
				bottom:0,
				right:0,
				width:103*globals.screenRatio,
				height:129*globals.screenRatio
			});
			trashButton.addEventListener('touchstart',function(){
				var trashButton = gallery.trashButton;
				var trashButtonBig = gallery.trashButtonBig;
				trashButtonBig.show();
				trashButton.hide();
				setTimeout(function(){
					trashButtonBig.hide();
					trashButton.show();
				}, 4000);
			});
			gallery.trashButton = trashButton;
			gallery.view.add(trashButton);
		
			// trash button big
			var trashButtonBig = Ti.UI.createImageView({
				image:'/images/common/wolf-trash-on.png',
				bottom:0,
				right:0,
				width:150*globals.screenRatio,
				height:150*globals.screenRatio,
				visible: false
			});
			gallery.trashButtonBig = trashButtonBig;
			gallery.view.add(trashButtonBig);
		},
		
		buildPopup: function() {
			var popup = require('ui/Popup').Popup(globals);
			gallery.popup = popup;
			gallery.view.add(popup);
			gallery.showStartPanel(function() {
				var inf = globals.infantium;
				if (inf && inf.enabled) {
					var subcontent = inf.conf.subcontent_uuid.gallery;
					inf.startGame(subcontent);
					globals.infantium.startTime();
				}
			});
		},
		
		buildBehavior: function(){
			var scene = gallery.scene;
			var selectMosaic = gallery.mosaic;
			var playArea = scene.children[1];
			var touchArea = scene.children[3];
			var cutButton = gallery.trashButton;
			var cutButtonBig = gallery.trashButtonBig;
			var cutButtonArea = 72*globals.screenRatio;
						
			var inf = globals.infantium;
			
			touchArea.addEventListener('singletap', function(e) {	
				/*var children = playArea.children;
				var nChildren = children.length;
				var firstPart = {};
				var maxZIndex = 0;
				for(var i=0; i<nChildren; i++){
					var partView = children[i];
					var widthHalf = partView.width/2;
					var heightHalf = partView.height/2;
					if ( (e.x > partView.center.x - widthHalf) && (e.x < partView.center.x + widthHalf) ){
						if ( (e.y > partView.center.y - heightHalf) && (e.y < partView.center.y + heightHalf) ){
							if(partView.zIndex > maxZIndex){
								maxZIndex = partView.zIndex;
								firstPart = partView;
							}
						}
					}
				}
				if(firstPart.zIndex) {
					if (inf && inf.enabled) {
						globals.infantium.addElementTap(firstPart.id);
					}
				} else {
					if (inf && inf.enabled) {
						globals.infantium.addNoElementTap({
							x: Math.round(e.x), 
							y: Math.round(e.y)
						});
					}
					if(selectMosaic.visible){
						selectMosaic.hide();
					}else{
						selectMosaic.show();
					}
				}*/
				
				if(selectMosaic.visible){
					selectMosaic.hide();
				}else{
					selectMosaic.show();
				}
			});
			/*touchArea.addEventListener('touchstart',function(e){
				var children = playArea.children;
				var nChildren = children.length;
				var firstPart = {};
				var maxZIndex = 0;
				for(var i=0; i<nChildren; i++){
					var partView = children[i];
					var widthHalf = partView.width/2;
					var heightHalf = partView.height/2;
					if ( (e.x > partView.center.x - widthHalf) && (e.x < partView.center.x + widthHalf) ){
						if ( (e.y > partView.center.y - heightHalf) && (e.y < partView.center.y + heightHalf) ){
							if(partView.zIndex > maxZIndex){
								maxZIndex = partView.zIndex;
								firstPart = partView;
							}
						}
					}
				}
				if(firstPart.zIndex){
					
					// play sound
					if(globals.playsound){
						gallery.playSound(firstPart.itemId);
					}
										
					// select part
					playArea.selectedPart=firstPart;
					
					//reorder part indexs
					var prevIndex = firstPart.zIndex;
					for(var i=0; i<nChildren; i++){
						var partView=children[i];
						if(partView.zIndex >= prevIndex){
							partView.zIndex = partView.zIndex - 1;
						} 
					}
					firstPart.zIndex = gallery.maxPartIndex;
					firstPart.moving = false;
				}		
			});*/
			/*touchArea.addEventListener('touchmove',function(e){
				var selectedPart = playArea.selectedPart;
				if(selectedPart && selectedPart.move){
					selectedPart.center = {
						x: Math.round(e.x),
						y: Math.round(e.y)
					};
					if (!selectedPart.moving) {
						var inf = globals.infantium;
						if (inf && inf.enabled) {
							globals.infantium.startDragging({
								id: selectedPart.id,
								x1: selectedPart.center.x,
								y1: selectedPart.center.y
							});
						}
						selectedPart.moving = true;
					}
					if(e.x > globals.platformWidth - cutButtonArea - 50*globals.screenRatio	&&
						 e.y > globals.platformHeight - cutButtonArea - 50*globals.screenRatio){
						if(!cutButtonBig.visible){
							cutButtonBig.show();
							cutButton.hide();	
						}
					}else{
						if(cutButtonBig.visible){
							cutButton.show();
							cutButtonBig.hide();	
						}
					}
				}
			});
			touchArea.addEventListener('touchend',function(e){
				if(playArea.selectedPart){
					if(cutButtonBig.visible){
						if(globals.playsound){
							gallery.trashSound.play();
						}
						//remove selected part
						var selectedPart = playArea.selectedPart;
						playArea.remove(selectedPart);
						cutButton.show();
						cutButtonBig.hide();
						if (selectedPart.moving) {
							var inf = globals.infantium;
							if (inf && inf.enabled) {
								globals.infantium.endDragging({
									x2: Math.round(selectedPart.center.x),
									y2: Math.round(selectedPart.center.y)
								}, 'success');
							}
						}
					} else {
						var selectedPart = playArea.selectedPart;
						if (selectedPart.moving) {
							var inf = globals.infantium;
							if (inf && inf.enabled) {
								globals.infantium.endDragging({
									x2: Math.round(selectedPart.center.x),
									y2: Math.round(selectedPart.center.y)
								});
							}
						}
					}
					playArea.selectedPart = null;
				}
			});*/
		},
		
		buildMosaic: function(){
			var imgSize = 93;
			var map = [
				[136, 4],
				[234, 31],
				[270, 126],
				[234, 222],
				[136, 254],
				[39, 221],
				[3, 126],
				[39, 31]
			];
			
			var selectMosaic = Ti.UI.createView({
				width: 366*globals.screenRatio,
				height: 350*globals.screenRatio,
				visible: false
			});
			
			var bg = Ti.UI.createImageView({
				image: '/images/common/mosaic/mosaic-0.png',
				width: 366*globals.screenRatio,
				height: 350*globals.screenRatio,
			});
			selectMosaic.bg = bg;
			selectMosaic.add(bg);
			for (var i=0; i<8; i++) {
				selectMosaic.add(gallery.buildMosaicItem(i, map[i], globals));
			}
			if (globals.fullversion) {
				var buttonsize = 55*globals.screenRatio;
				var back = Ti.UI.createImageView({
					image: '/images/common/navigation/back.png',
					left: (183-55-5)*globals.screenRatio,
					width: buttonsize,
					height: buttonsize,
					visible: false
				});
				back.addEventListener('touchstart', function() {
					var mosaicId = gallery.mosaicId;
					if (mosaicId == 1) {
						gallery.selectMosaic.bg.image = '/images/common/mosaic/mosaic-0.png';
						gallery.backButton.visible = false;
						gallery.mosaicId = 0;
					} else if (mosaicId == 2) {
						gallery.selectMosaic.bg.image = '/images/common/mosaic/mosaic-1.png';
						gallery.nextButton.visible = true;
						gallery.mosaicId = 1;				
					}
				});
				selectMosaic.add(back);
				gallery.backButton = back;
				
				var next = Ti.UI.createImageView({
					image: '/images/common/navigation/next.png',
					left: (183+5)*globals.screenRatio,
					width: buttonsize,
					height: buttonsize
				});
				next.addEventListener('touchstart', function() {
					var mosaicId = gallery.mosaicId;
					if (mosaicId == 0) {
						gallery.selectMosaic.bg.image = '/images/common/mosaic/mosaic-1.png';
						gallery.backButton.visible = true;
						gallery.mosaicId = 1;
					} else if (mosaicId == 1) {
						gallery.selectMosaic.bg.image = '/images/common/mosaic/mosaic-2.png';
						gallery.nextButton.visible = false;
						gallery.mosaicId = 2;
					}
				});
				selectMosaic.add(next);
				gallery.nextButton = next;
			}
			gallery.selectMosaic = selectMosaic;
			gallery.mosaic = selectMosaic;
			gallery.view.add(selectMosaic);
		},
		
		buildMosaicItem: function(n, pos, globals) {
			var imgSize = 93*globals.screenRatio;
			var item = Ti.UI.createView({ 
				index: n,
				width: imgSize,
				height: imgSize,
				left: pos[0]*globals.screenRatio,
				top: pos[1]*globals.screenRatio
			});
			item.addEventListener('singletap', function(e){
				if(globals.playsound){
					globals.audioButton.play();
				}
				gallery.addMosaicItem(gallery.itemIds[gallery.mosaicId][this.index]);
			});
			return item;
		},
		
		addMosaicItem: function(itemId){
			var scene = gallery.scene;
			var selectMosaic = gallery.mosaic;
			var playArea = scene.children[1];
			
			selectMosaic.hide();
			
			var center = selectMosaic.center;
			/*var partView = Ti.UI.createImageView({
				image: '/images/common/models-150/'+itemId+'.png',
				width: Math.round(200*globals.screenRatio),
				height: Math.round(150*globals.screenRatio),
				center: {
					x: Math.round(center.x), 
					y: Math.round(center.y)
				},
				zIndex: gallery.maxPartIndex,
				move: true,
				id: 'g-' + itemId + '-' + gallery.maxPartIndex,
				itemId: itemId
			});*/
			var partView = this.getPartView(itemId);
			playArea.add(partView);
			gallery.maxPartIndex++;
			var inf = globals.infantium;
			if (inf && inf.enabled) {
				var color = gallery.getPartColor(itemId);
				globals.infantium.addElement({
					id: partView.id,
					size: {w: partView.width, h: partView.height},
					category: gallery.getInfCategory(itemId),
					subcategory: gallery.getInfSubcategory(itemId),
					xpos: Math.round(partView.center.x),
					ypos: Math.round(partView.center.y),
					color: color
				});
			}
		},
		
		getPartView: function(id) {
			
			var mosaic = gallery.mosaic;
			var w = Math.round(200*globals.screenRatio);
			var h = Math.round(150*globals.screenRatio);
			
			var cutButton = gallery.trashButton;
			var cutButtonBig = gallery.trashButtonBig;
			var cutButtonArea = 72*globals.screenRatio;
			
			var part = Ti.UI.createImageView({
				image: '/images/common/models-150/'+id+'.png',
				width: w,
				height: h,
				center: {
					x: Math.round(mosaic.left + 0.5*mosaic.width - 0.5*w), 
					y: Math.round(mosaic.top + 0.5*mosaic.height - 0.5*h), 
				},
				zIndex: gallery.maxPartIndex,
				canMove: true,
				moving: false,
				id: 'g-' + id + '-' + gallery.maxPartIndex,
				itemId: id
			});

			part.addEventListener('touchmove',function(e){
				
				if (!this.canMove) return;
				
				if (!this.moving) {  // touch start
					
					this.localPoint = { x: e.x, y: e.y };
					this.moving = true;
					
				} else {  // touch move
					
					var playArea = gallery.scene.children[1];
					var globalPoint = e.source.convertPointToView({x : e.x, y : e.y }, playArea);
					
					this.left = globalPoint.x - this.localPoint.x;
					this.top = globalPoint.y - this.localPoint.y;
					
					if(globalPoint.x > globals.platformWidth - cutButtonArea - 50*globals.screenRatio	&&
						 globalPoint.y > globals.platformHeight - cutButtonArea - 50*globals.screenRatio) {
						if(!cutButtonBig.visible){
							cutButtonBig.show();
							cutButton.hide();	
						}
					} else {
						if(cutButtonBig.visible){
							cutButton.show();
							cutButtonBig.hide();	
						}
					}
				}

			});
			
			part.addEventListener('touchend',function(e){
				
				if (!this.canMove) return;
				
				var scene = gallery.scene;
				var playArea = scene.children[1];
				var cutButtonBig = gallery.trashButtonBig;
				
				if(cutButtonBig.visible){
					if(globals.playsound){
						gallery.trashSound.play();
					}
					//remove selected part
					playArea.remove(this);
					cutButton.show();
					cutButtonBig.hide();
					if (this.moving) {
						var inf = globals.infantium;
						if (inf && inf.enabled) {
							globals.infantium.endDragging({
								x2: Math.round(selectedPart.center.x),
								y2: Math.round(selectedPart.center.y)
							}, 'success');
						}
					}
				} else {
					if (this.moving) {
						var selectedPart = this;
						var inf = globals.infantium;
						if (inf && inf.enabled) {
							globals.infantium.endDragging({
								x2: Math.round(selectedPart.center.x),
								y2: Math.round(selectedPart.center.y)
							});
						}
					}
				}
				this.moving = false;
			});
			
			return part;
		},
		
		takeScreenshot: function(){
			var scene = gallery.scene;
			var selectMosaic = gallery.mosaic;
			
			var playArea = scene.children[1];
			var pictureBorder = scene.children[2];
			var touchArea = scene.children[3];
			
			var backButton = gallery.backButton;
			var pictureButton = gallery.picButton;
			var cutButton = gallery.trashButton;
			
			backButton.hide();
			pictureButton.hide();
			cutButton.hide();
			
			if(globals.playsound){
				gallery.pictureSound.play();
			}
			pictureBorder.show();

			Ti.Media.takeScreenshot(function(e){
				pictureBorder.hide();
				backButton.show();
				pictureButton.show();
				cutButton.show();
				
				// store picture
				var filename = 'vitopuzzles_' + Date.now().toString() + '.png';
				if (Ti.Platform.osname == 'android') {
					
					if (Ti.Filesystem.isExternalStoragePresent) {
						var dir = Titanium.Filesystem.getFile(Ti.Filesystem.externalStorageDirectory +'VitoPuzzles');
						if(!dir.exists()){
							dir.createDirectory();
							Ti.Media.Android.scanMediaFiles([dir], null, null);	
						}
			            var new_path = Ti.Filesystem.externalStorageDirectory + 'VitoPuzzles/' + filename;
			            var f = Ti.Filesystem.getFile(new_path);
			            var result = f.write(e.media);
			            Ti.Media.Android.scanMediaFiles([new_path], null, function(){});
					}
					
				} else if (Ti.Platform.osname == 'iphone' || Ti.Platform.osname == 'ipad') {
			        Titanium.Media.saveToPhotoGallery(e.media,{
			            success: function(e) {
			                Titanium.UI.createAlertDialog({
			                    title:'Success',
			                    message:'Photo saved to your photo gallery'
			                }).show();      
			            },
			            error: function(e) {
			                Titanium.UI.createAlertDialog({
			                    title:'Error saving',
			                    message:e.error
			                }).show();
			            }
			        });
				}
		    });
		},
		
		showStartPanel: function(callback) {
			var layout = Ti.UI.createView({
				width: 400*globals.screenRatio,
				height: 220*globals.screenRatio
			});
			layout.add(Ti.UI.createLabel({
				text: (globals.firefox) ? 'Gallery' : L('gallery'),
				height: 40*globals.screenRatio,
				top: 25*globals.screenRatio,
				textAlign: 'center',
				font: {fontSize: 40*globals.screenRatio, fontFamily: globals.fontFamily, fontWeight: 'bold'},
				color: '#fff'
			}));
			layout.add(Ti.UI.createLabel({
				text: (globals.firefox) ? 'Create your own scene.' : L('gallery_help'),
				width: '90%',
				height: 120*globals.screenRatio,
				top: 70*globals.screenRatio,
				textAlign: 'center',
				font: {fontSize: 22*globals.screenRatio},
				color: '#333'
			}));
			gallery.popup.setLayout(layout);
			gallery.popup.open({autoClose: true, exitOnTouch: true, callback: callback});
		},
		
		resetGame: function(){
			var inf = globals.infantium;
			if (inf && inf.enabled) {
				globals.infantium.resetCurrentGame();
			}
			var scene = gallery.scene;
			var playArea = scene.children[1];
			var playItems = playArea.children;
			for (var i=0; i<playItems.length; i++){
				playArea.remove(playItems[i]);
			}
			gallery.maxPartIndex = 1;
		},
		
		// infantium
		getInfCategory: function(id) {
			if (id == 'farmboy' || id == 'farmgirl')
				return 'person';
			if (id == 'scarecrow')
				return 'object';
			return 'animal';
		},		
		getInfSubcategory: function(id) {
			if (id == 'dog') return 'dog';
			if (id == 'farmboy') return 'adult';
			if (id == 'farmgirl') return 'adult';
			if (id == 'cat') return 'cat';
			if (id == 'sheep') return 'sheep';
			if (id == 'scarecrow') return 'other';
			if (id == 'skunk') return 'skunk';
			if (id == 'squirrel') return 'squirrel';
			
			if (id == 'owl') return 'owl';
			if (id == 'crow') return 'crow';
			if (id == 'mouse') return 'mouse';
			if (id == 'rabbit') return 'rabbit';
			if (id == 'hedgehog') return 'hedgehog';
			if (id == 'goat') return 'goat';
			if (id == 'hen') return 'chicken';
			if (id == 'turkey') return 'turkey';
			if (id == 'pig') return 'pig';
			if (id == 'goose') return 'goose';
			if (id == 'cow') return 'cow';
			if (id == 'horse') return 'horse';
			if (id == 'wolf') return 'wolf';
			
			return null;
		},
		getPartColor: function(partId) {
			var color = null;
			if (partId == 'dog') {
				color = '232, 232, 232';
			} else if (partId == 'farmgirl') {
				color = '238, 181, 124';
			} else if (partId == 'farmboy') {
				color = '240, 185, 131';
			} else if (partId == 'cat') {
				color = '129, 144, 115';
			} else if (partId == 'sheep') {
				color = '224, 224, 224';
			} else if (partId == 'scarecrow') {
				color = '255, 144, 0';
			} else if (partId == 'skunk') {
				color = '51, 77, 112';
			} else if (partId == 'squirrel') {
				color = '168, 121, 79';
			} else if (partId == 'owl') {
				color = '89, 60, 43';
			} else if (partId == 'crow') {
				color = '32, 63, 81';
			} else if (partId == 'mouse') {
				color = '137, 137, 137';
			} else if (partId == 'rabbit') {
				color = '139, 126, 108';
			} else if (partId == 'hedgehog') {
				color = '202, 164, 164';
			} else if (partId == 'goat') {
				color = '196, 180, 157';
			} else if (partId == 'hen') {
				color = '170, 122, 47';
			} else if (partId == 'turkey') {
				color = '82, 62, 29';
			} else if (partId == 'pig') {
				color = '241, 185, 185';
			} else if (partId == 'goose') {
				color = '255, 255, 255';
			} else if (partId == 'cow') {
				color = '241, 185, 185';
			} else if (partId == 'horse') {
				color = '157, 97, 39';
			} else if (partId == 'wolf') {
				color = '111, 138, 162';
			}
			return color;
		}

	};
	return gallery;
}
