exports.init = function(globals) {

	var win = Ti.UI.createWindow({
		orientationModes : [
	        Titanium.UI.LANDSCAPE_LEFT,
	        Titanium.UI.LANDSCAPE_RIGHT 
	    ]
	});
	
	var obj = getViewObj(win, globals);
	
	win.addEventListener('android:back', obj.goBack);
	win.addEventListener('postlayout', obj.onPostLayout);
	win.addEventListener('close', obj.onClose);
	win.addEventListener('focus', obj.onFocus);
	win.addEventListener('blur', obj.onBlur);

	obj.buildView();
	return win;
};

function getViewObj(win, globals){
	var winSound = null;
	if (Ti.Platform.osname != "mobileweb") {
		winSound = Ti.Media.createSound({url: 'audio/win.mp3'});
	} else {
		winSound = soundMgr.createSound('audio/win.mp3');
	}
	var practice = {
		view: {},
		scene: {},
		popup: {},
		updateBox: {},
		audioLoop: {},
		target: 0,
		maxPartIndex: 1,
		targetMargin: 20*globals.screenRatio,
		partIds: globals.puzzleIds,
		shadowPositions: [
			//[{x:0,y:0},{x:144,y:143},{x:291,y:0},{x:441,y:143}],		// 1 2 3 4
			[{x:441,y:143},{x:144,y:143},{x:0,y:0},{x:291,y:0}],	// 4 2 1 3
			[{x:144,y:143},{x:441,y:143},{x:291,y:0},{x:0,y:0}],	// 2 4 3 1
			[{x:291,y:0},{x:0,y:0},{x:441,y:143},{x:144,y:143}],	// 3 1 4 2
			[{x:441,y:143},{x:0,y:0},{x:291,y:0},{x:144,y:143}],	// 4 1 3 2
			
			//[{x:0,y:143},{x:144,y:0},{x:291,y:143},{x:441,y:0}],		// 1 2 3 4
			[{x:441,y:0},{x:144,y:0},{x:0,y:143},{x:291,y:143}],	// 4 2 1 3
			[{x:144,y:0},{x:441,y:0},{x:291,y:143},{x:0,y:143}],	// 2 4 3 1
			[{x:291,y:143},{x:0,y:143},{x:441,y:0},{x:144,y:0}],	// 3 1 4 2
			[{x:441,y:0},{x:0,y:143},{x:291,y:143},{x:144,y:0}],	// 4 1 3 2
			
			//[{x:430,y:100},{x:100,y:200},{x:520,y:220},{x:250,y:210}],
			//[{x:520,y:210},{x:200,y:180},{x:400,y:100},{x:100,y:250}],
			/*[{x:262,y:75},{x:100,y:0},{x:500,y:210},{x:655,y:220}],
			[{x:655,y:220},{x:262,y:75},{x:500,y:210},{x:100,y:0}],
			[{x:100,y:0},{x:655,y:220},{x:262,y:75},{x:500,y:210}],*/
		],
		/*shadowPositions: [
			[{x:550,y:125},{x:112,y:160},{x:645,y:220},{x:370,y:210}],
			[{x:370,y:210},{x:645,y:220},{x:550,y:125},{x:112,y:160}],
			[{x:645,y:220},{x:370,y:210},{x:112,y:160},{x:550,y:125}],
			[{x:262,y:125},{x:112,y:160},{x:500,y:210},{x:645,y:220}],
			[{x:645,y:220},{x:262,y:125},{x:500,y:210},{x:112,y:160}],
			[{x:112,y:160},{x:645,y:220},{x:262,y:125},{x:500,y:210}],
		],*/
		sound: [
			{ tracks: [], num: 0 },
			{ tracks: [], num: 0 },
			{ tracks: [], num: 0 },
			{ tracks: [], num: 0 }
		],
		winSound: winSound,
		goalCounter: 4,
		started: false,
		
		buildView: function(){
			
			// view
			this.view = Ti.UI.createView({
				visible: false
			});
			this.buildBackground();
			this.buildScene();
			this.resetGame();
			this.buildNavigation();
			this.buildPopup();
			
			win.add(this.view);
			
			// audio
			if (Ti.Platform.osname != "mobileweb") {
				this.audioLoop = Ti.Media.createSound({url: 'audio/game.mp3', volume: 0.5});
			} else {
				this.audioLoop = soundMgr.createLoop('audio/game.mp3');
			}
		},
		
		getPositions: function() {
			
			var random = function(min, max){ return Math.round((min + (Math.random() * (max - min)))); };
			var n = random(0, practice.shadowPositions.length-1);
			return practice.shadowPositions[n];
		},
		
		goBack: function(){
			Ti.App.fireEvent('jumpTo', {target: globals.WIN_APPMENU, source: win, startInfantium: false});
		},
		
		onPostLayout: function(){
			if(!practice.started){
				practice.started = true;
				//practice.resetGame();
				practice.view.show();
				/*practice.showStartPanel(function() {
					var inf = globals.infantium;
					if (inf && inf.enabled) {
						var subcontent = inf.conf.subcontent_uuid.shapes;
						inf.startGame(subcontent);
						globals.infantium.startTime();
					}
				});*/
			}
		},
		
		onClose: function() {
			var inf = globals.infantium;
			if (inf && inf.enabled) {
				globals.infantium.endGame();
			}
			practice.started = false;
		},
		
		onFocus: function() {
			if(globals.playsound && !practice.audioLoop.isPlaying()){
				if(practice.started){
					//practice.audioLoop.setLooping(true);
					practice.audioLoop.play();
				}else{
					practice.hasToPlay = true;
					setTimeout(function(){
						if(practice.hasToPlay){
							if(globals.playsound && !practice.audioLoop.isPlaying()){
								//practice.audioLoop.setLooping(true);
								practice.audioLoop.play();
							}
						}
					}, 1000);
				}
			}
		},
		
		onBlur: function() {
			practice.hasToPlay = false;
			if(globals.playsound && practice.audioLoop.isPlaying()){
				//practice.audioLoop.setLooping(false);
				practice.audioLoop.pause();
			}
		},
		
		buildBackground: function(){
			/*practice.view.add(Ti.UI.createImageView({
				image: '/images/common/farm.jpg',
				width: globals.platformWidth,
				height: globals.platformHeight
			}));*/
			practice.view.add(Ti.UI.createImageView({
				image: '/images/common/bg.jpg',
				width: Math.floor(1.3*800*globals.screenRatio),
				height: Math.floor(1.3*480*globals.screenRatio)
			}));
			var dock = Ti.UI.createView({
				height: Math.floor(180*globals.screenRatio),
				bottom: 0,
				backgroundColor: '#fff',
				//opacity: 0.8
				
			});
			dock.add(Ti.UI.createImageView({
				image: '/images/common/puzzle-bg.jpg',
				width: '100%',
				opacity: 0.7
			}));
			dock.add(Ti.UI.createView({
				height: 4*globals.screenRatio,
				top: 0,
				backgroundColor: '#fff'
			}));
			practice.view.add(dock);
		},
		
		buildScene: function(){
			var scene = Ti.UI.createView({});
			scene.add(Ti.UI.createView({		// child[1] - shadow area
				width: globals.contentWidth
			}));
			scene.add(Ti.UI.createView({}));	// child[2] - play area
			scene.add(Ti.UI.createView({}));	// child[3] - touch area
			
			// add scene
			practice.scene = scene;
			practice.view.add(scene);
		},
		
		buildNavigation: function(){
			
			// back button
			var backButton = Ti.UI.createImageView({
				image: '/images/common/navigation/back.png',
				top: 5*globals.screenRatio,
				left: 5*globals.screenRatio,
				width: 72*globals.screenRatio,
				height: 72*globals.screenRatio
			});
			backButton.addEventListener('touchstart',function(){
				if(globals.playsound){
					globals.audioButton.play();
				}
				practice.goBack();
			});
			practice.view.add(backButton);
			
			// update button
			/*var updateBox = Ti.UI.createView({
				width: 240*globals.screenRatio,
				height: 80*globals.screenRatio,
				bottom: 0,
				left: 0,
				visible: false
			});
			var updateLabel = Ti.UI.createLabel({
				text: (globals.firefox) ? 'Repeat' : L('repeat'),
				font: {fontSize: 22*globals.screenRatio, fontWeight: 'bold'},
				backgroundColor: '#0660be',
				borderRadius: 10*globals.screenRatio,
				borderWidth: 2*globals.screenRatio,
				color: '#fff',
				textAlign: 'center',
				height: 40*globals.screenRatio,
				width: 170*globals.screenRatio,
				bottom: 15*globals.screenRatio,
				left: 50*globals.screenRatio
			});
			updateBox.add(updateLabel);
			var updateButton = Ti.UI.createImageView({
				image:'/images/common/navigation/update.png',
				bottom: 5*globals.screenRatio,
				left: 5*globals.screenRatio,
				width: 72*globals.screenRatio,
				height: 72*globals.screenRatio
			});
			updateBox.add(updateButton);
			updateBox.addEventListener('touchstart',function(){
				if(globals.playsound){
					globals.audioButton.play();
				}
				practice.updateBox.hide();
				practice.resetGame();
				var inf = globals.infantium;
				if (inf && inf.enabled) {
					globals.infantium.startTime();
				}
			});
			practice.view.add(updateBox);
			practice.updateBox = updateBox;
			*/
		},
		
		buildPopup: function() {
			var popup = require('ui/Popup').Popup(globals);
			practice.popup = popup;
			practice.view.add(popup);
			practice.showStartPanel(function() {
				var inf = globals.infantium;
				if (inf && inf.enabled) {
					var subcontent = inf.conf.subcontent_uuid.shapes;
					inf.startGame(subcontent);
					globals.infantium.startTime();
				}
			});
		},
		
		/*buildBehavior: function(){
			var playArea = practice.scene.children[2];
			var touchArea = practice.scene.children[3];
			var inf = globals.infantium;
			if (inf && inf.enabled) {
				touchArea.addEventListener('singletap', function(e) {	
					var children = playArea.children;
					var nChildren = children.length;
					var firstPart = {};
					var maxZIndex = 0;
					for(var i=0; i<nChildren; i++){
						var partView = children[i];
						var widthHalf = partView.width/2;
						var heightHalf = partView.height/2;
						if ( (e.x > partView.center.x - widthHalf) && (e.x < partView.center.x + widthHalf) ){
							if ( (e.y > partView.center.y - heightHalf) && (e.y < partView.center.y + heightHalf) ){
								if(partView.zIndex > maxZIndex){
									maxZIndex = partView.zIndex;
									firstPart = partView;
								}
							}
						}
					}
					if(firstPart.zIndex) {
						globals.infantium.addElementTap(firstPart.id);
					} else {
						globals.infantium.addNoElementTap({
							x: Math.round(e.x), 
							y: Math.round(e.y)
						});
					}
				});
			}
			touchArea.addEventListener('touchstart',function(e){
				var children = playArea.children;
				var nChildren = children.length;
				var firstPart = {};
				var maxZIndex = 0;
				for(var i=0; i<nChildren; i++){
					var partView = children[i];
					var widthHalf = partView.width/2;
					var heightHalf = partView.height/2;
					if ( (e.x > partView.center.x - widthHalf) && (e.x < partView.center.x + widthHalf) ){
						if ( (e.y > partView.center.y - heightHalf) && (e.y < partView.center.y + heightHalf) ){
							if(partView.zIndex > maxZIndex){
								maxZIndex = partView.zIndex;
								firstPart = partView;
							}
						}
					}
				}
				if(firstPart.zIndex){
					
					// play sound
					if (globals.playsound){
						var shadowArea = practice.scene.children[1];
						var shadowItems = shadowArea.children[0].children;
						var nShadowItems = shadowItems.length;
						for(var i=0; i<nShadowItems; i++){
							var shadow = shadowItems[i];
							if(shadow.id === firstPart.id){
								practice.playSound(i);
							}
						}
					}
					
					// select part
					playArea.selectedPart = firstPart;
					
					// reorder part indexs
					var prevIndex = firstPart.zIndex;
					for(var i=0; i<nChildren; i++){
						var partView = children[i];
						if(partView.zIndex >= prevIndex){
							partView.zIndex = partView.zIndex - 1;
						} 
					}
					firstPart.zIndex = practice.maxPartIndex;
					firstPart.moving = false;
				}
			});
			touchArea.addEventListener('touchmove',function(e){
				if (playArea.selectedPart) {
					playArea.selectedPart.center = {
						x: Math.round(e.x),
						y: Math.round(e.y)
					};
					if (!playArea.selectedPart.moving) {
						var inf = globals.infantium;
						if (inf && inf.enabled) {
							globals.infantium.startDragging({
								id: playArea.selectedPart.id,
								x1: playArea.selectedPart.center.x,
								y1: playArea.selectedPart.center.y
							});
						}
						playArea.selectedPart.moving = true;
					}
				}
			});
			touchArea.addEventListener('touchend',function(e){
				var selectedPart = playArea.selectedPart;
				if (playArea.selectedPart) {
					//
					if (!selectedPart.matched && selectedPart.moving) {
						var success = practice.checkGoal(selectedPart);
						var inf = globals.infantium;
						if (inf && inf.enabled) {
							var output = success ? 'success' : 'error';
							globals.infantium.endDragging({
								x2: Math.round(selectedPart.center.x),
								y2: Math.round(selectedPart.center.y),
							}, output);
						}
					}
					//
					playArea.selectedPart = null;
				}
			});
		},*/
		
		showStartPanel: function(callback) {
			var layout = Ti.UI.createView({
				width: 400*globals.screenRatio,
				height: 220*globals.screenRatio
			});
			layout.add(Ti.UI.createLabel({
				text: (globals.firefox) ? 'Shapes' : L('shapes'),
				height: 40*globals.screenRatio,
				top: 30*globals.screenRatio,
				textAlign: 'center',
				font: {fontSize: 40*globals.screenRatio, fontFamily: globals.fontFamily, fontWeight: 'bold'},
				color: '#fff'
			}));
			layout.add(Ti.UI.createLabel({
				text: (globals.firefox) ? 'Fit the characters in their silhouette.' : L('shapes_help'),
				width: '90%',
				height: 80*globals.screenRatio,
				top: 90*globals.screenRatio,
				textAlign: 'center',
				font: {fontSize: 22*globals.screenRatio},
				color: '#333'
			}));
			practice.popup.setLayout(layout);
			practice.popup.open({autoClose: true, exitOnTouch: true, callback: callback});
		},
		
		showEndPanel: function() {
			var layout = Ti.UI.createView({
				width: 400*globals.screenRatio,
				height: 220*globals.screenRatio
			});
			layout.add(Ti.UI.createLabel({
				text: (globals.firefox) ? 'Excellent!' : L('end_practice'),
				height: 40*globals.screenRatio,
				top: 30*globals.screenRatio,
				textAlign: 'center',
				font: {fontSize: 40*globals.screenRatio, fontFamily: globals.fontFamily, fontWeight: 'bold'},
				color: '#fff'
			}));
			layout.add(Ti.UI.createLabel({
				text: 'Play again!',
				width: '90%',
				height: 80*globals.screenRatio,
				top: 90*globals.screenRatio,
				textAlign: 'center',
				font: {fontSize: 22*globals.screenRatio},
				color: '#333'
			}));
			
			practice.popup.setLayout(layout);
			var onClose = function() {
				practice.resetGame();
				var inf = globals.infantium;
				if (inf && inf.enabled) {
					globals.infantium.startTime();
				}
			};
			practice.popup.open({autoClose: true, exitOnTouch: true, callback: onClose});
			//practice.updateBox.show();
		},
		
		resetGame: function(){
			var inf = globals.infantium;
			if (inf && inf.enabled) {
				globals.infantium.resetCurrentGame();
			}
			practice.goalCounter = 4;
			var shadowArea = practice.scene.children[1];
			var playArea = practice.scene.children[2];
			
			//clean previous game
			var shadowAreaIn = shadowArea.children[0];
			if(shadowAreaIn){
				shadowArea.remove(shadowAreaIn);
			}
			
			var playItems = playArea.children;
			for (var i=playItems.length-1; i>=0; i--){
				playArea.remove(playItems[i]);
				//var sound = practice.sound[i];
				//sound.tracks = [];
				//sound.num = 0;
			}
			
			//select 4 random items
			var random = function(min, max){ return Math.round((min + (Math.random() * (max - min)))); };	
			var selectedIds = [];
			for (var i=0; i<4; i++){
				var n = random(0, practice.partIds.length-1);
				var selectedId = practice.partIds[n];
				if(selectedIds.indexOf(selectedId) < 0){	//if not exists
					selectedIds.push(selectedId);	
				}else{
					for (var j=0; j<5; j++){
						if(n+j+1 < practice.partIds.length){
							selectedId = practice.partIds[n+j+1];
						}else{
							selectedId = practice.partIds[0];
							n = 0;
						}
						if(selectedIds.indexOf(selectedId) < 0){	//if not exists
							selectedIds.push(selectedId);
							break;	
						}
					}
				}
			}
			// puzzle parts
			for(var i=0; i<selectedIds.length; i++){
				var id = selectedIds[i];
				var partView = practice.getPartView(id, i);
				
				if (inf && inf.enabled) {
					var color = practice.getPartColor(id);
					globals.infantium.addElement({
						id: partView.id,
						size: {w: partView.width, h: partView.height},
						category: this.getInfCategory(partView.id),
						subcategory: this.getInfSubcategory(partView.id),
						xpos: Math.round(partView.center.x),
						ypos: Math.round(partView.center.y),
						color: color
					});
				}
				if (Ti.Platform.osname != "mobileweb") {
					practice.sound[i].tracks = [
						Ti.Media.createSound({url: 'audio/voices/'+id+'1.mp3'}),
						Ti.Media.createSound({url: 'audio/voices/'+id+'2.mp3'}),
						Ti.Media.createSound({url: 'audio/voices/'+id+'3.mp3'})
					];
				} else {
					practice.sound[i].tracks = [
						soundMgr.createSound('audio/voices/'+id+'1.mp3'),
						soundMgr.createSound('audio/voices/'+id+'2.mp3'),
						soundMgr.createSound('audio/voices/'+id+'3.mp3')
					];
				}
				playArea.add(partView);
				practice.maxPartIndex++;
			}
			
			// shadows
			var shadowPositions = practice.getPositions();
			var shadowView = Ti.UI.createView({
				opacity: 1,
				width: globals.platformHeight*4/3,
				top: 0
			});
			var inf = globals.infantium;
			for(var i=0; i<selectedIds.length; i++){
				var id = selectedIds[i];	
				var partView = Ti.UI.createImageView({
					image: '/images/common/shadows-150/'+id+'.png',
					width: Math.round(200*globals.screenRatio),
					height: Math.round(150*globals.screenRatio),
					//left: Math.round((shadowPositions[i].x-100)*globals.screenRatio), 
					//top: Math.round((shadowPositions[i].y-75)*globals.screenRatio),
					left: Math.round((shadowPositions[i].x)*globals.screenRatio), 
					top: Math.round((shadowPositions[i].y)*globals.screenRatio),
					matched: false,
					id: id
				});
				shadowView.add(partView);
				if (inf && inf.enabled) {
					globals.infantium.addElement({
						id: partView.id + '-shadow',
						size: {w: partView.width, h: partView.height},
						category: this.getInfCategory(partView.id),
						subcategory: this.getInfSubcategory(partView.id),
						xpos: Math.round(globals.contentMargin + partView.center.x),
						ypos: Math.round(partView.center.y)
					});
					globals.infantium.addTarget({
						element: id,
						goal: id + '-shadow'
					});
				}
			}
			
			shadowArea.add(shadowView);
			/*shadowView.animate({
				opacity: 1,
				duration: 1000
			});*/
			
			if (inf && inf.enabled) {
				globals.infantium.setEvaluate(selectedIds);
				//globals.infantium.startTime();
			}
		},
		
		getPartView: function(id, n) {
			
			var margin = globals.contentMargin;
			var part = Ti.UI.createImageView({
				image: '/images/common/models-150/'+id+'.png',
				width: Math.round(200*globals.screenRatio),
				height: Math.round(150*globals.screenRatio),
				//left: Math.round((margin+75+n*125-100)*globals.screenRatio),
				left: Math.round(0.5*globals.platformWidth - 0.5*800*globals.screenRatio + n*200*globals.screenRatio),
				top: Math.round(globals.platformHeight-(85+75)*globals.screenRatio),
				zIndex: practice.maxPartIndex,
				id: id,
				canMove: true,
				moving: false
			});
			
			/*part.addEventListener('touchstart',function(e){
				console.log('touch start');
				if (!this.canMove) return;
				
				this.localPoint = { x: e.x, y: e.y };
				if (globals.firefox) {
					this.fireEvent('touchmove', e);
				}
				
				
				/*if(winPuzzle.finished){
					if(globals.playsound){
						var character = winPuzzle.scene.imageArea.children[0];
						if(e.x >= character.left && e.x <= character.left + character.width){
							if(e.y >= character.top && e.y <= character.top + character.height){
								winPuzzle.playSound();
							}
						}
					}
				}else{	
					var nIndex = winPuzzle.currentPartIndex;
					var partView = playArea.children[nIndex];
					var widthHalf = partView.width/2;
					var heightHalf = partView.height/2;
					if ( (e.x > partView.center.x - widthHalf) && (e.x < partView.center.x + widthHalf) &&
						(e.y > partView.center.y - heightHalf) && (e.y < partView.center.y + heightHalf) ) {
						partView.selected = true;
						partView.dragStarted = false;
						if(globals.playsound){
							winPuzzle.touchStartSound.play();
						}
					}
				}*/
			//});
			part.addEventListener('touchmove',function(e){
				
				if (!this.canMove) return;
				
				if (!this.moving) {  // touch start
					this.localPoint = { x: e.x, y: e.y };
					this.moving = true;
				} else {  // touch move
					var playArea = practice.scene.children[2];
					var globalPoint = e.source.convertPointToView({x : e.x, y : e.y }, playArea);
					
					this.left = globalPoint.x - this.localPoint.x;
					this.top = globalPoint.y - this.localPoint.y;
	
				}
				
					
				
				/*
				var nIndex = winPuzzle.currentPartIndex;
				var p = playArea.children[nIndex];
				
				if (p.selected) {
					p.center={
						x: Math.round(e.x),
						y: Math.round(e.y)
					};
					if (!p.dragStarted) {
						var inf = globals.infantium;
						if (inf && inf.enabled) {
							globals.infantium.startDragging({
								id: p.id,
								x1: p.center.x,
								y1: p.center.y
							});
						}
						p.dragStarted = true;
					}
				}*/
			});
			part.addEventListener('touchend',function(e){
				
				if (!this.canMove) return;
				
				this.moving = false;
				
				//var nIndex = winPuzzle.currentPartIndex;
				//var playArea = winPuzzle.scene.playArea;
				//var p = playArea.children[nIndex];
				
				//var success = winPuzzle.checkGoal(p);
				
				if (!this.matched) {
					var success = practice.checkGoal(this);
					/*var inf = globals.infantium;
					if (inf && inf.enabled) {
						var output = success ? 'success' : 'error';
						globals.infantium.endDragging({
							x2: Math.round(this.center.x),
							y2: Math.round(this.center.y),
						}, output);
					}*/
				}
				
			});
			return part;
		},
		
		checkGoal: function(part){
			var shadowArea = practice.scene.children[1];
			//var shadowArea = practice.view.children[2].children[1];
			var shadowItems = shadowArea.children[0].children;
			var nShadowItems = shadowItems.length;
			var margin = globals.contentMargin;
			var success = false;
			var center = {
				x: part.left + 0.5*part.width,
				y: part.top + 0.5*part.height
			};
			for(var i=0; i<nShadowItems; i++){
				var shadow = shadowItems[i];
				var sc = {
					x: shadow.left + 0.5*shadow.width,
					y: shadow.top + 0.5*shadow.height
				};
				if(shadow.id === part.id){
					if(center.x > margin+sc.x-practice.targetMargin && center.x < margin+sc.x+practice.targetMargin){
						if(center.y > sc.y-practice.targetMargin && center.y < sc.y+practice.targetMargin){
							practice.animatePart(part,shadow,i);
							success = true;
						}
					}
					break;
				}
			}
			var inf = globals.infantium;
			if (inf && inf.enabled) {
				if (success) {
					globals.infantium.gameplay.successes++;
				} else {
					globals.infantium.gameplay.failures++;
				}
			}
			return success;
		},
		
		animatePart: function(part,shadow,n){
			if(globals.playsound){
				practice.playSound(n);
			}
			var margin = globals.contentMargin;
			/*var c = {x: margin+shadow.center.x, y: shadow.center.y};
			part.center={
				x: Math.round(c.x),
				y: Math.round(c.y)
			};*/
			part.center = {
				x: part.left + 0.5*part.width,
				y: part.top + 0.5*part.height
			};
			shadow.hide();
			shadow = null;
			part.initialWidth=part.width;
			part.initialHeight=part.height;
			part.animate({
				width: part.width*1.3,
				height: part.height*1.3,
				duration:500
			}, function(){
				part.animate({
					width:part.initialWidth,
					height:part.initialHeight,
					duration:0
				}, function(){
					practice.checkFinish();
					part.matched = true;
				});
			});
		},
		
		checkFinish: function(){
			Ti.API.info("GOAL COUNTER = "+practice.goalCounter);
			if(practice.goalCounter<2){
				practice.finishGame();
			} else {
				practice.goalCounter-=1;
			}
		},
		
		finishGame: function(){
			practice.goalCounter = 4;
			if(globals.playsound){
				practice.winSound.play();
			}
			
			// show end panel
			practice.showEndPanel();
			
			var inf = globals.infantium;
			if (inf && inf.enabled) {
				globals.infantium.sendData();
			}
		},
		
		playSound: function(n){
			var sound = practice.sound[n];
			if(sound.tracks[sound.num]){
				sound.tracks[sound.num].play();
			}
			sound.num = (sound.num > 1) ? 0 : sound.num + 1;
		},
		
		// infantium
		getInfCategory: function(id) {
			if (id == 'farmboy' || id == 'farmgirl')
				return 'person';
			if (id == 'scarecrow')
				return 'object';
			return 'animal';
		},		
		getInfSubcategory: function(id) {
			if (id == 'dog') return 'dog';
			if (id == 'farmboy') return 'adult';
			if (id == 'farmgirl') return 'adult';
			if (id == 'cat') return 'cat';
			if (id == 'sheep') return 'sheep';
			if (id == 'scarecrow') return 'other';
			if (id == 'skunk') return 'skunk';
			if (id == 'squirrel') return 'squirrel';
			
			if (id == 'owl') return 'owl';
			if (id == 'crow') return 'crow';
			if (id == 'mouse') return 'mouse';
			if (id == 'rabbit') return 'rabbit';
			if (id == 'hedgehog') return 'hedgehog';
			if (id == 'goat') return 'goat';
			if (id == 'hen') return 'chicken';
			if (id == 'turkey') return 'turkey';
			if (id == 'pig') return 'pig';
			if (id == 'goose') return 'goose';
			if (id == 'cow') return 'cow';
			if (id == 'horse') return 'horse';
			if (id == 'wolf') return 'wolf';
			return null;
		},
		getPartColor: function(partId) {
			var color = null;
			if (partId == 'dog') {
				color = '232, 232, 232';
			} else if (partId == 'farmgirl') {
				color = '238, 181, 124';
			} else if (partId == 'farmboy') {
				color = '240, 185, 131';
			} else if (partId == 'cat') {
				color = '129, 144, 115';
			} else if (partId == 'sheep') {
				color = '224, 224, 224';
			} else if (partId == 'scarecrow') {
				color = '255, 144, 0';
			} else if (partId == 'skunk') {
				color = '51, 77, 112';
			} else if (partId == 'squirrel') {
				color = '168, 121, 79';
			} else if (partId == 'owl') {
				color = '89, 60, 43';
			} else if (partId == 'crow') {
				color = '32, 63, 81';
			} else if (partId == 'mouse') {
				color = '137, 137, 137';
			} else if (partId == 'rabbit') {
				color = '139, 126, 108';
			} else if (partId == 'hedgehog') {
				color = '202, 164, 164';
			} else if (partId == 'goat') {
				color = '196, 180, 157';
			} else if (partId == 'hen') {
				color = '170, 122, 47';
			} else if (partId == 'turkey') {
				color = '82, 62, 29';
			} else if (partId == 'pig') {
				color = '241, 185, 185';
			} else if (partId == 'goose') {
				color = '255, 255, 255';
			} else if (partId == 'cow') {
				color = '241, 185, 185';
			} else if (partId == 'horse') {
				color = '157, 97, 39';
			} else if (partId == 'wolf') {
				color = '111, 138, 162';
			}
			return color;
		}

	};
	return practice;
}
