function OptionPanel(globals, win) {
	var numrows = 3;
	var rowheight = 40*globals.screenRatio;

	var layout = Ti.UI.createView({
		layout: 'vertical',
		//top: 30*globals.screenRatio,
		width: 400*globals.screenRatio,
		height: 170*globals.screenRatio
	});
	layout.add(Ti.UI.createLabel({
		text: L('options'),
		height: 40*globals.screenRatio,
		top: 25*globals.screenRatio,
		textAlign: 'center',
		font: {fontSize: 40*globals.screenRatio, fontFamily: globals.fontFamily, fontWeight: 'bold'},
		color: '#fff'
	}));
	
	var addRow = function(id, text, callback, globals) {
		var row = Ti.UI.createView({
			height: rowheight
		});
		row.add(Ti.UI.createLabel({
			text: text,
			width: '85%',
			height: rowheight,
			textAlign: 'left',
			font: {fontSize: 24*globals.screenRatio, fontWeight: 'bold'},
			color: '#333'
		}));
		if (id == 3) {	// sound
			var basicSwicth = null;
			if (Ti.Platform.osname == "android") {
				basicSwitch = Ti.UI.createSwitch({
					style: Ti.UI.Android.SWITCH_STYLE_CHECKBOX,
	  				textAlign: Ti.UI.TEXT_ALIGNMENT_CENTER,
					value: globals.playsound,
					right: '5%'
				});
			} else {
				basicSwitch = Ti.UI.createSwitch({
					value: globals.playsound,
					right: '5%'
				});
			}
			
			row.add(basicSwitch);
			
			basicSwitch.addEventListener('change',function(e){
				if (basicSwitch.value) {
					globals.audioButton.play();
					globals.playsound = true;
					win.audioLoop.setLooping(true);
					win.audioLoop.play();
					Ti.App.Properties.setString('volume', 'On');
				} else {
					globals.playsound = false;
					win.audioLoop.setLooping(false);
					win.audioLoop.pause();
					Ti.App.Properties.setString('volume', 'Off');
				}
			});
		}
		row.addEventListener('touchstart', function() {
			if (callback) {
				callback();
			}
			if (id !== 3) {
				popup.close();
			}
		});
		layout.add(row);
	};
	
	var inf = globals.infantium;
	if ( !inf && Ti.Platform.osname == "android") {
		addRow(1, L('share'), function() {
			var playStoreLink = 'https://play.google.com/store/apps/details?id=com.appnostica.vitopuzzles';
			var activity = Ti.Android.currentActivity;
			var intent = Ti.Android.createIntent({
	            action: Ti.Android.ACTION_SEND,
	            type: 'text/plain'
	        });				 
			intent.putExtra(Ti.Android.EXTRA_TEXT, L('share_text') + ':\n' + playStoreLink);
			intent.putExtra(Ti.Android.EXTRA_SUBJECT, 'Vito Puzzles');
			activity.startActivity(Ti.Android.createIntentChooser(intent,'Share'));
		}, globals);
		addRow(2, L('vote'), function() {
			Ti.Platform.openURL('market://details?id=com.appnostica.vitopuzzles');
		}, globals);
		addRow(3, L('sound'), null, globals);	
	} else {
		var row = Ti.UI.createView({
			height: rowheight,
			top: 0.5*rowheight
		});
		row.add(Ti.UI.createLabel({
			text: L('sound'),
			width: '85%',
			height: rowheight,
			textAlign: 'left',
			font: {fontSize: 24*globals.screenRatio, fontWeight: 'bold'},
			color: '#333'
		}));
		
		if (Ti.Platform.osname == "android") {
			var basicSwitch = Ti.UI.createSwitch({
				style: Ti.UI.Android.SWITCH_STYLE_CHECKBOX,
  				textAlign: Ti.UI.TEXT_ALIGNMENT_CENTER,
				value: globals.playsound,
				right: '5%'
			});
			row.add(basicSwitch);
			basicSwitch.addEventListener('change',function(e){
				if (basicSwitch.value) {
					globals.audioButton.play();
					globals.playsound = true;
					win.audioLoop.setLooping(true);
					win.audioLoop.play();
					Ti.App.Properties.setString('volume', 'On');
				} else {
					globals.playsound = false;
					win.audioLoop.setLooping(false);
					win.audioLoop.pause();
					Ti.App.Properties.setString('volume', 'Off');
				}
			});
			
		} else if (Ti.Platform.osname == "iphone") {
			var basicSwitch = Ti.UI.createSwitch({
				value: globals.playsound,
				right: '5%'
			});
			basicSwitch.addEventListener('change',function(e){
				if (basicSwitch.value) {
					globals.audioButton.play();
					globals.playsound = true;
					win.audioLoop.setLooping(true);
					win.audioLoop.play();
					Ti.App.Properties.setString('volume', 'On');
				} else {
					globals.playsound = false;
					win.audioLoop.setLooping(false);
					win.audioLoop.pause();
					Ti.App.Properties.setString('volume', 'Off');
				}
			});
		} else {
			var basicSwitch = Ti.UI.createSwitch({
				value: globals.playsound,
				right: '5%'
			});
			basicSwitch.addEventListener('change',function(e){
				if (basicSwitch.value) {
					globals.audioButton.play();
					globals.playsound = true;
					//win.audioLoop.setLooping(true);
					win.audioLoop.play();
					Ti.App.Properties.setString('volume', 'On');
				} else {
					globals.playsound = false;
					//win.audioLoop.setLooping(false);
					win.audioLoop.pause();
					Ti.App.Properties.setString('volume', 'Off');
				}
			});
			row.add(basicSwitch);
		}
		
		layout.add(row);
		
		/*var okButton = Ti.UI.createLabel({
			text: 'Ok',
			font: {fontSize: 24*globals.screenRatio, fontWeight: 'bold'},
			backgroundColor: '#24be06',
			borderRadius: 10*globals.screenRatio,
			borderWidth: 2*globals.screenRatio,
			color: '#fff',
			textAlign: 'center',
			height: 35*globals.screenRatio,
			width: 100*globals.screenRatio,
			top: 40*globals.screenRatio
		});
		okButton.addEventListener('touchstart', function() {
			if (globals.playsound) {
				globals.audioButton.play();
			}
			popup.close();
		});
		layout.add(okButton);*/
	}
	
	var popup = require('ui/Popup').Popup(globals);
	popup.setLayout(layout);
	return popup;
}

exports.OptionPanel = OptionPanel;