function Popup(globals) {
	var widget = Ti.UI.createView({
		opened: false,
		panel: null,
		content: null,
		conf: null,
		zIndex: 99,
		doOnTouch: function() {
			if (widget.conf && widget.conf.exitOnTouch) {
				widget.close();
			}
		},
		open: function(conf) {
			widget.conf = conf;
			widget.opened = true;
			widget.show();
		},
		close: function() {
			if (widget.opened) {
				widget.opened = false;
				widget.hide();
				if (widget.conf && widget.conf.callback) {
					widget.conf.callback();
				}
			}
		},
		setLayout: function(layout) {
			
			widget.content.remove(widget.content.children[0]);
			widget.content.add(layout);
		}
	});
	var bg = Ti.UI.createView({
		backgroundColor: '#000',
		opacity: 0.4
	});
	widget.bg = bg;
	widget.add(bg);
		
	var panel = Ti.UI.createView({
		width: 536*globals.screenRatio,
		top: 75*globals.screenRatio,
		height: 280*globals.screenRatio,
		backgroundImage: '/images/common/msgbg.png'
	});
	
	var content = Ti.UI.createView({
		top: 30*globals.screenRatio,
		width: 400*globals.screenRatio,
		height: 170*globals.screenRatio
	});
	panel.add(content);
	widget.content = content;
	
	var okButton = Ti.UI.createLabel({
		text: 'Ok',
		font: {fontSize: 24*globals.screenRatio, fontWeight: 'bold'},
		backgroundColor: '#24be06',
		borderRadius: 10*globals.screenRatio,
		borderWidth: 2*globals.screenRatio,
		borderColor: '#000',
		color: '#fff',
		textAlign: 'center',
		height: 35*globals.screenRatio,
		width: 100*globals.screenRatio,
		bottom: 40*globals.screenRatio
	});
	okButton.addEventListener('touchstart', function() {
		if (globals.playsound) {
			globals.audioButton.play();
		}
		widget.close();
	});
	panel.add(okButton);
	
	widget.add(panel);
	widget.panel = panel;
	widget.hide();
	widget.addEventListener('touchstart', widget.doOnTouch);
	return widget;
}

exports.Popup = Popup;