exports.create=function(_text, _image, globals){
	var button=Ti.UI.createView({
		width:160*globals.screenRatio,
		height:210*globals.screenRatio,
		text: _text,
		enabled: true,
		disableLayer: {},
		enable: function(){
			if(button.disableLayer && button.disableLayer.image){
				button.disableLayer.hide();
				button.children[0].text = button.text;
			}
			button.enabled = true;
			button.children[0].enabled = true;
			button.children[1].enabled = true;
		},
		disable: function(){
			if(button.disableLayer && button.disableLayer.image){
				button.disableLayer.show();
			}else{
				button.disableLayer = Ti.UI.createImageView({
					image: '/images/common/buttons/disabled.png',
					top: 0,
					width: 150*globals.screenRatio,
					height: 150*globals.screenRatio
				});
				button.add(button.disableLayer);
				button.children[0].text = '?';
				button.enabled = false;
				button.children[0].enabled = false;
				button.children[1].enabled = false;
			}
		}
	});
	button.addEventListener('touchstart',function(e){
		if(button.enabled){
			/*if(globals.playsound){
				globals.audioButton.play();
			}*/
		}
	});
	/*var fontSize = 20;
	if(_text.length>9){
		fontSize = 16;
	}*/
	if(_image){
		
		button.add(Ti.UI.createLabel({	// child[0] - button label
			text:_text,
			top:155*globals.screenRatio,
			width:150*globals.screenRatio,
			height:45*globals.screenRatio,
			backgroundImage: '/images/common/wood-150.png',
			color:'#fff',
			font: {fontSize: 20*globals.screenRatio, fontFamily: globals.fontFamily, fontWeight: 'bold'},
			textAlign:'center',
			ellipsize:true
		}));
		button.add(Ti.UI.createImageView({	// child[1] - button icon
			image:_image,
			top:0,
			width:150*globals.screenRatio,
			height:150*globals.screenRatio
		}));
	}else{
		button.add(Ti.UI.createLabel({	// child[0] - button label
			text:_text,
			top:155*globals.screenRatio,
			width:150*globals.screenRatio,
			height:45*globals.screenRatio,
			color:'#fff',
			font: {fontSize: 20*globals.screenRatio, fontFamily: globals.fontFamily, fontWeight: 'bold'},
			textAlign:'center',
			ellipsize:true,
			touchEnabled: false
		}));
	}
	
	return button;
};
