exports.init = function(globals, startInfantium) {
	
	var win = Ti.UI.createWindow({
		backgroundColor: '#fff'
		/*orientationModes : [
	        Titanium.UI.LANDSCAPE_LEFT,
	        Titanium.UI.LANDSCAPE_RIGHT 
	    ]*/
	});
	
	var obj = getViewObj(win, globals);
	
	win.addEventListener('android:back', obj.goBack);
	win.addEventListener('postlayout', obj.onPostLayout);
	win.addEventListener('focus', obj.onFocus);
	win.addEventListener('blur', obj.onBlur);
	win.addEventListener('swipe', obj.onSwipe);
	//win.addEventListener('touchstart', obj.onTouch);
	
	obj.buildView();
	obj.startInfantium = startInfantium;
	return win;
};

function getViewObj(win, globals){
	var appMenu = {
		view: {},
		scene: {},
		logo: {},
		audioLoop: {},
		hasToPlay: true,
		subscene: 0,
		target: 0,
		started: false,
		options: {},
		globals: globals,
		
		buildView: function(){
			
			// view
			this.view = Ti.UI.createView({});
			this.buildBackground();
			this.buildLogo();
			this.buildScenes();
			this.buildNavigation();
			if (globals.infantium) {
				this.buildInfantiumNav();
				this.buildInfantiumPanel();
			}
			win.add(this.view);
			
			// audio
			/*if (Ti.Platform.osname != "mobileweb") {
				this.audioLoop = Ti.Media.createSound({url: 'audio/menuA.mp3'});
			}*/
			this.audioLoop = globals.soundMgr.createLoop('audio/menuA.mp3');
		},
		
		goBack: function(){
			if (appMenu.options.opened) {
				appMenu.options.close();
				return;
			}
			var inf = globals.infantium;
			if (inf) {
				var panel = inf.panel;
				if (panel.opened) {
					panel.close();
					return;
				}
			}
			
			appMenu.showScene(0);
			
		},
		
		onPostLayout: function(){
			//alert(screen.orientation);
			/*if (screen.lockOrientation) {
				screen.lockOrientation('landscape');
			} else {
				alert('noo');
			}*/	
			
			if (!appMenu.started) {
				appMenu.started = true;
				if (globals.firefox) {
					if (screen.mozLockOrientation) {
						screen.mozLockOrientation("landscape");
					}
				}
				appMenu.startAnimation();
			}
		},
		
		onFocus: function(){
			if(globals.playsound && !appMenu.audioLoop.isPlaying()){
				if(appMenu.started){
					//appMenu.audioLoop.setLooping(true);
					//console.log('loop1: ' + appMenu.audioLoop.loop);
					appMenu.audioLoop.play();
				}else{
					appMenu.hasToPlay = true;
					setTimeout(function(){
						if(appMenu.hasToPlay){
							//appMenu.audioLoop.setLooping(true);
							//console.log('loop2: ' + appMenu.audioLoop.loop);
							appMenu.audioLoop.play();
						}
					}, 1000);
				}
			}
		},
		
		onBlur: function() {
			appMenu.hasToPlay = false;
			if(globals.playsound && appMenu.audioLoop.isPlaying()){
				//appMenu.audioLoop.setLooping(false);
				appMenu.audioLoop.pause();
			}
		},
		
		onSwipe: function(e){
			switch(appMenu.subscene){
				case 0:
					if (e.direction==='left'){
						appMenu.showScene(1);
					}
					break;
				case 1:
					if (e.direction==='right'){
						appMenu.showScene(0);
					}
					break;
			}
		},
		
		onTouch: function(e) {
			/*if (appMenu.options.opened) {
				appMenu.options.close();
			}*/
		},
		
		jumpTo: function(target) {
			appMenu.stopSound();
			Ti.App.fireEvent('jumpTo', {target: target, source: win, startGamePlay: true});
		},
		
		stopSound: function() {
			if(globals.playsound && appMenu.audioLoop.isPlaying()){
				//appMenu.audioLoop.setLooping(false);
				appMenu.audioLoop.pause();
			}
		},
		
		buildBackground: function(){
			appMenu.view.add(Ti.UI.createImageView({
				image: '/images/common/bg.jpg',
				width: Math.floor(1.3*800*globals.screenRatio),
				height: Math.floor(1.3*480*globals.screenRatio)
			}));
		},
		
		buildLogo: function(){
			var logo = Ti.UI.createView({});
			logo.add(Ti.UI.createImageView({	// child[0] - vitologo
				image: '/images/common/vito.png',
				width: 191*globals.screenRatio,
				height: 138*globals.screenRatio,
				left: -191*globals.screenRatio,
				top: 18*globals.screenRatio
			}));
			logo.add(Ti.UI.createImageView({	// child[1] - puzzleLogo
				image: '/images/common/puzzles.png',
				width: 404*globals.screenRatio,
				height: 87*globals.screenRatio,
				left: '100%',
				top: 65*globals.screenRatio
			}));
			appMenu.logo = logo;
			appMenu.view.add(logo);
		},
		
		buildNavigation: function() {
			
			// option button
			var button = Ti.UI.createImageView({
				image: '/images/common/navigation/settings.png',
				bottom:5*globals.screenRatio,
				right:10*globals.screenRatio,
				width:72*globals.screenRatio,
				height:72*globals.screenRatio
			});
			button.addEventListener('touchstart', function() {
				if (globals.playsound) {
					globals.audioButton.play();
				}
				appMenu.options.open();
			});
			this.view.add(button);
			
			// option panel
			this.options = require('ui/OptionPanel').OptionPanel(globals, appMenu);
			this.view.add(this.options);
			
			
			return button;
		},
		
		buildInfantiumNav: function() {
			var box = Ti.UI.createView({
				width: 540*globals.screenRatio,
				height: 60*globals.screenRatio,
				left: 10*globals.screenRatio,
				bottom: 0
			});
			box.add(globals.infantium.getNav(globals, this.startInfantium));
			this.view.add(box);
		},
		
		buildInfantiumPanel: function() {
			var box = globals.infantium.getPanel(globals);
			this.view.add( box );
		},
				
		buildScenes: function(subscene) {
			var scenes = Ti.UI.createView({
				left: globals.menuStarted ? '-100%' : 0,
				width: '200%',
				height: '100%'
			});
			var AppButton=require('ui/button');
					
			//First scene: Start button
			var scene1=Ti.UI.createView({
				left:0,
				width:'50%'
			});
			var nav1=Ti.UI.createView({
				top:200*globals.screenRatio,
				width: 640*globals.screenRatio,
				layout:'vertical'
			});
			var txtStart = (globals.firefox) ? 'Start' : L('start');
			var btStart=AppButton.create(txtStart,'/images/common/buttons/start.png',globals);
			btStart.addEventListener('touchstart',function(e){
				if (globals.playsound) {
					globals.audioButton.play();
				}
				appMenu.showScene(1);
			});
			nav1.add(btStart);
			scene1.add(nav1);
			scenes.add(scene1);
			
			//Second scene: Game buttons
			var scene2=Ti.UI.createView({
				left:'50%',
				width:'50%'
			});
			var nav2=Ti.UI.createView({
				top: 200*globals.screenRatio,
				width: 480*globals.screenRatio,
				layout:'horizontal'
			});
			
			// Adventure
			var txtPuzzles = (globals.firefox) ? 'Puzzles' : L('puzzles');
			var btAdventure = AppButton.create(txtPuzzles,'/images/common/buttons/adventure.png', globals);
			btAdventure.addEventListener('touchstart',function(e){
				if (globals.playsound) {
					globals.audioButton.play();
				}
				appMenu.jumpTo(globals.WIN_ADVMAP);
			});
			nav2.add(btAdventure);
			
			// Shapes
			var txtShapes = (globals.firefox) ? 'Shapes' : L('shapes');
			var btPractice = AppButton.create(txtShapes,'/images/common/buttons/practice.png', globals);
			btPractice.addEventListener('touchstart',function(e){
				if (globals.playsound) {
					globals.audioButton.play();
				}
				appMenu.jumpTo(globals.WIN_PRACTICE);
			});
			nav2.add(btPractice);
			
			// Gallery
			var txtGallery = (globals.firefox) ? 'Gallery' : L('gallery');
			var btGallery=AppButton.create(txtGallery,'/images/common/buttons/gallery.png',globals);
			btGallery.addEventListener('touchstart',function(e){
				if (globals.playsound) {
					globals.audioButton.play();
				}
				appMenu.jumpTo(globals.WIN_GALLERY);
			});
			nav2.add(btGallery);
			
			scene2.add(nav2);
			scenes.add(scene2);
			appMenu.scene = scenes;
			appMenu.view.add(scenes);
			globals.menuStarted = true;
		},
				
		startAnimation: function(){
			if(!appMenu.created){
				appMenu.created = true;
				var logo = appMenu.logo;
				var vitoLogo = logo.children[0];
				var puzzleLogo = logo.children[1];
				vitoLogo.animate({
					left: (globals.platformWidth/2)-310*globals.screenRatio,
					duration:500
				},function(){
					puzzleLogo.animate({
						left: (globals.platformWidth/2)+310*globals.screenRatio-puzzleLogo.width,
						duration:500
					}, function(){
						vitoLogo.left = (globals.platformWidth/2)-310*globals.screenRatio;
						puzzleLogo.left = (globals.platformWidth/2)+310*globals.screenRatio-puzzleLogo.width;
						if (globals.infantium) {
							if (globals.infantium.currentPlayer) {
								globals.infantium.getAppInfo();
								globals.infantium.getPlayers();
							}
						}
					});
				});
			}
		},
		
		showScene: function(subscene){
			var scene = appMenu.scene;
			switch(subscene){
				case 0:
					scene.animate({left:0, duration:500}, function(){ scene.left = 0; });
					break;
				case 1:
					scene.animate({left:'-100%', duration:500}, function(){ scene.left = '-100%'; });
					break;
			}
			appMenu.subscene = subscene;
		}
			
	};
	return appMenu;
}