function InfantiumPanel(globals){
	var infantiumPanel = {
		bg: null,
		panel: null,
		message: null,
		callback: null,
		data: null,
		widget: null,
		opened: true,
		build: function(){
			var widget = Ti.UI.createView({
				visible: false
			});
			var bg = Ti.UI.createView({
				width: '100%',
				height: '100%',
				backgroundColor: '#000',
				opacity: 0.8
			});
			bg.addEventListener('touchstart', function() {
				if (infantiumPanel.scene == "select" && !globals.infantium.currentPlayer) {
					infantiumPanel.status.text = 'A player must be selected';
					return;
				}
				infantiumPanel.close();
			});
			widget.add(bg);
			this.bg = bg;
			
			//var panelBg = Ti.UI.createImageView({});
			//widget.add(panelBg);
			//this.panelBg = panelBg;
			
			var panel = Ti.UI.createView({});
			var content = Ti.UI.createView({});
			panel.add(content);
			this.content = content;
	
			widget.add(panel);
			this.panel = panel;
			
			this.widget = widget;
		},
		
		show: function(scene, onclose) {
			infantiumPanel.onclose = onclose;
			if (scene == "conditions") {
				infantiumPanel.showConditions();
			} else if (scene == "create") {
				infantiumPanel.showCreatePlayer();
			} else if (scene == "login") {
				infantiumPanel.showLogin();
			} else if (scene == "select") {
				infantiumPanel.showSelectPlayer();
			}
			infantiumPanel.widget.visible = true;
			infantiumPanel.opened = true;
			infantiumPanel.scene = scene;
		},
		
		showConditions: function() {
			with (infantiumPanel.panel) {
				backgroundImage = '/images/common/infantium/bg-conditions.png';
				top = 76*globals.screenRatio;
				width = 361*globals.screenRatio;
				height = 277*globals.screenRatio;
			}
			
			var content = Ti.UI.createView({});
			
			// Privacy policy
			var privacy = Ti.UI.createView({
				left: 87*globals.screenRatio,
				top: 147*globals.screenRatio,
				width: 90*globals.screenRatio,
				height: 22*globals.screenRatio
			});
			privacy.addEventListener('touchstart', function() {
				var webpanel = require('ui/WebPanel').WebPanel(globals);
				var url = 'http://www.infantium.com/en/privacy-policy/?from_mobile=true';
				webpanel.show('Infantium Privacy Policy', url);
			});
			content.add(privacy);
			
			// Terms of Use
			var terms = Ti.UI.createView({
				left: 187*globals.screenRatio,
				top: 147*globals.screenRatio,
				width: 90*globals.screenRatio,
				height: 22*globals.screenRatio
			});
			terms.addEventListener('touchstart', function() {
				var webpanel = require('ui/WebPanel').WebPanel(globals);
				var url = 'http://www.infantium.com/en/terms-of-use/?from_mobile=true';
				webpanel.show('Infantium Terms of Use', url);
			});
			content.add(terms);
			
			// button 1 - No, thanks
			var b1 = Ti.UI.createView({
				left: 36*globals.screenRatio,
				top: 183*globals.screenRatio,
				width: 139*globals.screenRatio,
				height: 58*globals.screenRatio
			});
			b1.addEventListener('touchstart', function() {
				infantiumPanel.close();
				globals.withInfantium = false;
				globals.infantium.disable();
			});
			content.add(b1);
			
			// button 2 - Yes, sure
			var b2 = Ti.UI.createView({
				left: 185*globals.screenRatio,
				top: 183*globals.screenRatio,
				width: 139*globals.screenRatio,
				height: 58*globals.screenRatio
			});
			b2.addEventListener('touchstart', function() {
				infantiumPanel.show('create', infantiumPanel.onclose);
			});
			content.add(b2);
			infantiumPanel.addContent(content);
		},
		
		showCreatePlayer: function() {
			with (infantiumPanel.panel) {
				backgroundImage = '/images/common/infantium/bg-create.png';
				top = 76*globals.screenRatio;
				width = 361*globals.screenRatio;
				height = 331*globals.screenRatio;
			}
			
			var content = Ti.UI.createView({});
			
			var name = Ti.UI.createTextField({
				left: 37*globals.screenRatio,
				top: 93*globals.screenRatio,
				width: 286*globals.screenRatio,
				height: 43*globals.screenRatio,
				backgroundImage: '/images/common/infantium/text-box.png',
				color: '#3fa2ee',
				hintText: 'Nickame',
				font: {fontSize: 16*globals.screenRatio},
				textAlign: 'center'
			});
			content.add(name);
			var years = Ti.UI.createTextField({
				left: 37*globals.screenRatio,
				top: 133*globals.screenRatio,
				width: 286*globals.screenRatio,
				height: 43*globals.screenRatio,
				backgroundImage: '/images/common/infantium/text-box.png',
				color: '#3fa2ee',
				hintText: 'Years',
				font: {fontSize: 16*globals.screenRatio},
				textAlign: 'center'
			});
			content.add(years);
			var months = Ti.UI.createTextField({
				left: 37*globals.screenRatio,
				top: 173*globals.screenRatio,
				width: 286*globals.screenRatio,
				height: 43*globals.screenRatio,
				backgroundImage: '/images/common/infantium/text-box.png',
				color: '#3fa2ee',
				hintText: 'Months (optional)',
				font: {fontSize: 16*globals.screenRatio},
				textAlign: 'center'
			});
			content.add(months);
			var status = Ti.UI.createLabel({
				text: '',
				top: 209*globals.screenRatio,
				font: {fontSize: 16*globals.screenRatio},
				color: '#633'
			});
			content.add(status);
			
			// button 1 - Login
			var b1 = Ti.UI.createView({
				left: 36*globals.screenRatio,
				top: 237*globals.screenRatio,
				width: 139*globals.screenRatio,
				height: 58*globals.screenRatio
			});
			b1.addEventListener('touchstart', function() {
				infantiumPanel.show('login', infantiumPanel.onclose);
			});
			content.add(b1);
			
			// button 2 - Create player
			var b2 = Ti.UI.createView({
				left: 186*globals.screenRatio,
				top: 237*globals.screenRatio,
				width: 139*globals.screenRatio,
				height: 58*globals.screenRatio
			});
			var isNumber = function(n) {
			  return !isNaN(parseFloat(n)) && isFinite(n);
			};
			b2.addEventListener('touchstart', function() {
				if (name.value.length > 0 && isNumber(years.value)) {
					status.text = '';
					var y = Number(years.value);
					var m = Number(months.value);
					var data = {
						nickname: name.value, 
						years: y,
						months: (m > 0) ? y*12+m : y*12
					};
					var currentUser = globals.infantium.currentUser;
					if (currentUser) {
						data.tutor = currentUser.user.resource_uri;
					}
					//globals.infantium.createPlayer(data, infantiumPanel.close);
					//globals.infantium.getAppInfo();
					globals.infantium.getAppInfo(function() {
						globals.infantium.createPlayer(data, infantiumPanel.close);
					});
				} else {
					status.text = 'Nickname and years are required';
				}
			});
			content.add(b2);
			infantiumPanel.addContent(content);
		},
		
		showLogin: function() {
			with (infantiumPanel.panel) {
				backgroundImage = '/images/common/infantium/bg-login.png';
				top = 76*globals.screenRatio;
				width = 361*globals.screenRatio;
				height = 301*globals.screenRatio;
			}
			
			var content = Ti.UI.createView({});
			
			var email = Ti.UI.createTextField({
				left: 37*globals.screenRatio,
				top: 93*globals.screenRatio,
				width: 286*globals.screenRatio,
				height: 43*globals.screenRatio,
				backgroundImage: '/images/common/infantium/text-box.png',
				color: '#3fa2ee',
				hintText: 'Email',
				font: {fontSize: 16*globals.screenRatio},
				textAlign: 'center'
			});
			content.add(email);
			var passw = Ti.UI.createTextField({
				left: 37*globals.screenRatio,
				top: 133*globals.screenRatio,
				width: 286*globals.screenRatio,
				height: 43*globals.screenRatio,
				backgroundImage: '/images/common/infantium/text-box.png',
				color: '#3fa2ee',
				hintText: 'Password',
				passwordMask: true,
				font: {fontSize: 16*globals.screenRatio},
				textAlign: 'center'
			});
			content.add(passw);
			var status = Ti.UI.createLabel({
				text: '',
				top: 171*globals.screenRatio,
				font: {fontSize: 16*globals.screenRatio},
				color: '#633'
			});
			content.add(status);
			
			// button 1 - Forgot password
			var b1 = Ti.UI.createView({
				left: 37*globals.screenRatio,
				top: 205*globals.screenRatio,
				width: 139*globals.screenRatio,
				height: 58*globals.screenRatio
			});
			b1.addEventListener('touchstart', function() {
				// todo: open web view
				var webpanel = require('ui/WebPanel').WebPanel(globals);
				var url = 'http://www.infantium.com/accounts/password/reset/';
				webpanel.show('Password Reset', url);
				
				/*if (!globals.infantium.currentPlayer) {
					globals.infantium.disable();
				}
				infantiumPanel.close();*/
			});
			content.add(b1);
			
			// button 2 - Login
			var b2 = Ti.UI.createView({
				left: 186*globals.screenRatio,
				top: 205*globals.screenRatio,
				width: 139*globals.screenRatio,
				height: 58*globals.screenRatio,
				enabled: true
			});
			b2.addEventListener('touchstart', function() {
				if (b2.enabled) {
					b2.enabled = false;
					b2.backgroundImage = '/images/common/infantium/button-off.png';
					status.text = '';
					globals.infantium.login(email.value, passw.value, function() {
						globals.infantium.getPlayers( function() {
							infantiumPanel.show('select', infantiumPanel.onclose);
						});
					}, function() {
						status.text = 'Login not valid';
						b2.enabled = true;
						b2.backgroundImage = 'none';
					});
				}
			});
			content.add(b2);
			
			infantiumPanel.addContent(content);
		},
		
		showSelectPlayer: function() {
			with (infantiumPanel.panel) {
				backgroundImage = '/images/common/infantium/bg-select.png';
				top = 46*globals.screenRatio;
				width = 361*globals.screenRatio;
				height = 391*globals.screenRatio;
			}
			
			var content = Ti.UI.createView({});
			
			var playerList = Ti.UI.createView({
				layout: 'vertical',
				left: 43*globals.screenRatio,
				width: 222*globals.screenRatio,
			});
			var players = globals.infantium.currentUser.players;
			if (players) {
				globals.infantium.players = players;
				for (var i=0; i<players.length; i++) {
					var player = players[i];
					var row = Ti.UI.createView({
						top: 2*globals.screenRatio,
						width: 222*globals.screenRatio,
						height: 38*globals.screenRatio,
						backgroundImage: '/images/common/infantium/player.png'
					});
					row.addEventListener('click', function() {
						globals.infantium.setCurrentPlayer(this.player);
						infantiumPanel.setCurrentLevel(this.player);
						infantiumPanel.close();
						globals.infantium.getAppInfo();
					});
					var name = Ti.UI.createLabel({
						text: player.nickname,
						font: {fontSize: 20*globals.screenRatio},
						color: '#fff',
						top: 5*globals.screenRatio,
						width: '90%',
						textAlign: 'left'
					});
					row.add(name);
					var y = Math.floor(player.months / 12);
					var m = player.months-(y*12);
					var years = Ti.UI.createLabel({
						text: y,
						font: {fontSize: 16*globals.screenRatio},
						color: '#3fa2ee',
						left: 162*globals.screenRatio,
						top: 8*globals.screenRatio,
						width: 23*globals.screenRatio,
						height: 20*globals.screenRatio,
						textAlign: 'center'
					});
					row.add(years);
					var months = Ti.UI.createLabel({
						text: m,
						font: {fontSize: 16*globals.screenRatio},
						color: '#fff',
						left: 189*globals.screenRatio,
						top: 8*globals.screenRatio,
						width: 23*globals.screenRatio,
						height: 20*globals.screenRatio,
						textAlign: 'center'
					});
					row.add(months);
					row.player = player;
					row.playername = name;
					playerList.add(row);
				}
				var scroll = Ti.UI.createScrollView({
					showVerticalScrollIndicator: true,
					top: 100*globals.screenRatio,
					width: 338*globals.screenRatio,
					height: 170*globals.screenRatio
				});
				scroll.add(playerList);
				content.add(scroll);
			} else {
				if (conf.debug) {
					alert('No players');
				}
			}
			
			var status = Ti.UI.createLabel({
				text: '',
				top: 275*globals.screenRatio,
				font: {fontSize: 16*globals.screenRatio},
				color: '#633'
			});
			infantiumPanel.status = status;
			content.add(status);
			
			// button 1 - Logout
			var b1 = Ti.UI.createView({
				left: 37*globals.screenRatio,
				top: 309*globals.screenRatio,
				width: 139*globals.screenRatio,
				height: 58*globals.screenRatio
			});
			b1.addEventListener('touchstart', function() {
				globals.infantium.logout();
				
				infantiumPanel.close();
			});
			content.add(b1);
			
			// button 2 - Create player
			var b2 = Ti.UI.createView({
				left: 186*globals.screenRatio,
				top: 309*globals.screenRatio,
				width: 139*globals.screenRatio,
				height: 58*globals.screenRatio
			});
			b2.addEventListener('touchstart', function() {
				infantiumPanel.show('create', infantiumPanel.onclose);
			});
			content.add(b2);
			
			infantiumPanel.addContent(content);
		},
		
		setCurrentLevel: function(player) {
			var currentLevel;
			var uuid = '' + player.player_uuid;			
			var levels = Ti.App.Properties.getObject('player-levels');
			if (levels) {
				currentLevel = levels[uuid];
				if (!currentLevel) {
					currentLevel = 1;
					levels[uuid] = currentLevel; 
					Ti.App.Properties.setObject('player-levels', levels);
				}
			} else {
				currentLevel = 1;
				levels = {};
				levels[uuid] = currentLevel; 
				Ti.App.Properties.setObject('player-levels', levels);
			}
			Ti.App.Properties.setInt('currentLevel', currentLevel);
		},
		
		cancelButton: function(title, align, callback) {
			var b = Ti.UI.createButton({
				title: title,
				bottom: '2%',
				width: '30%',
				height: 50*globals.screenRatio,
				font: {fontSize: 22*globals.screenRatio},
			});
			if (align == 'left') {
				b.left = '5%';
			} else if (align == 'right') {
				b.right= '5%';
			} 
			b.addEventListener('touchstart', callback);
			return b;
		},
		
		actionButton: function(title, align, callback) {
			var b = Ti.UI.createButton({
				title: title,
				bottom: '2%',
				width: '40%',
				height: 75*globals.screenRatio,
				font: {fontSize: 22*globals.screenRatio},
			});
			if (align == 'left') {
				b.left = '5%';
			} else if (align == 'right') {
				b.right= '5%';
			} 
			b.addEventListener('touchstart', callback);
			return b;
		},
		
		addContent: function(content) {
			var firstChild = infantiumPanel.content.children[0];
			if (firstChild) {
				infantiumPanel.content.remove(firstChild);
				firstChild = null;
			}
			if (content) {
				infantiumPanel.content.add(content);
			}
		},
		
		addFooter: function(footer) {
			var firstChild = infantiumPanel.footer.children[0];
			if (firstChild) {
				infantiumPanel.footer.remove(firstChild);
				firstChild = null;
			}
			if (footer) {
				infantiumPanel.footer.add(footer);
			}
		},
				
		close: function() {
			infantiumPanel.widget.visible = false;
			var firstChild = infantiumPanel.content.children[0];
			if (firstChild) {
				infantiumPanel.content.remove(firstChild);
			}
			infantiumPanel.opened = false;
			if (infantiumPanel.onclose) {
				infantiumPanel.onclose();
			}
		}
	};
	infantiumPanel.build();
	return infantiumPanel;
}
exports.InfantiumPanel = InfantiumPanel;
