function WebPanel(globals) {
	var webpanel = {
		win: null,
		
		show: function(title, url) {
			var win = Ti.UI.createWindow({
				modal: true,
			    navBarHidden: true,
				fullscreen: true	     
			});
			
			var layout = Ti.UI.createView({
				borderWidth: 2*globals.screenRatio,
				borderColor: '#222',
				width: '90%',
				height: '95%'
			});
			
			var status = Ti.UI.createView({
				top: 0,
				height: 40*globals.screenRatio,
				backgroundColor: '#222'
			});
			status.addEventListener('touchstart', function() {
				win.close();
			});
			var statlabel = Ti.UI.createLabel({
				text: L('loading_stats'),
				font: {fontSize: 22*globals.screenRatio}
			});
			status.add(statlabel);
			layout.add(status);
			
			var webview = Ti.UI.createWebView({
			    url: url,
			    top: 40*globals.screenRatio,
			    bottom: 0
			});
			webview.addEventListener('load', function() {
				statlabel.text = L('close');
			});
			layout.add(webview);
			
			win.add(layout);
			win.open();
		}
	};
	return webpanel;
};

exports.WebPanel = WebPanel; 
