var tileStates = {
	hidden: 1,
	shown: 2,
	solved: 3
};
exports.create = function(id, globals){
	var memtile = Ti.UI.createView({
		width: 160*globals.screenRatio,
		height: 210*globals.screenRatio,
		state: tileStates.hidden,
		shown: false,
		disableLayer: {},
		enable: function(){
			if (memtile.state == tileStates.hidden) {
				memtile.disableLayer.visible = false;
				memtile.state = tileStates.shown;
				memtile.shown = true;
			}
		},
		disable: function(){
			if (memtile.state == tileStates.shown) {
				memtile.disableLayer.visible = true;
				memtile.state = tileStates.hidden;
				memtile.shown = false;
			}
		}
	});
	memtile.add(Ti.UI.createImageView({	// child[1] - default button
		image: '/images/common/buttons/default.png',
		top:0,
		width:150*globals.screenRatio,
		height:150*globals.screenRatio,
		touchEnabled: false
	}));
	memtile.add(Ti.UI.createImageView({	// child[2] - character
		image: '/images/common/models-150/' + id + '.png',
		top: 20,
		width: 150*globals.screenRatio,
		height: 112*globals.screenRatio,
		touchEnabled: false
	}));
	memtile.disableLayer = Ti.UI.createImageView({
		image: '/images/common/buttons/cap.png',
		top: 0,
		width: 150*globals.screenRatio,
		height: 150*globals.screenRatio,
		touchEnabled: false,
		visible: true
	});
	memtile.add(memtile.disableLayer);
	
	return memtile;
};

/*
//flip image 
var tabBg = tabGroup.toImage();
 
var t1 = Ti.UI.create3DMatrix();
t1 = t1.rotate(180,0,1,0);
 
var bgImage = Ti.UI.createImageView({
    image:tabBg,
    top:0,bottom:0,left:0,right:0,
    transform:t1
});
*/