'use strict';

(function () {

  var introduction = document.getElementById('introduction'),
  step1 = introduction.querySelector('#step1-lnk'),
  gd = new GestureDetector(introduction, null);

  gd.startDetecting();

  introduction.addEventListener('swipe', function (e) {
    var current = introduction.querySelector('.current');
    if (e.detail.direction == 'left') {
      Animation.currentToLeft(introduction, current, current.nextElementSibling);
    } else if (e.detail.direction == 'right') {
      Animation.currentToRight(introduction, current, current.previousElementSibling);
    }
  });

  introduction.addEventListener('current-to-left', function (e) {
    var bullets = introduction.querySelector('.bullets'),
    current = bullets.querySelector('.current'),
    next = current.nextElementSibling;
    if (next) {
      removeClass(current, 'current');
      addClass(next, 'current');
    } else {
      setFirstIntroductionPage();
    }
  });

  introduction.addEventListener('current-to-right', function (e) {
    var bullets = introduction.querySelector('.bullets'),
    current = bullets.querySelector('.current'),
    prev = current.previousElementSibling;
    removeClass(current, 'current');
    addClass(prev, 'current');
  });

  step1.addEventListener('click', function (e) {
    Animation.currentToLeft(introduction, introduction, introduction.nextElementSibling);
  });

  function setFirstIntroductionPage() {
    var firstBullet = introduction.querySelector('.bullet.first'),
    bullet = introduction.querySelector('.bullet.current'),
    firstPage = introduction.querySelector('.page.first'),
    page = introduction.querySelector('.page.current');
    removeClass(bullet, 'current');
    removeClass(page, 'current');
    addClass(firstBullet, 'current');
    addClass(firstPage, 'current');
  }
}());
