'use strict';

(function () {

  var step215 = document.getElementById('step2-15'),
  percentageBar = step215.querySelector('#revert-bar'),
  percentage = step215.querySelector('#revert-percent'),
  currentRevert = step215.querySelector('#current-revert'),
  amountRevert = step215.querySelector('#amount-revert'),
  fromTo = step215.querySelector('.from-to'),
  amount = 0;

  document.addEventListener('revert.start', function (e) {
    amount = e.detail.data;
    amountRevert.innerHTML = amount;
    show(fromTo);
  });

  document.addEventListener('revert.update', function (e) {
    var current = e.detail.data+1;
    currentRevert.innerHTML = current;
    setPercentage(current, amount);
  });

  document.addEventListener('revert.end', function (e) {
    setTimeout(function () {
      Animation.currentToLeft(step215, step215, step215.nextElementSibling);
    }, 2000);
  });

  function setPercentage(numberOfContactsDone, numberOfContacts){
    var p = parseInt((numberOfContactsDone/numberOfContacts)*100);
    percentage.innerHTML = p;
    percentageBar.style.width = p+'%';
  }
}());
