'use strict';

(function () {

  // import Objects
  var ContactService = exports.contactService,
  Message = exports.message,

  // code
  notification = document.getElementById('notification'),
  step2 = document.getElementById('step2'),
  percentageBar = step2.querySelector('#percentage-bar'),
  percentage = step2.querySelector('#percentage'),
  currentConvert = step2.querySelector('#current-convert'),
  amountConvert = step2.querySelector('#amount-convert'),
  fromTo = step2.querySelector('.from-to'),
  amount = 0;

  document.addEventListener('convert.start', function (e) {
    amount = e.detail.data;
    amountConvert.innerHTML = amount;
    show(fromTo);
  });

  document.addEventListener('convert.update', function (e) {
    var current = e.detail.data+1;
    currentConvert.innerHTML = current;
    setPercentage(current, amount);
  });

  document.addEventListener('convert.end', function (e) {
    setTimeout(function () {
      Animation.currentToLeft(step2, step2, step2.nextElementSibling);
    }, 2000);
  });

  document.addEventListener('storage.memory', function (e) {
    ContactService.revert();
    Animation.currentToRight(step2, step2, step2.previousElementSibling);
    setTimeout(function () {
      Notifier.notify(notification, Message['title.quotaexceedederror'], '');
    }, 600);
  });

  document.addEventListener('storage.error', function (e) {
    ContactService.revert();
    Animation.currentToRight(step2, step2, step2.previousElementSibling);
    setTimeout(function () {
      Notifier.notify(notification, Message['title.unexpected'], '');
    }, 600);
  });

  function setPercentage(numberOfContactsDone, numberOfContacts){
    var p = parseInt((numberOfContactsDone/numberOfContacts)*100);
    percentage.innerHTML = p;
    percentageBar.style.width = p+'%';
  }
}());
