'use strict';

function addClass(el, name) {
  el.className += ' ' + name;
}

function removeClass(el, name) {
  var oldClass = el.className, newClass = '',
    i, list = oldClass.split(' '), l = list.length;
  for (i = 0; i < l; i++) {
    if (list[i].trim() != name) {
      newClass += ' ' + list[i];
    }
  }
  el.className = newClass.trim();
}

function hasClass(el, name) {
  var oldClass = el.className, i,
  list = oldClass.split(' '), l = list.length;
  for (i = 0; i < l; i++) {
    if (list[i].trim() == name) {
      return true;
    }
  }
  return false;
}

function show(el) {
  el.style.display = 'block';
}

function hide(el) {
  el.style.display = 'none';
}

function toggleCheckbox(cb) {
  var checked = cb.previousElementSibling,
  check = checked.previousElementSibling;
  if (cb.checked) {
    hide(check);
    show(checked);
  } else {
    hide(checked);
    show(check);
  }
}
