'use strict';

(function () {

  // import Objects
  var errorEvent = new BusinessEvent('error.unexpected');

  exports.repository = {

    getPromise: function (service) {

      var deferred, promise;

      deferred = new Defer();

      promise = deferred.promise;

      promise.otherwise(genericError);

      service.onsuccess = function () {
        deferred.resolve(this);
      };

      service.onerror = function () {
        deferred.reject(this);
      };

      return promise;
    }
  };

  function genericError() {
    errorEvent.trigger();
  }
}());
