'use strict';

(function () {

  var memoryEvent = new BusinessEvent('storage.memory'),
  errorEvent = new BusinessEvent('storage.error');

  exports.contactStorage = {

    save: function (id, oldPhone, newPhone) {
      try {
        localStorage.setItem(''+id+newPhone, ''+oldPhone);
      } catch(e) {
        if (typeof e == 'QuotaExceededError') {
          memoryEvent.trigger();
        } else {
          errorEvent.trigger();
        }
      }
    },

    getPhone: function (key) {
      return localStorage.getItem(key);
    },

    clear: function () {
      localStorage.clear();
    },

    hasBackup: function () {
      var key = localStorage.key(0);
      return localStorage.getItem(key);
    }
  };
}());
