var concluido = 0;
var totalContatosAtualizados = 0;

function buscarContatos(callback) {
  concluido = 0;

  var contatos = [];

  var filter = {
    sortBy: name,
    sortOrder: 'ascending',
    filterBy: ['name'],
    filterValue: '',
    filterOp: 'startsWith'
  }
  
  var request = navigator.mozContacts.getAll(filter);

  var count = 0;

  request.onsuccess = function () {
    if(this.result) {

      contatos[count] = this.result;

      count++;
      
      contato = this.result;

      this.continue();
    } else {
      callback(contatos);
    }
  }
  
  request.onerror = function (ex) {
    console.log('Erro ao carregar contatos. Ex: ' + ex);
  }
}


function buscarContatosPorIdentificadores(identificador, valor, callback) {
  concluido = 0;

  var contatos = [];

  var filter = {
    sortBy: name,
    sortOrder: 'ascending',
    filterBy: [identificador],
    filterValue: [valor],
    filterOp: 'equals'
  }
  
  var request = navigator.mozContacts.find(filter);

  var count = 0;

  request.onsuccess = function () {
    if(this.result) {

      contatos = this.result;

      console.log("busca " + this.result);

      callback(contatos);

    } else {
      callback(contatos);
    }
  }
  
  request.onerror = function (ex) {
    console.log('Erro ao carregar contatos. Ex: ' + ex);
  }
}

function atualizarContato(tratarSemDddComoLocal, dddLocal, isCSP, contato, callback){
  var tels = [];
  var atualizou = false;

  if(contato.tel.length > 0){
    for(var i = 0; i < contato.tel.length; i++){
      var tel = contato.tel[i];
      console.log('type: ' + tel.type + ' value: ' + tel.value + ' carrier: ' + tel.carrier + ' pref: ' + tel.pref);

      if(isUpdate(tratarSemDddComoLocal, dddLocal, isCSP, tel.value)){

        atualizou = true;

        console.log('isUpdate');

        var numero = update(tratarSemDddComoLocal, dddLocal, isCSP, tel.value);

        tels[i] = {type: [tel.type], value: numero, carrier: tel.carrier, pref: tel.pref};
      }
    }

    if(atualizou){
      contato.tel = tels;

      var saving = navigator.mozContacts.save(contato);

      saving.onsuccess = function() {

        console.log('Contato atualizado com sucesso.');

        callback(false, true);
      };

      saving.onerror = function(err) {

        callback(true, false);

      };

    } else {

      callback(false, false);

    }

  } else {

    callback(false,false);

  }
}

function restaurarContato(contato, callback){

  buscarContatosPorIdentificadores('name', contato.name, function(contatosCarregados){

    if(contatosCarregados && contatosCarregados.length > 0){

      var contatoAtualizar = contatosCarregados[0];

      contatoAtualizar.tel = contato.tel;

      var saving = navigator.mozContacts.save(contatoAtualizar);

      saving.onsuccess = function() {

        console.log('Contato restaurado com sucesso.');

        callback(true);

      };

      saving.onerror = function(err) {

        callback(false);

      };
    }
    
  });
}