function isDddAtualizavel(ddd) {
	if(ddd == null || ddd.length != 2) {
		return false;
	} else if(ddd == "11") {
		return true;
	} else if((/^1[23456789]/).test(ddd)) {
		return true;
	} else if((/^2[12478]/).test(ddd)) {
		return true;
	} else if((/^9[123456789]/).test(ddd)) {
        return true;
    }else if((/^8[123456789]/).test(ddd)){
		return true;
	}else if((/^7[134579]/).test(ddd)){
		return true;
	}else if((/^3[1234578]/).test(ddd)){
		return true;
	}
	return false;
}

function update(tratarSemDddComoLocal, dddLocal, isCSP, msisdn) {

	if (msisdn == null)
		return null;

	msisdn = msisdn.trim();

	var orginal = msisdn;

	msisdn = normalize(msisdn);
	if (msisdn == null)
		return orginal;

	var result = msisdn;
	if (isValid(tratarSemDddComoLocal, dddLocal, msisdn))
		result = formatNine(tratarSemDddComoLocal, msisdn);

	if (isCSP)
		result = formatCSP(tratarSemDddComoLocal, dddLocal, isCSP, result);

	if(msisdn == result) {
		return result;
	} else {
		return format(orginal, result);
	}
}

function isUpdate(tratarSemDddComoLocal, dddLocal, isCSP,
		msisdn) {
	var result = update(tratarSemDddComoLocal, dddLocal, isCSP, msisdn);

	var regexp = new RegExp("[^0-9]", "g");

	if (result == null)
		return false;

	msisdn = msisdn.replace(regexp, "");
	result = result.replace(regexp, "");

	return !(msisdn == result);
}

function normalize(msisdn) {

	var regexp = new RegExp("[^0-9\\*\\+]", "g");
	var modifiedMsisdn = msisdn.replace(regexp, "");

	if (modifiedMsisdn.length < 8) {
		return null;
	}

	//Se iniciar com + e for diferente de +55
	if ((/^\+/).test(modifiedMsisdn)){
		if (!(/^\+55/).test(modifiedMsisdn)) {
			return null;
		}
	}

	//Se iniciar com 00 e for diferente de 0055
	if ((/^00/).test(modifiedMsisdn)){
		if (!(/^0055/).test(modifiedMsisdn)) {
			return null;
		}
	}

	if (modifiedMsisdn.indexOf("*") != -1) {
		return null;
	}

	regexp = new RegExp("[^0-9]", "g");
	msisdn = msisdn.replace(regexp, "");

	if (msisdn.length < 8) {
		return null;
	}

	if ((/^0/).test(msisdn) // Ex. 0800
			&& msisdn.substring(2, 4) == 0) {
		return null;
	}

	return msisdn;
}

function format(original, msisdn) {

	var regexp;

	if ((/^\+/).test(original) || (/^55/).test(original)) {
		// +55 1172185088
		if (msisdn.length == 12) {
			regexp = new RegExp("([0-9]{2,2})([0-9]{2,2})([0-9]{4,4})([0-9]{4,4})", "g");
			return msisdn.replace(regexp,"+$1 ($2) $3-$4");
		}

		if (msisdn.length == 13) {
			regexp = new RegExp("([0-9]{2,2})([0-9]{2,2})([0-9]{5,5})([0-9]{4,4})");
			return msisdn.replace(
					regexp,
					"+$1 ($2) $3-$4");
		}

		return msisdn;
	}

	if (msisdn.length == 8) {
		regexp = new RegExp("([0-9]{4,4})([0-9]{4,4})");
		return msisdn.replace(regexp, "$1-$2");
	}

	if (msisdn.length == 9) {
		regexp = new RegExp("([0-9]{4,5})([0-9]{4,4})");
		return msisdn.replace(regexp, "$1-$2");
	}

	if (msisdn.length == 10) {
		regexp = new RegExp("([0-9]{2,2})([0-9]{4,4})([0-9]{4,4})"); // 11 + 8
		return msisdn.replace(regexp,
				"($1) $2-$3");
	}

	if (msisdn.length == 11 && !(/^0/).test(msisdn)) { // 11 + 9
		regexp = new RegExp("([0-9]{2,2})([0-9]{5,5})([0-9]{4,4})");
		return msisdn.replace(regexp,
				"(0$1) $2-$3");
	}

	if (msisdn.length == 11) { // 011 + 8
		regexp = new RegExp("([0-9]{3,3})([0-9]{4,4})([0-9]{4,4})");
		return msisdn.replace(regexp,
				"($1) $2-$3");
	}

	if (msisdn.length == 12 && (/^9090/).test(msisdn)) { // 9090 + 8
		regexp = new RegExp("([0-9]{4,4})([0-9]{4,4})([0-9]{4,4})");
		return msisdn.replace(regexp,
				"$1 $2-$3");
	}

	if (msisdn.length == 12) { // 011 + 9
		regexp = new RegExp("([0-9]{3,3})([0-9]{5,5})([0-9]{4,4})");
		return msisdn.replace(regexp,
				"($1) $2-$3");
	}

	if (msisdn.length == 13 && (/^9090/).test(msisdn)) { // 9090 + 9
		regexp = new RegExp("([0-9]{4,4})([0-9]{5,5})([0-9]{4,4})");
		return msisdn.replace(regexp,
				"$1 $2-$3");
	}

	if (msisdn.length == 13) { // 0XX11 + 8
		regexp = new RegExp("([0-9]{3,3})([0-9]{2,2})([0-9]{4,4})([0-9]{4,4})");
		return msisdn.replace(regexp,
				"($1$2) $3-$4");
	}

	if (msisdn.length == 14 && (/^9/).test(msisdn)) { // 90XX11 + 8
		regexp = new RegExp("([0-9]{4,4})([0-9]{2,2})([0-9]{4,4})([0-9]{4,4})");
		return msisdn.replace(
				regexp,
				"($1$2) $3-$4");
	}

	if (msisdn.length == 14) { // 0XX11 + 9
		regexp = new RegExp("([0-9]{3,3})([0-9]{2,2})([0-9]{5,5})([0-9]{4,4})");
		return msisdn.replace(regexp,
				"($1$2) $3-$4");
	}

	if (msisdn.length == 15 && (/^9/).test(msisdn)) { // 90XX11 + 9
		regexp = new RegExp("([0-9]{4,4})([0-9]{2,2})([0-9]{5,5})([0-9]{4,4})");
		return msisdn.replace(
				regexp,
				"($1$2) $3-$4");
	}

	if ((/^\+/).test(original))
		return "+" + msisdn;

	return msisdn;
}

function formatCSP(tratarSemDddComoLocal, dddLocal, isCSP,
		msisdn) {

	if (msisdn.length >= 8 && isCSP) {

		if (msisdn.substring(0, 1) == 0
				&& msisdn.substring(2, 4) == 0) {
			return msisdn;
		}

		if (msisdn.length == 8
				&& msisdn.substring(0, 1) == 0)
			return msisdn;

		if (msisdn.length == 8 || msisdn.length == 9) { // 8 || 9
			if (tratarSemDddComoLocal)
				msisdn = "015" + dddLocal + msisdn;
		} else if (msisdn.length == 10) { // DD + 8
			var tmp = "015";
			tmp = tmp + msisdn.substring(0);
			msisdn = tmp;
		} else if (msisdn.length == 11
				&& msisdn.substring(0, 1) == 0) { // 0DD +
																	// 8
			var tmp = "015";
			tmp = tmp + msisdn.substring(1);
			msisdn = tmp;
		} else if (msisdn.length == 11
				&& msisdn.substring(0, 1) != 0) { // DD + 9
			var tmp = "015";
			tmp = tmp + msisdn.substring(0);
			msisdn = tmp;
		} else if (msisdn.length == 12
				&& msisdn.substring(0, 1) == 0) { // 0DD +
																	// 9
			var tmp = "015";
			tmp = tmp + msisdn.substring(1);
			msisdn = tmp;
		} else if (msisdn.length == 13
				&& msisdn.substring(0, 1) == 0) { // 0xxDD
																	// + 8
			var tmp = "015";
			tmp = tmp + msisdn.substring(3);
			msisdn = tmp;
		} else if (msisdn.length == 14
				&& msisdn.substring(0, 2) == 90) { // 90xxDD
																	// +
																	// 8
			var tmp = "9015";
			tmp = tmp + msisdn.substring(4);
			msisdn = tmp;
		} else if (msisdn.length == 14
				&& msisdn.substring(0, 4) == 55) { // 0055
																	// + 8
			return msisdn;
		} else if (msisdn.length == 14
				&& msisdn.substring(0, 1) == 0) { // 0xxDD
																	// + 9
			var tmp = "015";
			tmp = tmp + msisdn.substring(3);
			msisdn = tmp;
		} else if (msisdn.length == 15
				&& msisdn.substring(0, 2) == 90) { // 90xxDD
																	// +
																	// 9
			var tmp = "9015";
			tmp = tmp + msisdn.substring(4);
			msisdn = tmp;
		} else if (msisdn.length == 16
				&& msisdn.substring(4, 6) == 55
				&& msisdn.substring(0, 2) == 0) { // 00xxDD
																	// + 8
			var tmp = "0015";
			tmp = tmp + msisdn.substring(4);
			msisdn = tmp;
		} else if (msisdn.length == 17
				&& msisdn.substring(4, 6) == 55
				&& msisdn.substring(0, 2) == 0) { // 00xxDD
																	// + 9
			var tmp = "015";
			tmp = tmp + msisdn.substring(4);
			msisdn = tmp;
		}
	}
	return msisdn;
}

function formatNine(tratarSemDddComoLocal, msisdn) {
	if (msisdn.length >= 8) {
		if (msisdn.length == 8) {
			msisdn = "9" + msisdn;
		} else if (msisdn.length == 10
				&& isDddAtualizavel(msisdn.substring(0, 2))) {
			var tmp = msisdn.substring(0, 2);
			tmp = tmp + "9" + msisdn.substring(2);
			msisdn = tmp;
		} else if (msisdn.length == 11
				&& isDddAtualizavel(msisdn.substring(1, 3))) {
			var tmp = msisdn.substring(0, 3);
			tmp = tmp + "9" + msisdn.substring(3);
			msisdn = tmp;
		} else if (msisdn.length == 12
				&& (isDddAtualizavel(msisdn.substring(2, 4)) || (msisdn.substring(0, 4) == 9090 && tratarSemDddComoLocal))) { // 5511
			var tmp = msisdn.substring(0, 4);
			tmp = tmp + "9" + msisdn.substring(4);
			msisdn = tmp;
		} else if (msisdn.length == 13
				&& isDddAtualizavel(msisdn.substring(3, 5))) { // 01511
			var tmp = msisdn.substring(0, 5);
			tmp = tmp + "9" + msisdn.substring(5);
			msisdn = tmp;
		} else if (msisdn.length == 14
				&& isDddAtualizavel(msisdn.substring(4, 6))) { // 00 55
																	// 11
																	// + 8
			var tmp = msisdn.substring(0, 6);
			tmp = tmp + "9" + msisdn.substring(6);
			msisdn = tmp;
		} else if (msisdn.length == 16) {
			var tmp = msisdn.substring(0, 8);
			tmp = tmp + "9" + msisdn.substring(8);
			msisdn = tmp;
		}
	}
	return msisdn;
}

function isValid(tratarSemDddComoLocal, dddLocal, msisdn) {

	var dddMsisdn = null;

	var regexp = new RegExp("^0+", "g");

	if (msisdn.length >= 12
				&& msisdn.substring(0, 4) == 55
				&& !(msisdn.substring(0, 4).replace(regexp, "") == "55")
				&& !isDddAtualizavel(msisdn.substring(4, 6))) {
			return false;
		}

	if (msisdn.length < 8) {
			return false;
		} else if (msisdn.length == 8 ) {
			if(tratarSemDddComoLocal) {
				dddMsisdn = dddLocal;
			} else {
				return false;
			}
		} else if (msisdn.length == 9 || msisdn.length == 17) {
			return false;
		} else if (msisdn.length == 14
				&& !(msisdn.substring(0, 4).replace(regexp, "") == "55")
				&& !(isDddAtualizavel(msisdn.substring(4, 6)))
				&& msisdn.substring(0, 2) != 90) { // 0055DD
			return false;
		} else if (msisdn.length == 14
				&& (msisdn.substring(0, 1) =="0")) { // 0CSDD9 - Ja formatado
			//015119
			return false;
		} else if (msisdn.length == 11
				&& msisdn.substring(0, 1) != 0) {
			return false;
		} else if (msisdn.length == 12
				&& msisdn.substring(0, 1) == 0) {
			return false;
		} else if (msisdn.length == 13
				&& msisdn.substring(0, 2) == 55) {
			return false;
		}

		// //NSLog(@"Invalid 2: %@", msisdn);

		if (msisdn.length == 12
				&& msisdn.substring(0, 2) != 55
				&& msisdn.substring(0, 4) != 9090) {
			return false;
		} else if (msisdn.length == 13
				&& msisdn.substring(0, 1) != 0) {
			return false;
		} else if (msisdn.length == 16
				&& msisdn.substring(4, 6) != 55) {
			return false;
		}

		if (msisdn.length == 16
				&& msisdn.substring(0, 2) == 90
				&& !isDddAtualizavel(msisdn.substring(4, 6)) ) { // 90XXDD
			return false;
		} else if (msisdn.length == 12
				&& msisdn.substring(0, 4) == 9090) { // 9090
			if(tratarSemDddComoLocal) {
				dddMsisdn = dddLocal;
			} else {
				return false;
			}
		}

		if(dddMsisdn == null && msisdn.length >= 10) {
			dddMsisdn = msisdn.substring(msisdn.length - 10, msisdn.length - 8);
		}

		//FIXME: Verificar se e necessario tratar o NULL do dddMsisdn aqui.
		// Se for necessario, e por que a regra de verificacao de valido acima furou.

		var prefix = msisdn.substring(msisdn.length - 8);
		var sufix = prefix.substring(4, 8);

		prefix = prefix.substring(0, 4);
		var iPrefix = prefix;
		var iSufix = sufix;


	    if ((/^1[23456789]/).test(dddMsisdn) && isDddAtualizavel(dddMsisdn)) {
	    	//isDddAtualizavel - datas atualizacao
	        if (iPrefix <= 5999) {
	            return false;
	        } else if (iPrefix >= 7700 && iPrefix <= 7899) {
	            return false;
	        } else {
	            return true;
	        }
	    }

	    if ((/^2[12478]/).test(dddMsisdn) && isDddAtualizavel(dddMsisdn)) {
	    	//isDddAtualizavel - datas atualizacao
	        if (iPrefix <= 5999) {
	            return false;
	        } else if (iPrefix >= 7000 && iPrefix <= 7099) {
	            return false;
	        } else if (iPrefix >= 7700 && iPrefix <= 7899) {
	            return false;
	        } else {
	            return true;
	        }
	    }

	    // Verificação da validade dos novos DDD's para a regra do nono dígito
    	// Descrição dos novos CN's:
    	//      91 -> Pará     -> Prefixos válidos: entre 9100 e 9392
    	//      92 -> Amazonas -> Prefixos válidos: entre 9100 e 9555
    	//      93 -> Pará     -> Prefixos válidos: entre 9100 e 9240
    	//      94 -> Pará     -> Prefixos válidos: entre 9100 e 9305
    	//      95 -> Roraima  -> Prefixos válidos: entre 9111 e 9174
    	//      96 -> Amapá    -> Prefixos válidos: entre 9100 e 9208
    	//      97 -> Amazonas -> Prefixos válidos: entre 9143 e 9199
    	//      98 -> Maranhão -> Prefixos válidos: entre 9100 e 9225
    	//      99 -> Maranhão -> Prefixos válidos: entre 9100 e 9228
   		//
        // 	// verificação do range de números para o estado do Amapá (CN 96)
        //  if ((dddMsisdn == "96") && isDddAtualizavel(dddMsisdn)) {
        //      return iPrefix >= 9100 && iPrefix <= 9208;
        //  }
        //
        // 	// verificação do range de números para o estado do Amazonas (CNs 92 e 97)
        //	if ((/^9[27]/).test(dddMsisdn) && isDddAtualizavel(dddMsisdn)) {
        //	    return  (dddMsisdn == "92" && iPrefix >= 9100 && iPrefix <= 9555) ||
        //   	        (dddMsisdn == "97" && iPrefix >= 9143 && iPrefix <= 9199);
        //	}
        //
        // 	// verificação do range de números para o estado do Maranhão (CNs 98 e 99)
        //	if ((/^9[89]/).test(dddMsisdn) && isDddAtualizavel(dddMsisdn)) {
        //	    return  (dddMsisdn == "98" && iPrefix >= 9100 && iPrefix <= 9225) ||
        //	            (dddMsisdn == "99" && iPrefix >= 9100 && iPrefix <= 9228);
        //	}
        //
        // 	// verificação do range de números para o estado do Pará (CNs 91, 93 e 94)
        //	if ((/^9[134]/).test(dddMsisdn) && isDddAtualizavel(dddMsisdn)) {
        //	    return  (dddMsisdn == "91" && iPrefix >= 9100 && iPrefix <= 9392) ||
        //	            (dddMsisdn == "93" && iPrefix >= 9100 && iPrefix <= 9240) ||
        //	            (dddMsisdn == "94" && iPrefix >= 9100 && iPrefix <= 9305);
        //	}
        //
        // 	// verificação do range de número para o estado e Roraima (CN 95)
        //	if (dddMsisdn == "95" && isDddAtualizavel(dddMsisdn)) {
        //	    return iPrefix >= 9111 && iPrefix <= 9174;
        //	}
        //
        //
        // De acordo com e-mail enviado pelo Thiago Henrique Daud de Faria em 02/10/2014 11:19 a regra acima
    	// deve ser alterada para a seguinte regra :
    	// Descrição dos novos CN's:
    	//      91 ... 99 -> Prefixos válidos: (6, 8, 9, 70, 71, 72, 73, 74, 75, 76 e 79)
    	//
		if (isDddAtualizavel(dddMsisdn)) {

			if( (/^9[123456789]/).test(dddMsisdn) || (/^8[123456789]/).test(dddMsisdn)
					|| (/^7[134579]/).test(dddMsisdn) || (/^3[1234578]/).test(dddMsisdn) ){

				return ((iPrefix >= 6000 && iPrefix <= 6999) ||		// Prefixo  6:  "6"000 -> "6"999
						(iPrefix >= 8000 && iPrefix <= 8999) ||		// Prefixo  8:  "8"000 -> "8"999
						(iPrefix >= 9000 && iPrefix <= 9999) ||		// Prefixo  9:  "9"000 -> "9"999
						(iPrefix >= 7000 && iPrefix <= 7099) ||		// Prefixo 70:  "70"00 -> "70"99
						(iPrefix >= 7100 && iPrefix <= 7199) ||		// Prefixo 71:  "71"00 -> "71"99
						(iPrefix >= 7200 && iPrefix <= 7299) ||		// Prefixo 72:  "72"00 -> "72"99
						(iPrefix >= 7300 && iPrefix <= 7399) ||		// Prefixo 73:  "73"00 -> "73"99
						(iPrefix >= 7400 && iPrefix <= 7499) ||		// Prefixo 74:  "74"00 -> "74"99
						(iPrefix >= 7500 && iPrefix <= 7599) ||		// Prefixo 75:  "75"00 -> "75"99
						(iPrefix >= 7600 && iPrefix <= 7699) || 	// Prefixo 76:  "76"00 -> "76"99
						(iPrefix >= 7900 && iPrefix <= 7999));		// Prefixo 79:  "79"00 -> "79"99
			}
		}


	    if (dddMsisdn == "11" && isDddAtualizavel(dddMsisdn)) {
	    	//isDddAtualizavel - datas atualizacao
	    	if (iPrefix <= 4999) {
	    		return false;
	    	} else if (iPrefix >= 6000 && iPrefix <= 6999) {
	    		return true;
	    	} else if (iPrefix >= 8000 && iPrefix <= 9999) {
	    		return true;
	    	} else if (iPrefix >= 7000 && iPrefix <= 7010) {
	    		return false;
	    	} else if (iPrefix >= 7700 && iPrefix <= 7908) {
	    		return false;
	    	} else if (iPrefix >= 7910 && iPrefix <= 7921) {
	    		return false;
	    	} else if (iPrefix >= 7923 && iPrefix <= 7949) {
	    		return false;
	    	}

	    	// Invalid 5*

	    	if (iPrefix >= 5010 && iPrefix <= 5019) {
	    		return false;
	    	} else if (iPrefix >= 5021 && iPrefix <= 5022) {
	    		return false;
	    	} else if (iPrefix == 5029) {
	    		return false;
	    	} else if (iPrefix >= 5031 && iPrefix <= 5036) {
	    		return false;
	    	} else if (iPrefix >= 5041 && iPrefix <= 5042) {
	    		return false;
	    	} else if (iPrefix >= 5044 && iPrefix <= 5046) {
	    		return false;
	    	} else if (iPrefix == 5049) {
	    		return false;
	    	} else if (iPrefix >= 5051 && iPrefix <= 5056) {
	    		return false;
	    	} else if (iPrefix == 5058) {
	    		return false;
	    	} else if (iPrefix == 5060 && iSufix >= 0 && iSufix <= 5999) {
	    		return false;
	    	} else if (iPrefix >= 5061 && iPrefix <= 5063) {
	    		return false;
	    	} else if (iPrefix >= 5065 && iPrefix <= 5074) {
	    		return false;
	    	} else if (iPrefix >= 5077 && iPrefix <= 5099) {
	    		return false;
	    	} else if (iPrefix >= 5102 && iPrefix <= 5103) {
	    		return false;
	    	} else if (iPrefix >= 5105 && iPrefix <= 5105) {
	    		return false;
	    	} else if (iPrefix == 5110 && iSufix >= 0 && iSufix <= 999) {
	    		return false;
	    	} else if (iPrefix >= 5111 && iPrefix <= 5112) {
	    		return false;
	    	} else if (iPrefix == 5115) {
	    		return false;
	    	} else if (iPrefix == 5171) {
	    		return false;
	    	} else if (iPrefix >= 5180 && iPrefix <= 5189) {
	    		return false;
	    	} else if (iPrefix == 5191) {
	    		return false;
	    	} else if (iPrefix >= 5212 && iPrefix <= 5213) {
	    		return false;
	    	} else if (iPrefix >= 5501 && iPrefix <= 5519) {
	    		return false;
	    	} else if (iPrefix >= 5521 && iPrefix <= 5529) {
	    		return false;
	    	} else if (iPrefix >= 5531 && iPrefix <= 5539) {
	    		return false;
	    	} else if (iPrefix >= 5541 && iPrefix <= 5549) {
	    		return false;
	    	} else if (iPrefix == 5553) {
	    		return false;
	    	} else if (iPrefix >= 5560 && iPrefix <= 5568) {
	    		return false;
	    	} else if (iPrefix >= 5571 && iPrefix <= 5576) {
	    		return false;
	    	} else if (iPrefix >= 5579 && iPrefix <= 5579) {
	    		return false;
	    	} else if (iPrefix >= 5581 && iPrefix <= 5589) {
	    		return false;
	    	} else if (iPrefix >= 5591 && iPrefix <= 5599) {
	    		return false;
	    	} else if (iPrefix == 5601) {
	    		return false;
	    	}

	    	if (iPrefix == 5603) {
	    		return false;
	    	} else if (iPrefix >= 5611 && iPrefix <= 5616) {
	    		return false;
	    	} else if (iPrefix == 5620 && iSufix >= 0 && iSufix <= 1999) {
	    		return false;
	    	} else if (iPrefix >= 5621 && iPrefix <= 5627) {
	    		return false;
	    	} else if (iPrefix >= 5631 && iPrefix <= 5635) {
	    		return false;
	    	} else if (iPrefix >= 5641 && iPrefix <= 5646) {
	    		return false;
	    	} else if (iPrefix >= 5660 && iPrefix <= 5663) {
	    		return false;
	    	} else if (iPrefix >= 5665 && iPrefix <= 5679) {
	    		return false;
	    	} else if (iPrefix >= 5681 && iPrefix <= 5683) {
	    		return false;
	    	} else if (iPrefix >= 5685 && iPrefix <= 5687) {
	    		return false;
	    	} else if (iPrefix == 5691) {
	    		return false;
	    	} else if (iPrefix >= 5693 && iPrefix <= 5696) {
	    		return false;
	    	} else if (iPrefix >= 5698 && iPrefix <= 5699) {
	    		return false;
	    	} else if (iPrefix >= 5811 && iPrefix <= 5812) {
	    		return false;
	    	} else if (iPrefix == 5814) {
	    		return false;
	    	} else if (iPrefix >= 5816 && iPrefix <= 5819) {
	    		return false;
	    	} else if (iPrefix >= 5821 && iPrefix <= 5827) {
	    		return false;
	    	} else if (iPrefix >= 5831 && iPrefix <= 5835) {
	    		return false;
	    	} else if (iPrefix == 5837) {
	    		return false;
	    	} else if (iPrefix == 5839) {
	    		return false;
	    	} else if (iPrefix >= 5841 && iPrefix <= 5846) {
	    		return false;
	    	} else if (iPrefix >= 5851 && iPrefix <= 5855) {
	    		return false;
	    	} else if (iPrefix == 5870 && iSufix >= 0 && iSufix <= 2999) {
	    		return false;
	    	} else if (iPrefix == 5873) {
	    		return false;
	    	} else if (iPrefix == 5875 && iSufix >= 9000) {
	    		return false;
	    	} else if (iPrefix >= 5890 && iPrefix <= 5899) {
	    		return false;
	    	} else if (iPrefix == 5904) {
	    		return false;
	    	} else if (iPrefix >= 5906 && iPrefix <= 5909) {
	    		return false;
	    	} else if (iPrefix == 5920 && iSufix >= 0 && iSufix <= 4999) {
	    		return false;
	    	} else if (iPrefix == 5920 && iSufix >= 8000 && iSufix <= 8999) {
	    		return false;
	    	} else if (iPrefix >= 5921 && iPrefix <= 5929) {
	    		return false;
	    	} else if (iPrefix >= 5931 && iPrefix <= 5934) {
	    		return false;
	    	} else if (iPrefix >= 5938 && iPrefix <= 5939) {
	    		return false;
	    	} else if (iPrefix == 5970 && iSufix >= 0 && iSufix <= 5999) {
	    		return false;
	    	} else if (iPrefix >= 5971 && iPrefix <= 5979) {
	    		return false;
	    	}

	    	return true;
	    }

	    return false;
}
