var totalContatos = 0;
var totalAtualizados = 0;
var contatosVerificados = 0;
var ocorreuErro = false;
var exibido = false;
var totalNaoAtualizados = 0;

var callbackAtualizacaoContato = function(erro, atualizou) {
  toastr.options.timeout = 5;
  toastr.options.closeButton = true;

  if(!erro)
    contatosVerificados++;
  else
    ocorreuErro = true;

  if(atualizou)
    totalAtualizados++;

  console.log("contatos verificados: " + contatosVerificados + " total contatos: " + totalContatos);

  if(contatosVerificados == totalContatos || ((contatosVerificados != totalContatos) && ocorreuErro))
  {
    ocultarLoading();

    if(!ocorreuErro)
    {

      if(totalAtualizados > 0)
        toastr.success(totalAtualizados + " contato(s) atualizado(s).");
      else
        toastr.info("Nenhum contato foi atualizado.");

      if(localStorage.length > 0) {
        $("#btnDesfazer").removeAttr("disabled");
      } else {
        $("#btnDesfazer").attr("disabled", "disabled");
      }

    } else {
      toastr.error("Ocorreu um erro ao atualizar os contatos, tente novamente.");
    }
  }
};

var callbackRecuperacaoContato = function(atualizou) {
  toastr.options.timeout = 5;
  toastr.options.closeButton = true;

  if(atualizou)
    totalAtualizados++;
  else
    totalNaoAtualizados++;

  var totalVerificados = totalAtualizados + totalNaoAtualizados;

  console.log("contatos verificados: " + totalVerificados + " total contatos: " + totalContatos);

  if(totalVerificados == totalContatos)
  {
    ocultarLoading();

    if(totalAtualizados > 0)
      toastr.success(totalAtualizados + " contato(s) restaurado(s).");
    else
      toastr.info("Nenhum contato foi restaurado.");

    localStorage.clear();
    $("#btnDesfazer").attr("disabled", "disabled");
  }
};

$(document).on('pageinit','#splash',function(){
    setTimeout(function(){
        $.mobile.changePage("#home", "fade");
    }, 2000);
});

$(document).on('pageshow', '#home', function(){
  if(localStorage.getItem("popup") == null && !exibido){
    exibido = true;
    $("#popupDialog").popup('open');
  }
});

$(document).ready(function(){

  if(localStorage.length > 0) {
    $("#btnDesfazer").removeAttr("disabled");
  } else {
    $("#btnDesfazer").attr("disabled", "disabled");
  }

  $("#btnAtualizar").bind("click", function(event, ui) {
    atualizar();
  });

  $("#btnDesfazer").bind("click", function(event, ui) {
    desfazer();
  });

  $('#chkTermo').on('change', function() { 
    if(this.checked) {
      $("#btnAtualizar").removeAttr("disabled");
    } else {
      $("#btnAtualizar").attr("disabled", "disabled");
    }
  });

  $('#chkPopup').on('change', function() { 
    if(this.checked) {
      localStorage.setItem("popup", true);
    } else {
      localStorage.removeItem("popup");
    }
  });

   $("#chkDDDs").on('change', function() {
    if(this.checked){
      $('#txtDDD').removeAttr('readonly');
    }else{
      $('#txtDDD').attr('readonly','readonly');
      $('#txtDDD').val('');
    }
  });
});




//Funções da agenda
function atualizar(){
  if(validarCampos()){

    var contatosBackup = localStorage.getItem("Backup");

    var msg = confirm("Confirma a atualização dos seus contatos para incluir o 9º dígito? Este processo pode levar algum tempo dependendo da quantidade de contatos da sua agenda.");
    if (msg == true) {
      if(contatosBackup) {
        var msgBackup = confirm("Existe um backup da sua agenda, se você atualizar novamente a sua agenda, esse backup será substituído.");
        if(msgBackup == true)
        {
          atualizarContatos();
        }
      } else {
        atualizarContatos();
      }
    }
  }

  function atualizarContatos() {
    totalContatos = 0;
    totalAtualizados = 0;
    contatosVerificados = 0;
    ocorreuErro = false;

    buscarContatos(function(contatos){
      console.log(contatos.length + " contatos encontrados");

      if(contatos.length > 0){

        localStorage.setItem("Backup", JSON.stringify(contatos));

        totalContatos = contatos.length;

        exibirLoading("Atualizando contatos....");

        for(var i = 0; i < contatos.length; i++){

          atualizarContato($("#chkDDDs").prop('checked'), $("#txtDDD").val(), $("#chkCSP").prop('checked'), contatos[i], callbackAtualizacaoContato);

        }

      } else {
        toastr.info("Nenhum contato foi encontrado na agenda.");
      }
    });
  }
}

function desfazer(){
  totalContatos = 0;
  totalAtualizados = 0;
  contatosVerificados = 0;
  ocorreuErro = false;

  var msg = confirm("Confirma a restauração dos contatos salvos anteriormente?");
  if (msg == true) {
    exibirLoading("Carregando contatos....");

    var listaBackup = localStorage.getItem("Backup");

    var contatosSalvos = JSON.parse(listaBackup);

    totalContatos = contatosSalvos.length;

    for(var i = 0; i < contatosSalvos.length; i++){

      restaurarContato(contatosSalvos[i], callbackRecuperacaoContato)

    }
  } 
}

//Validações
function validarCampos() {
  toastr.options.timeout = 5;
  toastr.options.closeButton = true;

  if ($("#chkDDDs").prop('checked')){

    if($("#txtDDD").val() <= 9){

      toastr.warning("Preencha o campo DDD.");
      return false;
    }

  }

  if(!$("#chkTermo").prop('checked')){

    toastr.warning("Aceite os termos de uso.");

    return false;

  }

  return true;
}


//Loading
function exibirLoading(mensagem){
  $.blockUI({ message: mensagem, css: { border: 'none',
    padding: '15px',
    backgroundColor: '#000',
    '-webkit-border-radius': '10px',
    '-moz-border-radius': '10px',
    top:  ($(window).height() - 80) /2 + 'px', 
    left: (($(window).width() - 225) /2) + 'px',
    width: '200px',
    heigth: '100px',
    opacity: .5,
    color: '#fff',
    baseZ: 99999999,
  },
  ignoreIfBlocked: true
});
}

function ocultarLoading(){
  $.unblockUI();
}