app.controller("mainController", function ($scope, $http, $q, $timeout) {

    $scope.apiKey = "[YOUR API KEY HERE]";
    $scope.br_rez = -1;
    $scope.results = [];
    $scope.showToolbar = false;
    $scope.shareDefinicija = "";
    $scope.showStatus = false;
    $scope.prikaziPoruku = false;
    $scope.poruka = '';

    $scope.pretraga = function () {
        $scope.prikaziPoruku = false;
        $scope.poruka = '';
        $scope.loading = true;
        $scope.results = [];
        var nova_rec = $scope.pojam.replace("c'", "ć");
        var nova_rec = nova_rec.replace("c^", "č");
        var nova_rec = nova_rec.replace("dz^", "dž");
        var nova_rec = nova_rec.replace("s^", "š");
        var nova_rec = nova_rec.replace("s^", "š");
        $scope.pojam = nova_rec;
        //console.log(nova_rec);
        $scope.trazi($scope.pojam);
        $scope.addItemIstorija();

    };

    // test kod	
    $scope.items = '';
    $scope.odabraneDefinicije = '';

    // create a store ("table") for istorija
    istorija = new IDBStore({
        storeName: 'istorija',
        keyPath: 'id',
        autoIncrement: true,
        onStoreReady: refreshTableIstorija
    });

    // create a store ("table") for odabrane
    odabrane = new IDBStore({
        storeName: 'odabrane',
        keyPath: 'id',
        autoIncrement: true,
        onStoreReady: refreshTableOdabrane
    });


    //	var dataStore = new IDBStore('todos', initCallback);
    //istorija funkcije
    var getItemsSuccessIstorija = function (data) {
        $scope.items = data;
        //$scope.$apply();
    };

    var errorCallback = function () {
        console.log('error');
    };


    var getItemsIstorija = function () {
        istorija.getAll(getItemsSuccessIstorija, errorCallback);
        //console.log('getItems');
    };

    $scope.addItemIstorija = function () {
        istorija.put({ 'pojam': $scope.pojam }, getItemsIstorija, errorCallback);
        //console.log($scope.pojam);
    };

    function refreshTableIstorija() {
        getItemsIstorija();
    };

    //odabrane funkcije
    var getItemsSuccessOdabrane = function (data) {
        $scope.odabraneDefinicije = data;
        //console.log(data);
    };

    var errorCallback = function () {
        console.log('error');
    };


    var getItemsOdabrane = function () {
        odabrane.getAll(getItemsSuccessOdabrane, errorCallback);
       // console.log('getItems');
    };

    $scope.addItemOdabrane = function () {
        odabrane.put({ 'rec': $scope.shareDefinicija.rec, 'poreklo': $scope.shareDefinicija.poreklo, 'opis': $scope.shareDefinicija.opis }, getItemsOdabrane, errorCallback);
       // console.log($scope.pojam + "DODAT");
    };

    function refreshTableOdabrane() {
        getItemsOdabrane();
    };

    //share funkcije

    $scope.toolbar = function (definicija) {
        $scope.shareDefinicija = definicija;
        $scope.showToolbar = true;
    }

    $scope.share = function () {
        var body = $scope.shareDefinicija.rec + " " + $scope.shareDefinicija.poreklo + " - " + $scope.shareDefinicija.opis.replace(/(<([^>]+)>)/ig, "");;
        var a = new MozActivity({
            name: 'new',
            data: {
                url: "mailto:?subject=" + "Vokabular - definicija reči:" + $scope.shareDefinicija.rec + "&body=" + body, // za email,
                body: body, // za sms ako i kad bude podrzano
                number: "", // prazan broj na koji se salje
                type: ["websms/sms", "mail"]
            }
        });
        $scope.dismissToolbar();
    }

    $scope.dismissToolbar = function () {
        $scope.shareDefinicija = "";
        $scope.showToolbar = false;
    }

    $scope.dodajUOdabrane = function () {
        $scope.addItemOdabrane($scope.shareDefinicija);
        $scope.dismissToolbar();
        var prikaziStatus = function () {
            $scope.showStatus = true;
        }
        var sakrijStatus = function () {
            $scope.showStatus = false;
        }
        $timeout(prikaziStatus, 500);
        $timeout(sakrijStatus, 3000);
    }

    //kraj test koda



    $scope.trazi = function ($rec) {
        // id aplikacije
        var m_app_id = 'vokab_droid';

        // privatni kljuc aplikacije
        var m_key = '8j4fhr73nh2df4i98de2';

        //TODO: IZMENI
        // jedinstvena oznaka korisnika. treba da bude ista za jednog korisnika aplikacije. 
        var m_user_id = '381658938765';

        // ID upita, jedinstveni broj koji se mora menjati sa svakim upitom
        var num = Math.floor(Math.random() * 10000000);
        var m_req_id = num.toString();

        // kljuc za pretragu       
        var m_search = $rec;

        // oznaka pisma: sr - cirilica, sr-lat - latinica
        var m_lang = 'sr-lat';

        // ceksum upita
        var hash = m_req_id + m_search + m_user_id + m_app_id + m_key;
        var m_cksum = hex_md5(hash);

        //TODO ODRADITI OVO i MENJATI CH SH i ostala slova...
        //
        // u JSON objektu polje 'status' daje status odgovora. Ako je 'OK', to znaci da je upit ispravan i da je obradjen.
        //
        // Greske:
        //
        // - no_query: nije navedena kljuc za pretragu
        //
        // - not_found : nije nadjena rech
        //
        // - unknown_application: id apliakcije je nepoznat
        //
        // - no_request_id: nedostaje ID upita
        //
        // - no_user_id: nedostaje user id
        //
        // - checksum_mismatch: ceksum upit se ne podudara
        //
        // - slow_down: korisnik precesto salje upite. neki uputi ce mu biti odbijeni da se rastereti server.
        //
        // Polje 'count' daje ukupan broj slogova koji odgovara upitu. Odgovor sadrzi najvise pet slogova pa ako je 
        // count veci od pet valja korisnika uputiti da prosiri upit tako da dobije precizniji odgovor sa manje slogova.
        //
        // Polje 'result' je niy sa sadryajem opisa reci koje su vracene kao odgovor na upit.
        //
        //

        // putanja za izvrsenje upita
        var m_url = 'http://www.vokabular.org/app_search.php?search=' + m_search + '&app_id=' + m_app_id + '&req_id=' + m_req_id + '&user_id=' + m_user_id + '&cksum=' + m_cksum + '&lang=' + m_lang + '&callback=JSON_CALLBACK';
       
        $http.jsonp(m_url).success(function (data) {
            if (data.status == "ok") {
                var rezultati = data.result;
                //console.log(data.result);
                $scope.br_rez = data.count;
                var i = 1;
                angular.forEach(rezultati, function (value) {
                    value.id = i + ')';
                    i++;
                    value.poreklo = '(' + value.poreklo + ')';
                    value.opis = value.opis.replace(/\*(\S[^\*]+\S)\*/g, "<i>$1</i>");
                    $scope.results.push(value);
                });
                $scope.loading = false;
            }
            else if (data.status = "not_found") {
                $scope.poruka = "Nema rezultata koji odgovaraju upitu.";
                $scope.loading = false;
                $scope.prikaziPoruku = true;
            }
            else {
                $scope.poruka = "Došlo je do greše prilikom upita. Molimo pokušajte ponovo.";
                $scope.loading = false;
                $scope.prikaziPoruku = true;
            }
        }).error(function (error) {
            $scope.loading = false;
        });

    };
});

app.filter('obrni', function () {
    return function (items) {
        if (items !== undefined) return items.slice().reverse();
    };
});

app.controller("IstorijaController", function ($scope, $http, $location) {
    // test kod	
    $scope.istorijaId = '';
    $scope.istorijaPojam = '';
    $scope.showDetails = false;
    $scope.loading = true;
    var initCallback = function () {
        getItems();

    };

    // create a store ("table") for the customers
    istorija = new IDBStore({
        storeName: 'istorija',
        keyPath: 'id',
        autoIncrement: true,
        onStoreReady: refreshTable
    });


    var getItemsSuccess = function (data) {
        $scope.items = data;
        //console.log(data);
        $scope.loading = false;
        $scope.$apply();
    };

    var errorCallback = function () {
        //console.log('error');
        $scope.loading = false;
    };


    var getItems = function () {
        istorija.getAll(getItemsSuccess, errorCallback);
        //console.log('getItems');
    };

    function refreshTable() {
        getItems();
    };

    $scope.deleteItemIstorija = function () {
        istorija.remove($scope.istorijaId, refreshTable);
        $scope.dismissToolbarIstorija();
    }
    

    $scope.ocistiIstoriju = function () {
        istorija.clear();
        $scope.showDetails = !$scope.showDetails;
        refreshTable();
    }
    //toolbar
    $scope.toolbarIstorija = function (id, pojam) {
        $scope.istorijaId = id;
        $scope.istorijaPojam = pojam;
        $scope.showToolbar = true;
    }

    $scope.shareIstorija = function () {
        var a = new MozActivity({
            name: 'new',
            data: {
                url: "mailto:?subject=" + "Vokabular" + "&body=" + "Pretraga reči:" + $scope.istorijaPojam, // za email,
                body: $scope.istorijaPojam, // za sms ako i kad bude podrzano
                number: "", // prazan broj na koji se salje
                type: ["websms/sms", "mail"]
            }
        });
        $scope.dismissToolbarIstorija();
    }

    $scope.dismissToolbarIstorija = function () {
        $scope.shareDefinicija = "";
        $scope.showToolbar = false;
    }

    //$scope.traziIstorija = function () {
    //    $scope.boolIstorijaPretraga = true;
    //    $scope.$emit('someEvent', "shone");
    //    var url2 = $location.absUrl();
    //    var url1 = url2.substring(0, url2.length - 14);
    //    window.location.href = url1 + "/index.html";
    //    $scope.showToolbar = false;
    //}


});

//odabrane kontroler 
app.controller("OdabraneController", function ($scope, $http) {
    $scope.loading = true;
    $scope.showDetails = false;

    // create a store ("table") for odabrane
    odabrane = new IDBStore({
        storeName: 'odabrane',
        keyPath: 'id',
        autoIncrement: true,
        onStoreReady: refreshTableOdabrane
    });

    var initCallback = function () {
        getItemsOdabrane();
    };

    //odabrane funkcije
    var getItemsSuccessOdabrane = function (data) {
        $scope.odabraneDefinicije = data;
        //console.log(data);
        $scope.loading = false;
        $scope.$apply();

    };

    var errorCallback = function () {
        //console.log('error');
    };


    var getItemsOdabrane = function () {
        odabrane.getAll(getItemsSuccessOdabrane, errorCallback);
        //console.log('getItems');
    };

    $scope.addItemOdabrane = function () {
        odabrane.put({ 'rec': $scope.shareDefinicija.rec, 'poreklo': $scope.shareDefinicija.poreklo, 'opis': $scope.shareDefinicija.opis }, getItemsOdabrane, errorCallback);
        //console.log($scope.pojam);
    };

    function refreshTableOdabrane() {
        getItemsOdabrane();
    };

    $scope.deleteItemOdabrane = function () {
        odabrane.remove($scope.shareDefinicija.id, refreshTableOdabrane);
        $scope.dismissToolbarOdabrane();
    }

    $scope.ocistiOdabrane = function () {
        odabrane.clear();
        $scope.showDetails = !$scope.showDetails;
        refreshTableOdabrane();
    }

    //toolbar
    $scope.toolbarOdabrane = function (definicija) {
        $scope.shareDefinicija = definicija;
        $scope.showToolbar = true;
    }

    $scope.shareOdabrane = function () {
        var body = $scope.shareDefinicija.rec + " " + $scope.shareDefinicija.poreklo + " - " + $scope.shareDefinicija.opis.replace(/(<([^>]+)>)/ig, "");;
        var a = new MozActivity({
            name: 'new',
            data: {
                url: "mailto:?subject=" + "Vokabular - definicija reči:" + $scope.shareDefinicija.rec + "&body=" + body, // za email,
                body: body, // za sms ako i kad bude podrzano
                number: "", // prazan broj na koji se salje
                type: ["websms/sms", "mail"]
            }
        });
        $scope.dismissToolbarOdabrane();
    }

    $scope.dismissToolbarOdabrane = function () {
        $scope.shareDefinicija = "";
        $scope.showToolbar = false;
    }



});