var volcanoJson = {
	"volcanes":[
		{
			"id": "1",
			"pais": "ESTADOS UNIDOS",
			"nombre": "Caldera de Yellowstone",
			"camaras":["volcanoes.usgs.gov/yvo/images/webcam/mobile1/current_small.jpg?0.7859957715139009","www.nps.gov/webcams-yell/oldfaith2.jpg","www.nps.gov/webcams-yell/oldfaithvc.jpg"],
			"sismografos":["volcanoes.usgs.gov/vsc/captures/yellowstone/ylt_last_24.png","volcanoes.usgs.gov/vsc/captures/yellowstone/yml_last_24.png","volcanoes.usgs.gov/vsc/captures/yellowstone/b207_last_24.png","volcanoes.usgs.gov/vsc/captures/yellowstone/ypp_last_24.png?0.49618476228632463"]
		},
		{
			"id": "2",
			"pais": "ESTADOS UNIDOS",
			"nombre": "KILAUEA",
			"camaras": ["hvo.wr.usgs.gov/cams/KIcam/images/PAN.jpg",
						 "hvo.wr.usgs.gov/cams/K2cam/images/M.jpg",
						 "hvo.wr.usgs.gov/cams/HMcam/images/M.jpg",
						 "hvo.wr.usgs.gov/cams/HTcam/images/M.jpg",
						 "hvo.wr.usgs.gov/cams/R3cam/images/M.jpg",
						 "modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=2&lonmin=-155.772&latmin=19.185&\"lonmax=-154.812&latmax=19.665&xsize=1509.&ysize=800"
						],
			"sismografos": []
		},
		{
			"id": "3",
			"pais": "ESTADOS UNIDOS",
			"nombre": "Monte Santa Helena",
			"camaras": ["www.fs.fed.us/gpnf/volcanocams/msh/images/mshvolcanocam.jpg",
						 "www.fs.fed.us/gpnf/volcanocams/msh/hdimages/volcanocamhd.jpg",
						 "www.fs.fed.us/gpnf/volcanocams/msh/hdimages/volcanocamhd.jpg"
						],
			"sismografos": []
		},
		{
			"id": "4",
			"pais": "NUEVA ZELANDA",
			"nombre": "Monte Ruapehu",
			"camaras": ["www.geonet.org.nz/images/volcano/volcams/ruapehu/ruapehu.jpg?0.7137976342930217",
						 "www.geonet.org.nz/images/volcano/volcams/ruapehu-ngauruhoe/ruapehu-ngauruhoe.jpg?0.18964073560243427",
						 "satepsanone.nesdis.noaa.gov/pub/OMI/OMISO2/images/newzealand.gif"
						],
			"sismografos": ["www.geonet.org.nz/p/volcano/drums/latest/fwvz-seismic-drum.png"]
		},
		{
			"id": "5",
			"pais": "NUEVA ZELANDA",
			"nombre": "Monte Tongariro",
			"camaras": ["www.geonet.org.nz/images/volcano/volcams/ngauruhoe/ngauruhoe.jpg"],
			"sismografos": ["www.geonet.org.nz/p/volcano/drums/latest/wtvz-seismic-drum.png"]
		},
		{
			"id": "6",
			"pais": "COLOMBIA",
			"nombre": "Volcán Galeras",
			"camaras": ["amenazas.ingeominas.gov.co/webcam/pasto/galeras-bruma000.jpg"],
			"sismografos": ["amenazas.ingeominas.gov.co/helicorders/pasto/heli/ANGV_SHZ_OP_--.2014020212.gif?0.20589730865322053"]
		},
		{
			"id": "7",
			"pais": "MÉXICO",
			"nombre": "Popocatepetl",
			"camaras": ["www.cenapred.gob.mx/images/popo1.jpg",
						 "www.cenapred.gob.mx/images/popoTlamacas2.jpg",
						 "www.cenapred.unam.mx/images/imagenPopoTochimilco.jpg",
						 "www.cenapred.unam.mx/images/popoSur.JPG"
						],
			"sismografos": ["www2.ssn.unam.mx/~yi/SSN/sismogramaPP.gif"]
		},
		{
			"id": "8",
			"pais": "ECUADOR",
			"nombre": "Volcán Tungurahua",
			"camaras": ["camaras.igepn.edu.ec/camaras/ovt/ovt.jpg",
						 "camaras.igepn.edu.ec/camaras/achupashal/achs.jpg",
						 "camaras.igepn.edu.ec/camaras/pillate/pllt.jpg",
						 "modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=-78.622&latmin=-1.587&lonmax=-78.262&latmax=-1.347&xsize=1200.&ysize=800"
						],
			"sismografos": ["correo.igepn.edu.ec/heli/heli/RETU_SHZ_EC_--.2014020212.gif"]
		},
		{
			"id": "9",
			"pais": "ALASKA",
			"nombre": "Monte Lliamna",
			"camaras": ["www.avo.alaska.edu/webcam/iliamna.jpg?0.4735970830941637"],
			"sismografos": ["www.avo.alaska.edu/webicorders/INE24hr_heli.png?0.5623135402292847"]
		},
		{
			"id": "10",
			"pais": "ECUADOR",
			"nombre": "Volcán Reventador",
			"camaras": ["camaras.igepn.edu.ec/camaras/rvntdr/rvntdr.jpg",
 "modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=-77.836&latmin=-0.198&lonmax=-77.476&latmax=0.042&xsize=1200.&ysize=800"],
			"sismografos": ["correo.igepn.edu.ec/heli/heli/CONE_SHZ_EC_--.2014020200.gif?0.5633293173741549"]
		},
		{
			"id": "11",
			"pais": "ECUADOR",
			"nombre": "Volcán Cotopaxi",
			"camaras": ["camaras.igepn.edu.ec/camaras/barrancas/brrncs.jpg",
 "camaras.igepn.edu.ec/camaras/catalina/ctln.jpg",
 "modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=-78.616&latmin=-0.797&lonmax=-78.256&latmax=-0.557&xsize=1200.&ysize=800"],
			"sismografos": []
		},
		{
			"id": "12",
			"pais": "ESTADOS UNIDOS",
			"nombre": "Monte Rainier",
			"camaras": ["www.nps.gov/webcams-mora/mountain.jpg",
 "modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=-121.94&latmin=46.733&lonmax=-121.58&latmax=46.973&xsize=821.&ysize=800"],
			"sismografos": []
		},
		{
			"id": "13",
			"pais": "ITALIA",
			"nombre": "Monte Etna",
			"camaras": ["www3.shizuokanet.ne.jp/sinet/cam.acgi$sendImg_now",
 "modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=138.551&latmin=35.238&lonmax=138.911&latmax=35.478&xsize=979.&ysize=800"],
			"sismografos": []
		},
		{
			"id": "14",
			"pais": "CHILE",
			"nombre": "Monte Copahue",
			"camaras": ["www.sernageomin.cl/camaras/Copahue/fija/copahue.jpg",
 "modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=-71.35&latmin=-37.97&lonmax=-70.99&latmax=-37.73&xsize=948.&ysize=800"],
			"sismografos": []
		},
		{
			"id": "15",
			"pais": "INDONESIA",
			"nombre": "Monte Merapi",
			"camaras": ["www.merapi.bgl.esdm.go.id/view.php?id=1",
 "www.merapi.bgl.esdm.go.id/view.php?id=68?0.362631700919432",
 "modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=110.262&latmin=-7.662&lonmax=110.622&latmax=-7.422&xsize=1190.&ysize=800"],
			"sismografos": []
		},
		{
			"id": "16",
			"pais": "ISLA MONSERRAT",
			"nombre": "Monte Soufriere Holls",
			"camaras": ["webobs.mvo.ms/cgi-bin/photo_alt.pl"],
			"sismografos": []
		},
		{
			"id": "17",
			"pais": "ALASKA",
			"nombre": "Monte Katmai",
			"camaras": ["www.avo.alaska.edu/webcam/katmai_kabu.jpg",
 "modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=-155.2233&latmin=58.159&lonmax=-154.6833&latmax=58.399&xsize=946.&ysize=800"],
			"sismografos": []
		},
		{
			"id": "18",
			"pais": "ESPAÑA",
			"nombre": "El Hierro",
			"camaras": ["laspuntas.myipcamera.com:1024/img/snapshot.cgi?size=3&quality=1?0.36018017842434347"],
			"sismografos": []
		},
		{
			"id": "19",
			"pais": "JAPÓN",
			"nombre": "Monte Sukurajima",
			"camaras": ["www.iuk.ac.jp/sakurajima/sakura01.JPG",
 "modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=130.477&latmin=31.465&lonmax=130.837&latmax=31.705&xsize=1022.&ysize=800"],
			"sismografos": []
		},
		{
			"id": "20",
			"pais": "RUSIA",
			"nombre": "Monte Kliuchevskoi",
			"camaras": ["volcano.febras.net/archive/latest_Klyu.jpg","volcano.febras.net/archive/latest_Klyu2.jpg"],
			"sismografos": ["web.volcanodiscovery.com/fileadmin/charts/quakes-v28_3_7_2014_11_07_2014.png"]
		},
		{
			"id": "21",
			"pais": "RUSIA",
			"nombre": "Monte Kizimen",
			"camaras": ["www.emsd.ru/video/Kizimen/img_1.jpg",
 "modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=160.05&latmin=55.01&lonmax=160.59&latmax=55.25&xsize=1029.&ysize=800"],
			"sismografos": ["data.emsd.ru/kizimen/img/swan.png"]
		},
		{
			"id": "22",
			"pais": "TANZANIA",
			"nombre": "Monte Kilimanjaro",
			"camaras": ["www.kilicam.com/cam_image/tuskerpic.jpg"],
			"sismografos": []
		},
		{
			"id": "23",
			"pais": "ITALIA",
			"nombre": "Monte Vesuvio",
			"camaras": ["www.campanialive.it/webcam/napolivesuvio/napoli.jpg?0.33316099356882334",
 "www.campanialive.it/webcam/napolicentro/napolicentro.jpg?0.422783364308998","meteovesuvio.altervista.org/DCS-932L.jpg?0.9291241562459618"],
			"sismografos": []
		},
		{
			"id": "24",
			"pais": "JAPÓN",
			"nombre": "Monte Aso",
			"camaras": ["archive.volcanodiscovery.com/webcam/images/459/latest.jpg",
 "w3.vgs.kyoto-u.ac.jp/hondocam/newimage.jpg?0.3971038409508765",
 "www33.ocn.ne.jp/~kazashi/image/licamaso.jpg?0.06223796959966421",
 "rkk.jp/cgi-bin/mmeye/aso3_view.cgi?0.24718318623490632",
 "rkk.jp/cgi-bin/mmeye/aso1_view.cgi?0.774548439309001"],
			"sismografos": []
		},
		{
			"id": "25",
			"pais": "JAPÓN",
			"nombre": "Monte Asama",
			"camaras": ["222.146.205.220:8080/s3?ope=view&CamNo=11&PAGE=?0.979581123450771"],
			"sismografos": []
		},
		{
			"id": "26",
			"pais": "ALASKA",
			"nombre": "Akutan",
			"camaras": ["www.avo.alaska.edu/webcam/akutan_aksd.jpg?0.7945985638070852","modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=-166.166&latmin=54.014&lonmax=-165.806&latmax=54.254&xsize=350.&ysize=400"],
			"sismografos": ["www.avo.alaska.edu/webicorders/AKV24hr_heli.png?0.537699282169342"]
		},
		{
			"id": "27",
			"pais": "VANUATU",
			"nombre": "Aoba",
			"camaras": ["www.geohazards.gov.vu/tmp/Pics/LVVL_PICS.jpg?0.5620627356693149","modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=167.65&latmin=-15.52&lonmax=168.01&latmax=-15.28&xsize=500.&ysize=400"],
			"sismografos": ["www.geohazards.gov.vu/tmp/Pics/LVVL_drumplot.jpg?0.4546326342970133"]
		},
		{
			"id": "28",
			"pais": "ALASKA",
			"nombre": "Augustine",
			"camaras": ["www.avo.alaska.edu/webcam/augtst.jpg?0.6733308846596628","www.avo.alaska.edu/webcam/augustine.jpg?0.8003221731632948","modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=-153.7&latmin=59.243&lonmax=-153.16&latmax=59.483&xsize=500.&ysize=400"],
			"sismografos": []
		},
		{
			"id": "29",
			"pais": "RUSIA",
			"nombre": "Bezymianny",
			"camaras": ["www.emsd.ru/video/Bezymianny/img_1.jpg","http://modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=160.317&latmin=55.858&lonmax=160.857&latmax=56.098&xsize=500.&ysize=400"],
			"sismografos": ["web.volcanodiscovery.com/fileadmin/charts/quakes-v790_3_7_2014_11_07_2014.png?0.7412908733822405"]
		},
		{
			"id": "30",
			"pais": "GUATEMALA",
			"nombre": "Volcán de Fuego",
			"camaras": ["www.insivumeh.gob.gt/geofisica/vulcanologia/Fuego.jpg"],
			"sismografos": ["www.insivumeh.gob.gt:8060/FG3_SHZ_GI.2014071112.gif"]
		},
		{
			"id": "31",
			"pais": "GUATEMALA",
			"nombre": "Volcán Santiaguito",
			"camaras": ["www.insivumeh.gob.gt/geofisica/vulcanologia/Santiaguito.jpg"],
			"sismografos": []
		},
		{
			"id": "32",
			"pais": "ITALIA",
			"nombre": "Stromboli",
			"camaras": ["www.ct.ingv.it/dati/webcams/Sqv/20140711/1700/Sqv0352.jpg","www.ct.ingv.it/dati/webcams/Sqt/20140711/1700/Sqt0352.jpg"],
			"sismografos": []
		},
		{
			"id": "33",
			"pais": "PERÚ",
			"nombre": "Ubinas",
			"camaras": ["ovi.ingemmet.gob.pe/visual/ubinas2/upload/actual.jpg","http://modis.higp.hawaii.edu/cgi-bin/modis/mergeimage64?maptype=relief&jperiod=7&lonmin=-71.083&latmin=-16.475&lonmax=-70.723&latmax=-16.235&xsize=500.&ysize=400"],
			"sismografos": ["vulcanologia.igp.gob.pe/ub1.php?0.19896825193427503"]
		}

	]
};

function json_p(urldir,dat,jsonpCallbackFunction,succesFunction,errorFunction){
	
	if(dat.fun==1){
		forecast = urldir;
		var xhr = new XMLHttpRequest({
	    	mozSystem: true
	 	});
	}

  	xhr.open('get', forecast, true);
  	xhr.onreadystatechange = function() {
    var status;
    var data;
    

    if (xhr.readyState == 4) { // `DONE`
      status = xhr.status;
      if (status == 200) {
      	var template='';
      	jsonp = xhr.responseText;
      	var xml = jsonp,
		xmlDoc = $.parseXML( xml ),
		$xml = $( xmlDoc );
		//$item = $xml.find( "item" );
		var loop = 0;
		$xml.find("item").each(function () {
			if(loop >= 10)
				 return false;
			else
			{
				
				var name = $(this).find('title').text();
		       	var description = $(this).find('description').text();
		       	var date = $(this).find('pubDate').text();
		       	var link = $(this).find('link').text();
		       	d = new Date(date);
		       
		       	var img = (name.search("earthquake") != -1)? "img/sismo.png" : "img/volcano.png";
		 		template = '<li><article class="uk-comment articleRss"><img class="uk-comment-avatar" src="'+img+'" alt=""><header class="uk-comment-header"><h4 class="uk-comment-title">'+name+'</h4><div class="uk-comment-meta">'+d.toLocaleDateString()+' '+d.toLocaleTimeString()+' | '+'<a href="'+link+'" target="_black">'+description+'</a>'+' |</div></header></article><hr></li>';
		 		$("#ulrss").append(template);
		 		loop = loop+1;
			}

	    });
			
		$("#owl-demo").hide();
		$("#btncargar").hide();
		$("#leabelVolcanes").hide();
		$("#listrss").show();

      	
      } else {

       alert("Error, intente nuevamente.");
      }
    }
  };
  xhr.send();
}
function share(i)
{
	text =  i.split('-');
	id = text[1];

	var urlimg = document.querySelector("#shareimg-"+id).getAttribute('src');

  	var xhr = new XMLHttpRequest({
        mozSystem: true
    });
    xhr.open("GET", urlimg, true);
    xhr.responseType = "blob";
	xhr.onload = function () {
	            var blob = this.response;
	            var img = document.createElement('img');
	            img.onload = function (e) {
	                window.URL.revokeObjectURL(img.src); // Clean up after yourself.
	            };
	            img.src = window.URL.createObjectURL(blob);
	            //document.body.appendChild(img);

	            var sdcard = navigator.getDeviceStorage('pictures');
	            var request = sdcard.delete("ShareImgVolcanoView.png");
	            request.onsuccess = function () {
	                //console.log("File Deleted");
	                var sdcard = navigator.getDeviceStorage('pictures');
	                var fblob = new Blob([xhr.response], {
	                    type: 'image/png'
	                });
	                var srequest = sdcard.addNamed(fblob, "ShareImgVolcanoView.png");
	                srequest.onsuccess = function () {
	                    //console.log("File Saved after Deleting");

	                }
	                srequest.onerror = function (e) {
	                    //console.log("File Could Not Be Saved" + e);
	                }
	                var sharingImage = new MozActivity({
                        name: "share",
                        data: {
                            type: "image/*",
                            number: 1,
                            blobs: [fblob],
                            filenames: ["volcanoview.png"]
                        }
                    });
	            };
	            // An error typically occur if a file with the same name already exist
	            request.onerror = function () {
	                //console.log('Unable to write the file: ' + this.error.name);
	                var sdcard = navigator.getDeviceStorage('pictures');
	                var fblob = new Blob([xhr.response], {
	                    type: 'image/png'
	                });
	                var srequest = sdcard.addNamed(fblob, "ShareImgVolcanoView.png");
	                srequest.onsuccess = function () {
	                    //console.log("File Saved");
	                }
	                srequest.onerror = function (e) {
	                    //console.log("File Could Not Be Saved" + e);
	                }
	            };

	        };


	        xhr.onerror = function () {
	            alert("Error with System XHR");
	        };
	        xhr.send();
}
function loadvolcano(i)
{
	text =  i.split('-');
	id = text[1];
	$('#owl-demo').empty();
	$('#btncargar').hide();
	id= id-1;

	var template = '<article><h3>'+volcanoJson.volcanes[id].pais+' - '+volcanoJson.volcanes[id].nombre+'</h3></article><div class="uk-thumbnail uk-thumbnail-expand"  style=""><img id="shareimg-'+id+'" src="http://'+volcanoJson.volcanes[id].camaras[0]+'" alt="" class="uk-border-rounded uk-animation-scale-down"><div class="uk-thumbnail-caption"><div id="share-'+id+'"><img src="img/icon_share.png" /></div></div>                    </div>';
	$.each( volcanoJson.volcanes[id].camaras, function( key, value ) {
		if(key != null && key > 0)
		{
			template += '<div class="uk-thumbnail uk-thumbnail-expand item"  style=""><img id="shareimg-'+key+'" src="http://'+value+'" alt="" class="uk-border-rounded uk-animation-scale-down"><div class="uk-thumbnail-caption"><div  id="share-'+key+'"><img src="img/icon_share.png" /></div>                   </div> </div>';
		}
	});
	$.each( volcanoJson.volcanes[id].sismografos, function( key, value ) {
		if(key != null)
		{
			template += '<div class="uk-thumbnail uk-thumbnail-expand item"  style=""><img id="shareimg-'+key+'" src="http://'+value+'" alt="" class="uk-border-rounded uk-animation-scale-down"><div class="uk-thumbnail-caption"><div  id="share-'+key+'"><img src="img/icon_share.png" /></div>                    </div> </div>';
		}
	});
	$('#owl-demo').append(template);
	appendEvent();
	
}
function appendEvent ()
{
	$('div[id^="share-"]').click(function(){
		share( $(this).attr('id'));
	});	


	
}
function randomLoad(name)
{
	$('#owl-demo').empty();
	var l = Object.keys(name).length - 1;
	
	var json = {volcanes:[]};
	var n = [];
	for (var i = 0; i <= 5 ; i++) {
		index = nrandom(l);
		if(!repetido(n,index)) n.push(index);
		else i--;
	}
	for (var i = 0; i <= 5 ; i++) {
		template = '<div id="id-'+name[n[i]].id+'"  class="uk-thumbnail uk-thumbnail-expand item"  style=""><img src="http://'+name[n[i]].camaras[0]+'" alt="" class="uk-border-rounded uk-animation-scale-down"><div id="" class="uk-thumbnail-caption loadvolcano uk-text-large uk-text-bold">'+name[n[i]].pais+' - '+name[n[i]].nombre+'</div>                    </div>';
		$('#owl-demo').append(template);
	}
	
	trigger();

}
function trigger()
{
	$('div[id^="id-"]').click(function(){
		if(checkConnection() == false)
		{
				return false;
		}
		else
			loadvolcano( $(this).attr('id'));
	});
	$("#owl-demo").owlCarousel({
 
      navigation : false, // Show next and prev buttons
      slideSpeed : 300,
      paginationSpeed : 400,
      singleItem:true
 
  	});

}
function repetido(a,n)
{

	var repe = false; 
	for (i=0; i<a.length; i++) 
	{
		 if (n == a[i]) { repe = true; } 
	} 
	return repe;
}
function nrandom(l)
{
	return index =	Math.floor((Math.random() * l) );
}

function checkConnection() 
{

	if(!navigator.onLine){
		// No tenemos conexión
	
		alert('Network not available');
	}

	return navigator.onLine;
}

function list(name)
{
	$('#owl-demo').empty();
	$('#owl-demo').show();
	$('#listrss').hide();
	$('#btncargar').hide();
	$('#leabelVolcanes').show();
	tempvolcano = name;
	var l = Object.keys(tempvolcano).length - 1;

	var n = [];
	for (var i = 0; i <= l ; i++) {
		n.push(tempvolcano[i].nombre+'-'+i);
	}
	n.sort();
	
	for (var i = 0; i <= l ; i++) {
		temp =  n[i].split('-');
		id = temp[1];
		template = '<div id="id-'+name[id].id+'"  class="uk-thumbnail uk-thumbnail-expand item"  style=""><img src="http://'+name[id].camaras[0]+'" alt="" class="uk-border-rounded uk-animation-scale-down"><div id="" class="uk-thumbnail-caption loadvolcano uk-text-large uk-text-bold">'+name[id].pais+' - '+name[id].nombre+'</div>                    </div>';
		$('#owl-demo').append(template);
	}
	
	trigger();

}
//document ready
$(document).ready(function() {
  // Handler for .ready() called.
	// app.initialize();
	//document.addEventListener("deviceready", onDeviceReady, false);
	
	$('#menu-acercade').click(function(){
		$('#btncargar').hide();
		$('#owl-demo').hide();
		$('#listrss').hide();
		$('#leabelVolcanes').hide();
		$('#infoAvolcano').hide();
		$('#infoVolcano').hide();
		$('#acercade').show();
	});

	if(checkConnection() == false)
	{
			return false;
	}
	else
		randomLoad(volcanoJson.volcanes);

	$('#cargar').click(function(){
		if(checkConnection() == false)
		{
				return false;
		}
		else{
			$('#acercade').hide();
			randomLoad(volcanoJson.volcanes);
		}
	});

	$('#btn-asc').click(function(){
		if(checkConnection() == false)
		{
				return false;
		}
		else{
			$('#acercade').hide();
			list(volcanoJson.volcanes);
		}
	});

	
	
	$('#btn-rss').click(function(){
		var data={};
		data.fun = 1;
		if(checkConnection() == false)
		{
				return false;
		}
		else
			json_p("http://volcanodiscovery.com/index.php?id=1351&type=100",data,null,null,null);
	});

	$('#btn-rateapp').click(function(){
		var activity = new MozActivity({
	    name: "view",
	    data: {
	              type: "url",
	               url: "https://marketplace.firefox.com/app/volcanoview"
	          }
	    })
	});

	$('#btn-volcanoinf').click(function(){
		$('#btncargar').hide();
		$('#owl-demo').hide();
		$('#listrss').hide();
		$('#leabelVolcanes').hide();
		$('#acercade').hide();
		$('#infoVolcano').show();
		$('#infoAvolcano').hide();
	});

	$('#btn-volcanoact').click(function(){
		$('#btncargar').hide();
		$('#owl-demo').hide();
		$('#listrss').hide();
		$('#leabelVolcanes').hide();
		$('#infoVolcano').hide();
		$('#infoAvolcano').show();
	});
	
});