var started = 0; // 1 if game started, 0 if game not started
var serving = 0; // 1 if team 1 serving, 2 if team 2 serving, 0 if uninitialized
var scoret1 = 0; // score for team 1
var scoret2 = 0; // score for team 2

var log = [];    // log for undoing (later for viewing game flows)

// Check the presence of teams. Returns true if all are filled, false if at least one empty spot
function checkteams(){
  if ($("div.linear#t1 input#p1").val() == "" ||
      $("div.linear#t1 input#p2").val() == "" ||
      $("div.linear#t1 input#p3").val() == "" ||
      $("div.linear#t1 input#p4").val() == "" ||
      $("div.linear#t1 input#p5").val() == "" ||
      $("div.linear#t1 input#p6").val() == "" ||
      $("div.linear#t2 input#p1").val() == "" ||
      $("div.linear#t2 input#p2").val() == "" ||
      $("div.linear#t2 input#p3").val() == "" ||
      $("div.linear#t2 input#p4").val() == "" ||
      $("div.linear#t2 input#p5").val() == "" ||
      $("div.linear#t2 input#p6").val() == "" ) {return false;}
  else {return true;}
}

// Check the presence of teams on the court (diagram). Returns true if filled, false if at least one empty spot.
function checktabular(){
  if ($("div.tabular#t1 input#p1").val() == "" ||
      $("div.tabular#t1 input#p2").val() == "" ||
      $("div.tabular#t1 input#p3").val() == "" ||
      $("div.tabular#t1 input#p4").val() == "" ||
      $("div.tabular#t1 input#p5").val() == "" ||
      $("div.tabular#t1 input#p6").val() == "" ||
      $("div.tabular#t2 input#p1").val() == "" ||
      $("div.tabular#t2 input#p2").val() == "" ||
      $("div.tabular#t2 input#p3").val() == "" ||
      $("div.tabular#t2 input#p4").val() == "" ||
      $("div.tabular#t2 input#p5").val() == "" ||
      $("div.tabular#t2 input#p6").val() == "" ) {return false;}
  else {return true;}
}

// Move players on team 1 on court
$("#onCourt1").on("click", function(){
  $("div.tabular#t1 input#p1").val($("div.linear#t1 input#p1").val());
  $("div.tabular#t1 input#p2").val($("div.linear#t1 input#p2").val());
  $("div.tabular#t1 input#p3").val($("div.linear#t1 input#p3").val());
  $("div.tabular#t1 input#p4").val($("div.linear#t1 input#p4").val());
  $("div.tabular#t1 input#p5").val($("div.linear#t1 input#p5").val());
  $("div.tabular#t1 input#p6").val($("div.linear#t1 input#p6").val());
});

// More players on team 2 on court
$("#onCourt2").on("click", function(){
  $("div.tabular#t2 input#p1").val($("div.linear#t2 input#p1").val());
  $("div.tabular#t2 input#p2").val($("div.linear#t2 input#p2").val());
  $("div.tabular#t2 input#p3").val($("div.linear#t2 input#p3").val());
  $("div.tabular#t2 input#p4").val($("div.linear#t2 input#p4").val());
  $("div.tabular#t2 input#p5").val($("div.linear#t2 input#p5").val());
  $("div.tabular#t2 input#p6").val($("div.linear#t2 input#p6").val());
});

// Display the score
function updatescore(){
  $("#scoret1").val(scoret1);
  $("#scoret2").val(scoret2);
}

// Display the serving team (checkbox)
function updateserver(){
  if (serving == 1) {checkservingt1();}
  if (serving == 2) {checkservingt2();}
}

// Check the team 1 serving box (disallowed if game already started)
$("#servingt1").on("click", function(){
  if (started == 1) {alert("Game has already started."); return false;}
  else {checkservingt1();}
});

// Check the team 2 serving box (disallowed if game already started)
$("#servingt2").on("click", function(){
  if (started == 1) {alert("Game has already started."); return false;}
  else {checkservingt2();}
});

// Mechanics to check team 1 box and uncheck team 2 box
function checkservingt1(){
  $("#servingt2").prop("checked", false);
  $("#servingt1").prop("checked", true);
  serving = 1;
}

// Mechanics to check team 2 box and uncheck team 1 box
function checkservingt2(){
  $("#servingt1").prop("checked", false);
  $("#servingt2").prop("checked", true);
  serving = 2;
}


// Add score to team 1.
// Start game if not started already
// Check the serving, rotate if necessary, increase the score, and add to log
// Also redraw score
$("#plus1t1").on("click", function(){
  if (started == 0) { if (startgame()){} else {return false;}}
  if (serving == 1) {}
  else {checkservingt1(); rotatet1();}
  scoret1 += 1;
  log.push(1);
  updatescore();
});

// Add score to team 2.
// Start game if not started already
// Check the serving, rotate if necessary, increase the score, and add to log
// Also redraw score
$("#plus1t2").on("click", function(){
  if (started == 0) { if (startgame()){} else {return false;}}
  if (serving == 2) {}
  else {checkservingt2(); rotatet2();}
  scoret2 += 1;
  log.push(2);
  updatescore();
});

// Start the game. Returns false and doesn't start game if the line-ups aren't completely filled.
// Returns true if game has been successfully started.
function startgame(){
  if (!checkteams()) {alert("Please fill in the line-ups."); return false;}
  if (!checktabular()) {$("#onCourt1").trigger("click"); $("#onCourt2").trigger("click");}
  started = 1;
  return true;
}

// Rotate team 1
// First rotate them on the lineup, then just click oncourt
function rotatet1(){
  var 
    p1 = $("div.linear#t1 input#p1").val(),
    p2 = $("div.linear#t1 input#p2").val(),
    p3 = $("div.linear#t1 input#p3").val(),
    p4 = $("div.linear#t1 input#p4").val(),
    p5 = $("div.linear#t1 input#p5").val(),
    p6 = $("div.linear#t1 input#p6").val();

  $("div.linear#t1 input#p1").val(p2);
  $("div.linear#t1 input#p2").val(p3);
  $("div.linear#t1 input#p3").val(p4);
  $("div.linear#t1 input#p4").val(p5);
  $("div.linear#t1 input#p5").val(p6);
  $("div.linear#t1 input#p6").val(p1);

  $("#onCourt1").trigger("click");
};

// Rotate team 2
// First rotate them on the lineup, then just click oncourt
function rotatet2(){
  var 
    p1 = $("div.linear#t2 input#p1").val(),
    p2 = $("div.linear#t2 input#p2").val(),
    p3 = $("div.linear#t2 input#p3").val(),
    p4 = $("div.linear#t2 input#p4").val(),
    p5 = $("div.linear#t2 input#p5").val(),
    p6 = $("div.linear#t2 input#p6").val();

  $("div.linear#t2 input#p1").val(p2);
  $("div.linear#t2 input#p2").val(p3);
  $("div.linear#t2 input#p3").val(p4);
  $("div.linear#t2 input#p4").val(p5);
  $("div.linear#t2 input#p5").val(p6);
  $("div.linear#t2 input#p6").val(p1);

  $("#onCourt2").trigger("click");
};

// Unrotate team 1
function unrotatet1(){
  var 
    p1 = $("div.linear#t1 input#p1").val(),
    p2 = $("div.linear#t1 input#p2").val(),
    p3 = $("div.linear#t1 input#p3").val(),
    p4 = $("div.linear#t1 input#p4").val(),
    p5 = $("div.linear#t1 input#p5").val(),
    p6 = $("div.linear#t1 input#p6").val();

  $("div.linear#t1 input#p1").val(p6);
  $("div.linear#t1 input#p2").val(p1);
  $("div.linear#t1 input#p3").val(p2);
  $("div.linear#t1 input#p4").val(p3);
  $("div.linear#t1 input#p5").val(p4);
  $("div.linear#t1 input#p6").val(p5);

  $("#onCourt1").trigger("click");
};

// Unrotate team 2
function unrotatet2(){
  var 
    p1 = $("div.linear#t2 input#p1").val(),
    p2 = $("div.linear#t2 input#p2").val(),
    p3 = $("div.linear#t2 input#p3").val(),
    p4 = $("div.linear#t2 input#p4").val(),
    p5 = $("div.linear#t2 input#p5").val(),
    p6 = $("div.linear#t2 input#p6").val();

  $("div.linear#t2 input#p1").val(p6);
  $("div.linear#t2 input#p2").val(p1);
  $("div.linear#t2 input#p3").val(p2);
  $("div.linear#t2 input#p4").val(p3);
  $("div.linear#t2 input#p5").val(p4);
  $("div.linear#t2 input#p6").val(p5);

  $("#onCourt2").trigger("click");
};

// Undo.
// Pop from the log, subtract the score, check who's serving, and unrotate if necessary
$("#undo").on("click", function(){
  var lastteam;
  lastteam = log.pop();
       if (lastteam == 1) {scoret1 -= 1; serving = log[log.length-1];
         if (log[log.length-1] != lastteam) {unrotatet1();}}
  else if (lastteam == 2) {scoret2 -= 1; serving = log[log.length-1]
         if (log[log.length-1] != lastteam) {unrotatet2();}}
  updatescore();
  updateserver();
});

// Show the howto message
$("button.howto").on("click", function(){
  $("td.instructions ol").toggleClass("hidden");
  if($("td.instructions ol").hasClass("hidden")) { $("button.howto").text("Help \u25BC"); }
  else { $("button.howto").text("Help \u25B2"); }
  return false;
});

// Show the howto message when h button pressed
$(document).keypress(function(e){
  var c = String.fromCharCode(e.which);
  if(c == "h"){
    $("button.howto").trigger("click");
  }
});
