'use strict';


// Declare app level module which depends on filters, and services
angular.module('watuu', [
  'ngRoute',
  'watuu.animations',
  'watuu.filters',
  'watuu.services',
  'watuu.directives',
  'watuu.controllers',
  'watuu.messenger',
  'gettext'
]).
config(['$routeProvider', function($routeProvider) {
  $routeProvider.when('/index', {templateUrl: 'partials/index.html', controller: 'IndexController'});
  $routeProvider.when('/login', {templateUrl: 'partials/login.html', controller: 'UserController'});
  $routeProvider.when('/home', {templateUrl: 'partials/home.html', controller: 'WatuuController'});
  $routeProvider.when('/watuu-list', {templateUrl: 'partials/watuu-list.html', controller: 'WatuuListController'});
  $routeProvider.when('/option', {templateUrl: 'partials/option.html', controller: 'SettingController'});
  $routeProvider.when('/privacy-policy', {templateUrl: 'partials/privacy-policy.html', controller: 'SettingController'});
  $routeProvider.when('/credits', {templateUrl: 'partials/credits.html', controller: 'SettingController'});
  $routeProvider.when('/change-password', {templateUrl: 'partials/change-password.html', controller: 'SettingController'});
  $routeProvider.when('/menu', {templateUrl: 'partials/menu.html', controller: 'SettingController'});
  $routeProvider.when('/contacts', {templateUrl: 'partials/contacts.html', controller: 'FriendsController'});
  $routeProvider.when('/facebook-contacts', {templateUrl: 'partials/fb-contacts.html', controller: 'FacebookFriendsController'});
  $routeProvider.when('/watuu-contacts', {templateUrl: 'partials/w-contacts.html', controller: 'WatuuFriendsController'});
  $routeProvider.when('/search-friends', {templateUrl: 'partials/search-friends.html', controller: 'SearchFriendsController'});
  $routeProvider.when('/register', {templateUrl: 'partials/register.html', controller: 'UserController'});
  $routeProvider.when('/profile', {templateUrl: 'partials/profile.html', controller: 'UpdateProfileController'});
  $routeProvider.when('/getcontacts', {templateUrl: 'partials/getcontacts.html', controller: 'RegistrationController'});
  $routeProvider.when('/takepicture', {templateUrl: 'partials/takepicture.html', controller: 'RegistrationController'});
  $routeProvider.when('/fillprofile', {templateUrl: 'partials/fillprofile.html', controller: 'RegistrationController'});
  $routeProvider.when('/propose', {templateUrl: 'partials/propose.html', controller: 'SettingController'});
  $routeProvider.when('/conversations', {templateUrl: 'partials/conversations.html', controller: 'ConversationsController'});
  $routeProvider.when('/chat', {templateUrl: 'partials/chat.html', controller: 'ChatController'});
  $routeProvider.when('/share', {templateUrl: 'partials/share.html', controller: 'ShareController'});
  $routeProvider.when('/offline', {templateUrl: 'partials/offline.html', controller: 'OfflineController'});
  $routeProvider.otherwise({redirectTo: '/index'});
}]).run(function (gettextCatalog) {
    gettextCatalog.currentLanguage = navigator.mozL10n.language.code;
});
