function IDB_initDB(database, version) {
	window.indexedDB = window.indexedDB || window.mozIndexedDB || window.webkitIndexedDB || window.msIndexedDB;
	window.IDBTransaction = window.IDBTransaction || window.webkitIDBTransaction || window.msIDBTransaction;
	window.IDBKeyRange = window.IDBKeyRange || window.webkitIDBKeyRange || window.msIDBKeyRange;

	// HANDLE COMPATIBILITY ISSUES
	if(!window.indexedDB) {
		alert("IndexedDB is not supported in this browser.");
	}

	// OPEN INDEXED DB
	window.db = null;
	var request = window.indexedDB.open(database, version);
	// OPEN INDEXED DB ERRORS
	request.onerror = function(event) {
		// INIT ERROR OCCURRED
		alert("Please allow storage access as it is necessary for this application.");
	}
	// INIT SUCCESSFUL
	request.onsuccess = function() {
		window.db = request.result;
		window.db.onerror = function(event) {
			alert("IndexedDB Error: "+event.target.code);
		}
		renderPastLocations();
	}
	// UPDATE / SETUP NEEDED
	request.onupgradeneeded = function(event) {
		window.db = event.target.result;

		////////////////////////////////////////////////
		////////////////////////////////////////////////
		// INITIALIZE DATABASE

		var locObjectStore = window.db.createObjectStore("locations", {keyPath: "zip"})

		////////////////////////////////////////////////
		////////////////////////////////////////////////
	}
}

function IDB_addObject(store, object, callback) {

	// OPEN TRANSACTION
	var transaction = window.db.transaction([store], "readwrite");
	// ERROR HANDLER
	transaction.onerror = function(event) {
		alert("IDB_ADD Error:"+event.target.code);
	}

	// STORE DATA
	var objectStore = transaction.objectStore(store);
	var request  = objectStore.add(object);
	request.onsuccess = callback;

}

function IDB_getObject(store, keyvalue) {
 	var transaction = window.db.transaction([store]);
	var objectStore = transaction.objectStore(store);
	var request = objectStore.get(keyvalue);
	request.onerror = function(event) {
	  	alert("IndexedDB Error: Key not found.");
	};
	request.onsuccess = function(event) {
	 	return request.result;
	};
}

function IDB_removeObject(store, keyvalue, callback) {
	var request = window.db.transaction(store, "readwrite").objectStore(store).delete(keyvalue);
	request.onsuccess = callback;
}