function getIcon(weather_code) {

	var icons = new Array();
	icons[0] = "windy-rain";
	icons[1] = "windy-rain";
	icons[2] = "windy-rain";
	icons[3] = "tstorm";
	icons[4] = "tstorm";
	icons[5] = "snow";
	icons[6] = "snow";
	icons[7] = "snow";
	icons[8] = "showers";
	icons[9] = "showers";
	icons[10] = "rain";
	icons[11] = "windy-rain";
	icons[12] = "windy-rain";
	icons[13] = "flurries";
	icons[14] = "flurries";
	icons[15] = "snow";
	icons[16] = "snow";
	icons[17] = "hail";
	icons[18] = "snow";
	icons[19] = "fog";
	icons[20] = "fog";
	icons[21] = "fog";
	icons[22] = "fog";
	icons[23] = "windy";
	icons[24] = "windy";
	icons[25] = "freezing";
	icons[26] = "cloudy";
	icons[27] = "cloudy-night";
	icons[28] = "cloudy-day";
	icons[29] = "cloudy-night";
	icons[30] = "cloudy-day";
	icons[31] = "clear-night";
	icons[32] = "clear-day";
	icons[33] = "clear-night";
	icons[34] = "clear-day";
	icons[35] = "freezing";
	icons[36] = "clear-day";
	icons[37] = "tstorm";
	icons[38] = "tstorm";
	icons[39] = "tstorm";
	icons[40] = "rain";
	icons[41] = "snow";
	icons[42] = "snow";
	icons[43] = "snow";
	icons[44] = "cloudy";
	icons[45] = "tstorm";
	icons[46] = "snow";
	icons[47] = "tstorm";
	return icons[weather_code];
}

function showMenu() {
	$("#app").toggleClass("weather", false);
	$("#app").toggleClass("location", true);
}
function showWeather() {
	$("#app").toggleClass("weather", true);
	$("#app").toggleClass("location", false);
}

function getWeather(location) {
	// SEARCH FOR LOCATION
	$.simpleWeather({
	    zipcode: '',
	    woeid: '',
	    location: location,
	    unit: 'f',
	    success: function(weather) {
	      	
	      	////////////////////////////////////////////////////////
	      	////////////////////////////////////////////////////////
	      	// LOAD WEATHER REPORT

	      	// LOCATION INFORMATION
	      	var now = new Date();
	      	var clock = now.getHours()+":";
	      	if(now.getMinutes() < 10) {
	      		clock = clock+"0";
	      	}
	      	clock = clock+now.getMinutes();

	      	var cloc = weather.city;
	      	if(weather.region) {
	      		cloc = cloc+", "+weather.region;
	      	}
	      	else {
	      		if(weather.country) {
	      			cloc = cloc+", "+weather.country;
	      		}
	      	}
	      	$("#cloc").html(cloc + " ("+clock+")");

	      	// CREATE NEW LOCATION ENTRY
	      	var locationEntry = new Array();
	      	locationEntry.zip = weather.city+" "+weather.region+" "+weather.country;
	      	locationEntry.name = cloc;
	      	console.log(locationEntry);

	      	// REMOVE OLD ENTRY, & SAVE NEWEST OCCURRENCE
	      	IDB_removeObject("locations", locationEntry.zip);
	      	IDB_addObject("locations", locationEntry, function() { renderPastLocations(); });

	      	// CURRENT CONDITIONS
	      	$("#current-icon").html('<i class="icon-'+getIcon(weather.code)+'"></i>');
	      	$("#current-temp").html(weather.temp);
	      	$("#current-wind").html(weather.wind.speed+' '+weather.units.speed+' '+weather.wind.direction);
	      	$("#current-description").html(weather.currently);

	      	$("#forecast-icon-today").html('<i class="icon-'+getIcon(weather.todayCode)+'"></i>');
	      	$("#forecast-icon-tomorrow").html('<i class="icon-'+getIcon(weather.tomorrow.code)+'"></i>');

	      	$("#forecast-today-description").html(weather.forecast);
	      	$("#forecast-tomorrow-description").html(weather.tomorrow.forecast);

	      	$("#today-high").html(weather.high);
	      	$("#today-low").html(weather.low);
	      	$("#tom-high").html(weather.tomorrow.high);
	      	$("#tom-low").html(weather.tomorrow.low);

	      	////////////////////////////////////////////////////////
	      	////////////////////////////////////////////////////////
	      	$("#search-indicator").toggleClass("icon-pulse", false);
	      	showWeather();
	    },
	    error: function(error) {
	      	alert("Ooops, "+error);
	      	$("#search-indicator").toggleClass("icon-pulse", false);
	    }
	});
}

function renderPastLocations() {
	$(".locations-list").html("");
	var objectStore = db.transaction("locations").objectStore("locations");
	objectStore.openCursor().onsuccess = function(event) {
	  	var cursor = event.target.result;
	  	if (cursor) {
	    	$(".locations-list").append('<li data-location="'+cursor.value.zip+'">'+cursor.value.name+'</li>');
	    	cursor.continue();
	  	}
	  	else {
	  		$('.locations-list li').on("click", function() {
	  			$("#search-indicator").toggleClass("icon-pulse", true);
	  			var locIdent = $(this).attr("data-location");
	  			getWeather(locIdent);
	  		});
	  	}
	};
}

$(document).ready(function() {

	IDB_initDB("Weather", 1);

	$(".btn-search").on("click", function() {

		// BEGIN LOADING PULSE
		$("#search-indicator").toggleClass("icon-pulse", true);

		// GET SEARCH VALUE
		var searchInput = $("#locSearch");
		var searchValue = searchInput.val();
		if(searchValue) {
			getWeather(searchValue);
			searchInput.val('');	
		}
		else {
			$("#search-indicator").toggleClass("icon-pulse", false);
			alert("Please enter a location.");
		}

	});

	$(".btn-refresh").on("click", function() {
		showMenu();
	});

});
		