function getCountryByPN(pn) {
	var CountryList = {
		"AD":"Andorra",
		"AE":"United-Arab-Emirates",
		"AF":"Afghanistan",
		"AG":"Antigua-and-Barbuda",
		"AI":"Anguilla",
		"AL":"Albania",
		"AM":"Armenia",
		"AO":"Angola",
		"AR":"Argentina",
		"AT":"Austria",
		"AU":"Australia",
		"AZ":"Azerbaijan",
		"BB":"Barbados",
		"BD":"Bangladesh",
		"BE":"Belgium",
		"BF":"Burkina-faso",
		"BG":"Bulgaria",
		"BH":"Bahrain",
		"BI":"Burundi",
		"BJ":"Benin",
		"BL":"Palestine",
		"BM":"Bermuda-Is.",
		"BN":"Brunei",
		"BO":"Bolivia",
		"BR":"Brazil",
		"BS":"Bahamas",
		"BW":"Botswana",
		"BY":"Belarus",
		"BZ":"Belize",
		"CA":"Canada",
		"CF":"Central-African-Republic",
		"CG":"Congo",
		"CH":"Switzerland",
		"CK":"Cook-Is.",
		"CL":"Chile",
		"CM":"Cameroon",
		"CN":"China",
		"CO":"Colombia",
		"CR":"CostaRica",
		"CS":"Czech",
		"CU":"Cuba",
		"CY":"Cyprus",
		"CZ":"Czech-Republic",
		"DE":"Germany",
		"DJ":"Djibouti",
		"DK":"Denmark",
		"DO":"Dominica-Rep.",
		"DZ":"Algeria",
		"EC":"Ecuador",
		"EE":"Estonia",
		"EG":"Egypt",
		"ES":"Spain",
		"ET":"Ethiopia",
		"FI":"Finland",
		"FJ":"Fiji",
		"FR":"France",
		"GA":"Gabon",
		"GB":"United-Kiongdom",
		"GD":"Grenada",
		"GE":"Georgia",
		"GF":"French-Guiana",
		"GH":"Ghana",
		"GI":"Gibraltar",
		"GM":"Gambia",
		"GN":"Guinea",
		"GR":"Greece",
		"GT":"Guatemala",
		"GU":"Guam",
		"GY":"Guyana",
		"HK":"Hongkong",
		"HN":"Honduras",
		"HT":"Haiti",
		"HU":"Hungary",
		"ID":"Indonesia",
		"IE":"Ireland",
		"IL":"Israel",
		"IN":"India",
		"IQ":"Iraq",
		"IR":"Iran",
		"IS":"Iceland",
		"IT":"Italy",
		"JM":"Jamaica",
		"JO":"Jordan",
		"JP":"Japan",
		"KE":"Kenya",
		"KG":"Kyrgyzstan",
		"KH":"Kampuchea-(Cambodia)",
		"KP":"NorthKorea",
		"KR":"Korea",
		"KT":"Republic-of-Ivory-Coast",
		"KW":"Kuwait",
		"KZ":"Kazakstan",
		"LA":"Laos",
		"LB":"Lebanon",
		"LC":"St.Lucia",
		"LI":"Liechtenstein",
		"LK":"SriLanka",
		"LR":"Liberia",
		"LS":"Lesotho",
		"LT":"Lithuania",
		"LU":"Luxembourg",
		"LV":"Latvia",
		"LY":"Libya",
		"MA":"Morocco",
		"MC":"Monaco",
		"MD":"Moldova,-Republic-of",
		"MG":"Madagascar",
		"ML":"Mali",
		"MM":"Burma",
		"MN":"Mongolia",
		"MO":"Macao",
		"MS":"Montserrat-Is",
		"MT":"Malta",
		"MU":"Mauritius",
		"MV":"Maldives",
		"MW":"Malawi",
		"MX":"Mexico",
		"MY":"Malaysia",
		"MZ":"Mozambique",
		"NA":"Namibia",
		"NE":"Niger",
		"NG":"Nigeria",
		"NI":"Nicaragua",
		"NL":"Netherlands",
		"NO":"Norway",
		"NP":"Nepal",
		"NR":"Nauru",
		"NZ":"New-Zealand",
		"OM":"Oman",
		"PA":"Panama",
		"PE":"Peru",
		"PF":"French-Polynesia",
		"PG":"Papua-New-Cuinea",
		"PH":"Philippines",
		"PK":"Pakistan",
		"PL":"Poland",
		"PR":"Puerto-Rico",
		"PT":"Portugal",
		"PY":"Paraguay",
		"QA":"Qatar",
		"RO":"Romania",
		"RU":"Russia",
		"SA":"Saudi-Arabia",
		"SB":"Solomon-Is",
		"SC":"Seychelles",
		"SD":"Sudan",
		"SE":"Sweden",
		"SG":"Singapore",
		"SI":"Slovenia",
		"SK":"Slovakia",
		"SL":"Sierra-Leone",
		"SM":"San-Marino",
		"SN":"Senegal",
		"SO":"Somali",
		"SR":"Suriname",
		"ST":"Sao-Tome-and-Principe",
		"SV":"EI-Salvador",
		"SY":"Syria",
		"SZ":"Swaziland",
		"TD":"Chad",
		"TG":"Togo",
		"TH":"Thailand",
		"TJ":"Tajikstan",
		"TM":"Turkmenistan",
		"TN":"Tunisia",
		"TO":"Tonga",
		"TR":"Turkey",
		"TT":"Trinidad-and-Tobago",
		"TW":"Taiwan",
		"TZ":"Tanzania",
		"UA":"Ukraine",
		"UG":"Uganda",
		"US":"United-States",
		"UY":"Uruguay",
		"UZ":"Uzbekistan",
		"VC":"Saint-Vincent",
		"VE":"Venezuela",
		"VN":"Vietnam",
		"YE":"Yemen",
		"YU":"Yugoslavia",
		"ZA":"South-Africa",
		"ZM":"Zambia",
		"ZR":"Zaire",
		"ZW":"Zimbabwe"
	};

	return CountryList[pn];
}

function YWeatherSuggestionProvider() {
	this.cityNameInfoMap = {};

	this.init = function(options) {
		var lang = getLanguageName();
		this.url = "http://sugg.us.search.yahoo.net/gossip-gl-location/?appid=weather&output=sd1&callback=show&lc="+lang+"&command=";

		return;
	}

	function parseD(str) {
		var info = {};
		var items = str.split("&");

		for(var i = 0; i < items.length; i++) {
			var iter = items[i];
			var keyValue = iter.split("=");
			if(keyValue.length == 2) {
				var key = keyValue[0];
				var value = keyValue[1];
				info[key] = value;
			}
		}

		return info;
	}

	this.getCityInfo = function(city) {
		return this.cityNameInfoMap[city];
	}

	this.query = function(key, onDone) {
		if(!key) {
			onDone([]);

			return;
		}

		key = key.replace(/ /g, "");

		var me = this;
		var rInfo = {};
		var url = this.url + encodeURIComponent(key);

		rInfo.url = url;
		rInfo.headers = {};
		rInfo.method = "GET";
		rInfo.headers["Access-Control-Allow-Origin"] = "*";
		
		console.log(url);
		rInfo.onDone = function(result, xhr, respContent) {
			var arr = [];
			if(xhr.status === 200) {
				var json = respContent.substr(5);
				json = json.replace(")", "");

				console.log(respContent);
				try {
					var data = JSON.parse(json);
					var tips = data.r;

					me.cityNameInfoMap = {};
					for(var i = 0; i < tips.length; i++) {
						var iter = tips[i];
						var info = parseD(iter.d);
						if(!info.c) {
							info.c = getCountryByPN(info["s:iso"]);
						}

						var str = iter.k +", " +info.s + ", " + info.c;

						info["city"] = iter.k;
						info["fullname"] = str;
						info["name"] = info.pn ? info.pn : iter.k;

						if(info.c && info.s) {
							arr.push(str);
							me.cityNameInfoMap[str] = info;
						}
					}
				}
				catch(e) {
					success = false;
					console.log("Get Suggestion Failed: " + e.message);
				}
			}
			onDone(arr);
			
			return;
		}

		httpDoRequest(rInfo);

		return;
	}

	return;
}

function createYWeatherSuggestionProvider() {
	var provider = new YWeatherSuggestionProvider();

	provider.init();

	return provider;
}

var gSuggestionProvider = null;
function getSuggestionProvider() {

	if(!gSuggestionProvider) {
		gSuggestionProvider = createYWeatherSuggestionProvider();
	}

	return gSuggestionProvider;
}

var gWeatherInfoCache = {};

function getIconNameOfCondition(condition) {
	var arrIcons = ["wc-clear",
		"wc-cloudy",
		"wc-fair",
		"wc-foggy",
		"wc-freezing-rain",
		"wc-haze",
		"wc-light-snow-showers",
		"wc-mostly-clear",
		"wc-mostly-cloudy",
		"wc-partly-cloudy",
		"wc-rain-and-snow",
		"wc-scattered-showers",
		"wc-scattered-thunderstorms",
		"wc-showers",
		"wc-snow-and-sleet",
		"wc-snow",
		"wc-sunny",
		"wc-thunderstorms",
		"wc-windy"];

	if(arrIcons.indexOf(condition) >= 0) {
		return condition;
	}
	
	if(condition.indexOf("snow") >= 0) {
		return "wc-snow";	
	}
	else if(condition.indexOf("rain") >= 0) {
		return "wc-showers";
	}
	else {
		return "wc-partly-cloudy";
	}
}

function showWeatherOfCity(win, weatherInfo) {
	var i = 0;
	var src = null;
	var wcImage = null;
	var unit = localStorage.unitOfWeather ? localStorage.unitOfWeather : "C";
	var unitIsC = unit == "C";

	if(!weatherInfo) {
		return;
	}

	var cityName = weatherInfo.cityInfo.name;
	win.setValueOf("ui-label-location", cityName);
	win.setValueOf("ui-label-today-condition", weatherInfo.condition);
	win.setValueOf("ui-label-today-temp-hi", unitIsC ? weatherInfo.tempC.high : weatherInfo.tempF.high);
	win.setValueOf("ui-label-today-temp-lo", unitIsC ? weatherInfo.tempC.low : weatherInfo.tempF.low);
	win.setValueOf("ui-label-today-temp", unitIsC ? weatherInfo.tempC.value : weatherInfo.tempF.value);

	wcImage = win.findChildByName("ui-image-today-condition", true);
	src = wcImage.getImageSrcByType("option_image_0");
	src = src.replace("wc-none", getIconNameOfCondition(weatherInfo.conditionClass));
	wcImage.setImageSrc(src);
	
	var imageBg = win.findChildByName("ui-image-bg", true);
	var detailListView = win.findChildByName("ui-list-view-detail", true);
	
	var page = win.findChildByName("ui-page-content", true);
	src = page.getImageSrcByType(C_SHAPE_IMAGE_ALL);

	var bgFileName = "";
	var conditionClass = weatherInfo.conditionClass;
	if(conditionClass.indexOf("sunny") >= 0) {
		bgFileName = "wc-sunny-bg.jpg";
	}
	else if(conditionClass.indexOf("cloud") >= 0) {
		bgFileName = "wc-cloudy-bg.jpg";
	}
	else if(conditionClass.indexOf("thumder") >= 0) {
		bgFileName = "wc-thunder-bg.jpg";
	}
	else if(conditionClass.indexOf("shower") >= 0 
	|| conditionClass.indexOf("scatter") >= 0
	|| conditionClass.indexOf("rain") >= 0) {
		bgFileName = "wc-rain-bg.jpg";
	}
	else if(conditionClass.indexOf("fog") >= 0 
	|| conditionClass.indexOf("haze") >= 0) {
		bgFileName = "wc-fog-bg.jpg";

	}else {
		bgFileName = "wc-none-bg.jpg";
	}

	var arr = src.split("/");
	var fileName = arr.pop();
	src = src.replace(fileName, bgFileName);

	page.setImage(C_SHAPE_IMAGE_ALL, src);

	for(var name in weatherInfo.detail) {
		var valueObj = weatherInfo.detail[name];
		var li = detailListView.children[i];
		if(li) {
			var value = valueObj.value;
			if(valueObj.valueC && valueObj.valueF) {
				value = unitIsC ? valueObj.valueC : valueObj.valueF;
			}

			li.setValueOf("ui-label-name", name);
			li.setValueOf("ui-label-value", value);
		}
		i= i + 1;
	}
	var itemHeight = Math.floor(detailListView.h/detailListView.children.length);
	detailListView.setItemHeight(itemHeight);

	var forecastListView = win.findChildByName("ui-list-view-forecast", true);
	for(i = 0; i < weatherInfo.forecastItems.length; i++) {
		var valueObj = weatherInfo.forecastItems[i];
		var li = forecastListView.children[i];
		
		if(li) {
			var name = valueObj.name;
			var hi = unitIsC ? valueObj.hiC : valueObj.hiF;
			var lo = unitIsC ? valueObj.loC : valueObj.loF;
			var condition = valueObj.className;

			li.setValueOf("ui-label-name", name);
			li.setValueOf("ui-label-hi", hi);
			li.setValueOf("ui-label-lo", lo);
			wcImage = li.findChildByName("ui-image-condition", true);
			src = wcImage.getImageSrcByType("option_image_0");
			src = src.replace("wc-none", getIconNameOfCondition(condition));
			wcImage.setImageSrc(src);
		}
	}

	var itemHeight = Math.floor(forecastListView.h/forecastListView.children.length);
	forecastListView.setItemHeight(itemHeight);

	forecastListView.relayout();
	detailListView.relayout();

	return;
}

function removeCityInfoInBrowser(city) {
	if(!city || city === localStorage.localCity) {
		console.log("removeCityInfoInBrowser: return");

		return;
	}

	var cityInfos = {};
	if(localStorage.cityInfos) {
		cityInfos = JSON.parse(localStorage.cityInfos);
	}
	
	delete cityInfos[city];

	localStorage.cityInfos = JSON.stringify(cityInfos);

	return;

}

function removeAllCityInfoInBrowser() {
	if(localStorage.localCity) {
		var cityInfo = localStorage.cityInfos[localStorage.localCity];
	}
	
	delete localStorage.cityInfos;
	if(cityInfo) {
		saveCityInfoInBrowser(cityInfo);
	}

	return;
}

function saveCityInfoInBrowser(cityInfo) {
	var cityInfos = {};
	if(localStorage.cityInfos) {
		cityInfos = JSON.parse(localStorage.cityInfos);
	}
	
	cityInfos[cityInfo.name] = cityInfo;

	localStorage.cityInfos = JSON.stringify(cityInfos);

	return;
}

function getAllCityInfoFromBrowser() {
	var cityInfos = {};

	if(localStorage.cityInfos) {
		cityInfos = JSON.parse(localStorage.cityInfos);
	}

	return cityInfos;
}

function getCityInfoFromBrowser(city) {
	var cityInfos = getAllCityInfoFromBrowser();
	var cityInfo = cityInfos[city];

	return cityInfo;
}

function parseWeatherInfo(content) {
	var weatherInfo = {};
	var div = document.createElement("div");

	div.innerHTML = content;
	var leadBd = div.querySelector("#lead-bd");
	var cond = leadBd.querySelector(".cond");
	var f = leadBd.querySelector(".f");
	var c = leadBd.querySelector(".c");
	var hiLow = leadBd.querySelector(".hi-lo");
	var detail = div.querySelector(".yom-weather-details");
	var detailLi = detail.querySelectorAll("li");
	var forecast = div.querySelector(".forecast");
	var forecastLi = forecast.querySelectorAll("li");
	var sunrise = div.querySelector(".sunrise");
	var sunset = div.querySelector(".sunset");
	var wind = div.querySelector(".wind");
	var barometer = div.querySelector(".barometer");

	var windC = wind.querySelector(".second.c");
	var windF = wind.querySelector(".second.f");
	var barometerValue = barometer.querySelector(".second");
	var bgDiv = div.querySelector("#yog-bg");
	var bgImage = bgDiv.querySelector(".default.current");
	var bgImageSrc = bgImage.getAttribute("src");

	weatherInfo.detail = {};
	weatherInfo.bg = bgImageSrc;

	for(var i = 0; i < detailLi.length; i++) {
		var iter = detailLi[i];
		var name = iter.querySelector(".name").textContent;
		var value = iter.querySelector(".value");
		var valueF = iter.querySelector(".value.f");
		var valueC = iter.querySelector(".value.c");
		
		var itemValue = {};
		if(value) {
			itemValue.value = value.textContent;
		}

		if(valueC) {
			itemValue.valueC = valueC.textContent;
		}

		if(valueF) {
			itemValue.valueF = valueF.textContent;
		}

		weatherInfo.detail[name] = itemValue;
	}

	weatherInfo.forecastItems = [];
	for(var i = 0; i  < forecastLi.length; i++) {
		var forecastItem = {};
		var iter = forecastLi[i];
		var name = iter.querySelector(".name");
		var hiC = iter.querySelector(".hi-c");
		var hiF = iter.querySelector(".hi-f");
		var loC = iter.querySelector(".lo-c");
		var loF = iter.querySelector(".lo-f");

		var className = "";
		for(var k = 0; k < iter.classList.length; k++) {
			className = iter.classList[k];
			if(className.indexOf("wc-") >= 0) {
				className = className + ".png";
				className = className.replace("-d.png", "");
				className = className.replace("-n.png", "");
				className = className.replace(".png", "");
				
				forecastItem.className = className;
				break;
			}
		}

		forecastItem.name = name.textContent;
		forecastItem.hiC = hiC.textContent;
		forecastItem.hiF = hiF.textContent;
		forecastItem.loC = loC.textContent;
		forecastItem.loF = loF.textContent;

		weatherInfo.forecastItems.push(forecastItem);
	}

	for(var i = 0; i < cond.classList.length; i++) {
		var className = cond.classList[i];
		if(className.indexOf("wc-") >= 0 && className.indexOf("wc-icon") < 0) {
			className = className + ".png";
			className = className.replace("-d.png", "");
			className = className.replace("-n.png", "");
			className = className.replace(".png", "");

			weatherInfo.conditionClass = className;
			break;
		}
	}

	weatherInfo.condition = cond.textContent;
	weatherInfo.tempC = {};
	weatherInfo.tempF = {};
	var wind = {};
	wind.valueC = windC.textContent;
	wind.valueF = windF.textContent;
	
	var barometer = {};
	barometer.value = barometerValue.textContent;

	weatherInfo.detail["Wind"] = wind;
	weatherInfo.detail["Barometer"] = barometer;

	weatherInfo.tempF.value = f.textContent;
	weatherInfo.tempF.low  = hiLow.querySelector(".lo.f").textContent;
	weatherInfo.tempF.high = hiLow.querySelector(".hi.f").textContent;
	weatherInfo.tempC.value = c.textContent;
	weatherInfo.tempC.low  = hiLow.querySelector(".lo.c").textContent;
	weatherInfo.tempC.high = hiLow.querySelector(".hi.c").textContent;

	return weatherInfo;
}

function queryWeatherOfCity(win, cityInfo, onDone) {
	var cityName = cityInfo.fullname;
	var weatherInfo = gWeatherInfoCache[cityName];

	if(weatherInfo) {
		onDone(win, weatherInfo);

		return;
	}

	var rInfo = {};
	var country = cityInfo.c.replace(/ /g, "-");
	var s = cityInfo.s.replace(/ /g, "-");
	var ct = cityInfo.city.replace(/ /g, "-");

	var url = "http://weather.yahoo.com/" + encodeURIComponent(country)
		+ "/" + encodeURIComponent(s)
		+ "/" + encodeURIComponent(ct)
		+ "-" + cityInfo.woeid+"/";

	url = url.toLowerCase();
	url = url.replace(/ /g, "-");

	rInfo.url = url;
	rInfo.headers = {};
	rInfo.method = "GET";
	rInfo.headers["Access-Control-Allow-Origin"] = "*";
	
	var waitBox = win.findChildByName("ui-wait-box", true);
	waitBox.setVisible(true);
	waitBox.start();

	console.log(url);
	rInfo.onDone = function(result, xhr, respContent) {
		var weatherInfo = {};

		if(xhr.status === 200) {
			try {
				weatherInfo = parseWeatherInfo(respContent);
				weatherInfo.cityInfo = cityInfo;
				weatherInfo.cityName = cityName;
				gWeatherInfoCache[cityName] = weatherInfo;
				weatherInfo.updateTime = (new Date()).getTime();

				if(cityName == localStorage.localCity) {
					var str = JSON.stringify(weatherInfo);
					localStorage.localCityWeather = str;
				}

				onDone(win, weatherInfo);
			}
			catch(e) {
				console.log("parse weather info failed: " + respContent);
			}
		}
	
		waitBox.stop();
		waitBox.setVisible(false);

		return;
	}

	httpDoRequest(rInfo);

	return;
}

function onSelectCity(button) {
	var info = {};
	var win = button.getWindow();

	info.queryStr = "";
	info.suggestionProvider = getSuggestionProvider();
	
	var menu = win.findChildByName("ui-sliding-menu", true);
	menu.hideMenu();

	button.openWindow("win_suggestion", 
		function (city) {
			if(city) {
				var cityInfo = getSuggestionProvider().getCityInfo(city);
				saveCityInfoInBrowser(cityInfo);
				addCityToList(win, cityInfo.name);
				queryWeatherOfCity(win, cityInfo, showWeatherOfCity);
			}
			console.log("window closed.");
		}, false, info);

	return;
}

function onCityClicked(item) {
	var win = item.getWindow();
	var city = item.getValueOf("ui-label");
	var cityInfo = getCityInfoFromBrowser(city);

	if(cityInfo) {
		var menu = win.findChildByName("ui-sliding-menu", true);
		menu.hideMenu();

		queryWeatherOfCity(win, cityInfo, showWeatherOfCity);
	}
	else {
		onSelectCity(item);
	}

	return;
}

function clearBrowserCache() {
	gWeatherInfoCache = {};

	return;
}

function updateWeatherOfCity(win, cityInfo) {
	queryWeatherOfCity(win, cityInfo, function(win, weatherInfo) {
		console.log("updateWeatherOfCity:" + cityInfo.city);	
	});

	return;
}

function addCityToList(win, city) {
	var name = "ui-list-city-" + city;
	var list =  win.findChildByName("ui-list-view-menu", true);
	var templateItem = list.findChildByName("ui-list-item-default-city");
	var cityItem = list.findChildByName(name);

	if(!cityItem && city != localStorage.localCity) {
		var newItem = templateItem.clone();
		list.addShape(newItem, false, null, 2);
		newItem.setValueOf("ui-label", city);
		newItem.setName(name);
		newItem.setSlideToRemove(true);
	}

	list.relayout();

	return;
}

function showHistoryCities(win) {
	var cityInfos =	getAllCityInfoFromBrowser();
	var list =  win.findChildByName("ui-list-view-menu", true);
	var templateItem = list.findChildByName("ui-list-item-default-city");

	for(var city in cityInfos) {
		if(city != localStorage.localCity) {
			var newItem = templateItem.clone();
			list.addShape(newItem, false, null, 2);
			newItem.setValueOf("ui-label", city);
			newItem.setName("ui-list-city-" + city);
			newItem.setSlideToRemove(true);
		}

		var cityInfo = cityInfos[city];
		updateWeatherOfCity(win, cityInfo);
	}

	if(localStorage.localCity) {
		templateItem.setSlideToRemove(false);
		templateItem.setValueOf("ui-label", localStorage.localCity);
	}
	else {
		templateItem.setSlideToRemove(false);
		templateItem.setValueOf("ui-label", "Locating...");
	}

	if(localStorage.localCityWeather) {
		var weatherInfo = JSON.parse(localStorage.localCityWeather);
		showWeatherOfCity(win, weatherInfo);
	}

	list.relayout();

	return;
}

function getLocalCityInfo(win) {
	var rInfo = {};

	rInfo.headers = {};
	rInfo.method = "GET";
	rInfo.url = "http://ipinfo.io/json";
	rInfo.headers["Access-Control-Allow-Origin"] = "*";
	
	rInfo.onDone = function(result, xhr, respContent) {
		var city = null;
		var suggestionProvider = getSuggestionProvider();

		try {
			if(xhr.status === 200) {
				var json = JSON.parse(respContent);
				city = json.city;
				console.log("Local City: " + city);
			}	
		}catch(e) {
			console.log("Get Local City Failed.");
		}
	
		var li = win.findChildByName("ui-list-item-default-city", true);
		if(city) {
			var cityInfo = getCityInfoFromBrowser(city);	
			if(!cityInfo) {
				suggestionProvider.query(city, function(arr) {
					if(arr.length > 0) {
						for(var i = 0; i < arr.length; i++) {
							var iter = arr[i];
							cityInfo = suggestionProvider.getCityInfo(iter);
							if(cityInfo) {
								break;
							}
						}

						if(cityInfo) {
							saveCityInfoInBrowser(cityInfo);

							localStorage.localCity = cityInfo.name;
							li.setValueOf("ui-label", cityInfo.name);
							queryWeatherOfCity(win, cityInfo, showWeatherOfCity);
						}
					}
				});
			}
			else {
				localStorage.localCity = cityInfo.name;
				li.setValueOf("ui-label", cityInfo.name);
				queryWeatherOfCity(win, cityInfo, showWeatherOfCity);
			}
		}
		else {
			li.setValueOf("ui-label", "Add Location");
		}

		return;
	}

	httpDoRequest(rInfo);

	return;
}

function fakeUserAgentAsPC() {
	if(isTizen() && tizen.websetting) {
		var ua = "Mozilla/5.0 (Windows NT 6.1; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/31.0.1650.57";
		
		function successCallback() {
		     console.log("User Agent Set: " + ua);
		 }
	
		function errorCallBack() {
			console.log("Set User Agent Failed: " + ua);
		}
		tizen.websetting.setUserAgentString(ua, successCallback, errorCallBack);
	}

	return;
}

function onBeforeMainWinOpen(win) {
	gWeatherInfoCache = {};
	
	fakeUserAgentAsPC();

	var labelTime = win.findChildByName("ui-label-time", true);
	
	function updateTime() {
		var now = new Date();
		var minutes = now.getMinutes();

		if(minutes <= 9) {
			minutes = "0" + minutes;
		}

		var str = now.getHours() + ":" + minutes;
		labelTime.setText(str);
		win.postRedraw();

		setTimeout(updateTime, 1000);
	};

	updateTime();

	getLocalCityInfo(win);
	showHistoryCities(win);

	return;
}

function onBeforeSettingsWinOpen(win) {
	var c = win.findChildByName("ui-radiobox-c", true);
	var f = win.findChildByName("ui-radiobox-f", true);

	if(localStorage.unitOfWeather === "C") {
		c.setChecked();
	}
	else {
		f.setChecked();
	}

	return;
}
