var db = openDatabase("weather4", "1.0", "Oficial", 65535);
//
$(document).on("pageinit","#pConfig",function() {
	db.transaction (function (transaction) {
		var sql = "SELECT * FROM Configuracion";
		transaction.executeSql (sql, undefined, 
		function (transaction, result) {
			if (result.rows.length > 0) {
				var row = result.rows.item(result.rows.length - 1);
				var p_Pais = row.pais;
				var p_Ciudad = row.ciudad;
				var p_Idioma = row.id_idioma;
				var p_MedidaT = row.medidaTemperatura;
				var p_MedidaV = row.medidaViento;
				//
				$("#ciudadFrm").val(p_Ciudad);
				$("#paisFrm").val(p_Pais);
				//$('input[name=idiomaFrm]:checked').val(p_Idioma);
				console.log("idioma: " + p_Idioma);
				if (p_Idioma == 2) {
					$('#ingles').attr('checked',true).checkboxradio("refresh");;
					$('#español').attr('checked',false).checkboxradio("refresh");;
				} else {
					$('#ingles').attr('checked',false).checkboxradio("refresh");;
					$('#español').attr('checked',true).checkboxradio("refresh");;
				}

				if (p_MedidaV == 2) {
					$('#mph').attr('checked',true).checkboxradio("refresh");;
					$('#kmph').attr('checked',false).checkboxradio("refresh");;
				} else {
					$('#mph').attr('checked',false).checkboxradio("refresh");;
					$('#kmph').attr('checked',true).checkboxradio("refresh");;
				}

				if (p_MedidaT == 2) {
					$('#fahrenheit').attr('checked',true).checkboxradio("refresh");;
					$('#celsius').attr('checked',false).checkboxradio("refresh");;
				} else {
					$('#fahrenheit').attr('checked',false).checkboxradio("refresh");;
					$('#celsius').attr('checked',true).checkboxradio("refresh");;
				}

			}
		},
		
			window.location.replace('index.html#pConfig')
		);
		if (p_Ciudad == 'null')
			{
			window.location.replace('index.html#pConfig');
			}
	});	
});
//
$(document).on("pageinit","#pPrincipal",function() {
	crearDB();
	obtenerConfiguracion();
	//cargarad();
	//function cargarad()
	//{
	//	var ifr = "<iframe src='http://ad.leadboltmobile.net/show_app_wall?section_id=837190902'></iframe>"
	//	$("#ad").html(ifr);
	//}
	function obtenerConfiguracion() {
		var transaction;
		db.transaction (function (transaction) {
		    var sql = "SELECT * FROM Configuracion";
		    transaction.executeSql (sql, undefined, 
		    function (transaction, result) {
				if (result.rows.length == 0) { // Si esta vacio, mando a configuracion
					window.location.replace('index.html#pConfig');
				} else {
					var row = result.rows.item(result.rows.length - 1);
					var p_Pais = row.pais;
					var p_Ciudad = row.ciudad;
					var p_Idioma = row.id_idioma;
					var p_MedidaT = row.medidaTemperatura;
					var p_MedidaV = row.medidaViento;
					getPronostico(p_Ciudad, p_Pais, p_Idioma, p_MedidaT, p_MedidaV);
				}
		    },
		    function(transaction, result) {
				window.location.replace('index.html#pConfig');
			});
		});
	}

	// eliminarBase();
	//inicializarDB();
	function crearDB() {
		var tx;
		db.transaction (function (tx) {
			tx.executeSql ("CREATE TABLE IF NOT EXISTS Configuracion " +
				" (id_config INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, " +
				"ciudad VARCHAR(100) NOT NULL, " +
				"pais VARCHAR(100) NOT NULL, " +
				"medidaTemperatura INTEGER NOT NULL, " +
				"medidaViento INTEGER NOT NULL, " +
				"id_idioma INTEGER NOT NULL )");
		});
		// db.transaction (function (tx) {
		// 	tx.executeSql ("CREATE TABLE IF NOT EXISTS Traducciones " +
		// 		" (id_traducciones INTEGER NOT NULL PRIMARY KEY AUTOINCREMENT, " +
		// 		"id_idioma INTEGER NOT NULL, " +
		// 		"codigo VARCHAR(150) NOT NULL, " +
		// 		"traduccion VARCHAR(150) NOT NULL)");
		// });
	} //fin funcion crearDB
	/* Hardcode para pruebas */
	// getPronostico("New York", "", 1, 1, 1);

	///////////////////////////////////////////////////////////////////////
});

function getPronostico(p_Ciudad, p_Pais, p_Idioma, p_MedidaT, p_MedidaV) {
	var tradClima = codigo; //por defecto ingles, aca estan las traducciones para "Soleado", "Parcialmente nublado, etc"
	var trad = eng; //"Temperature", "Condition", "Humidity", "Wind"
	if (p_Idioma == 1) {
		/* Español */
		tradClima = codigoEsp;
		trad = esp; // "Temperatura", "Condicion", "Humedad", "Viento"
	}
	var urlAPI = "http://api.worldweatheronline.com/free/v1/weather.ashx?q="+p_Ciudad+","+p_Pais+"&num_of_days=5&key=v5c3398jzrrx4fq739xvrtej&callback=?";
	//var urlAPI = "http://foxsolutions.com.ar/pronostico.php?callback=?";
	//
	$.getJSON( urlAPI, { format: "json" }).done(function(data) {
		var datos = data;
		console.log(datos.data);
		//
		var precipMM = datos.data.current_condition[0].precipMM;

		var cloudcover = datos.data.current_condition[0].cloudcover;
		var pressure = datos.data.current_condition[0].pressure;

		var visibility = datos.data.current_condition[0].visibility;
		var weatherCode = datos.data.current_condition[0].weatherCode;

		var winddir16Point = datos.data.current_condition[0].winddir16Point;
		var winddirDegree = datos.data.current_condition[0].winddirDegree;
		var windspeedKmph = datos.data.current_condition[0].windspeedKmph;
		var windspeedMiles = datos.data.current_condition[0].windspeedMiles;
		//
		// Muestro datos
		if (p_MedidaT == 1) {
			txtTemp = datos.data.current_condition[0].temp_C + "°C";
			txtMaxMin = datos.data.weather[0].tempMinC + "°C / " + datos.data.weather[0].tempMaxC + "°C";
			txtMaxMinExtendido1 = datos.data.weather[1].tempMinC + "°C / " + datos.data.weather[1].tempMaxC + "°C";
			txtMaxMinExtendido2 = datos.data.weather[2].tempMinC + "°C / " + datos.data.weather[2].tempMaxC + "°C";
			txtMaxMinExtendido3 = datos.data.weather[3].tempMinC + "°C / " + datos.data.weather[3].tempMaxC + "°C";
			txtMaxMinExtendido4 = datos.data.weather[4].tempMinC + "°C / " + datos.data.weather[4].tempMaxC + "°C";
		} else {
			txtTemp = datos.data.current_condition[0].temp_F + "°F";
			txtMaxMin = datos.data.weather[0].tempMinF + "°F / " + datos.data.weather[0].tempMaxF + "°F";
			txtMaxMinExtendido1 = datos.data.weather[1].tempMinF + "°F / " + datos.data.weather[1].tempMaxF + "°F";
			txtMaxMinExtendido2 = datos.data.weather[2].tempMinF + "°F / " + datos.data.weather[2].tempMaxF + "°F";
			txtMaxMinExtendido3 = datos.data.weather[3].tempMinF + "°F / " + datos.data.weather[3].tempMaxF + "°F";
			txtMaxMinExtendido4 = datos.data.weather[4].tempMinF + "°F / " + datos.data.weather[4].tempMaxF + "°F";
		}
		$("#grados").html("<h1>" + txtTemp + "</h1>");
		$("#ciudad").html("<h2>"+datos.data.request[0].query+"</h2>");
		$("#maxMin").html("<h3>" + txtMaxMin + "</h3>");
		$("#condicionActual").html("<h3>"+tradClima[datos.data.current_condition[0].weatherCode]+"</h3>");
		$("#humedad").html("<h3>"+ trad[2] + " " + datos.data.current_condition[0].humidity + "% - </h3>");
		if (p_MedidaV == 1) {
			txtViento = datos.data.current_condition[0].windspeedKmph + " km/h " + datos.data.current_condition[0].winddir16Point;
		} else {
			txtViento = datos.data.current_condition[0].windspeedMiles + " Mph " + datos.data.current_condition[0].winddir16Point;
		}
		$("#Viento").html("<h3>" + trad[3] + " " + txtViento +"</h3>");
		var dias_semana = dias_semana_esp;
		var meses = meses_esp;
		if (p_Idioma == 2) { //ingles
			dias_semana = dias_semana_eng;
			meses = meses_eng;
		}
		var d = new Date();
		console.log(datos.data.weather[0].date);
		console.log(d.toString());
		$("#fecha").html("<h4>"+dias_semana[d.getDay()] + " " + d.getDate()+ " " + meses[d.getMonth()] + " " + d.getFullYear() + "</h4>");
		//Test fondo
		$('#pPrincipal').css('background-image', function(index) {
			return "url('img/"+cImg[datos.data.current_condition[0].weatherCode]+"_bk.jpg')";
		});
		//dia uno
		var dia1 = datos.data.weather[1].date;
		dia1 = new Date(dia1.replace(/-/g,"/"));
		$("#diaUno .dia").html(dias_semana[dia1.getDay()] + " " + dia1.getDate());
		$("#diaUno .maxMixExtendido").html(txtMaxMinExtendido1);
		$("#diaUno .condicion").html(tradClima[datos.data.weather[1].weatherCode]);
		$("#diaUno .imagen").html("<img src='img/"+cImg[datos.data.weather[1].weatherCode]+".png' >");
		//dia dos
		var dia2 = datos.data.weather[2].date;
		dia2 = new Date(dia2.replace(/-/g,"/"));
		$("#diaDos .dia").html(dias_semana[dia2.getDay()] + " " + dia2.getDate());
		$("#diaDos .maxMixExtendido").html(txtMaxMinExtendido2);
		$("#diaDos .condicion").html(tradClima[datos.data.weather[2].weatherCode]);
		$("#diaDos .imagen").html("<img src='img/"+cImg[datos.data.weather[2].weatherCode]+".png' >");
		//dia tres
		var dia3 = datos.data.weather[3].date;
		dia3 = new Date(dia3.replace(/-/g,"/"));
		$("#diaTres .dia").html(dias_semana[dia3.getDay()] + " " + dia3.getDate());
		$("#diaTres .maxMixExtendido").html(txtMaxMinExtendido3);
		$("#diaTres .condicion").html(tradClima[datos.data.weather[3].weatherCode]);
		$("#diaTres .imagen").html("<img src='img/"+cImg[datos.data.weather[3].weatherCode]+".png' >");
		//dia cuatro
		var dia4 = datos.data.weather[4].date;
		dia4 = new Date(dia4.replace(/-/g,"/"));
		$("#diaCuatro .dia").html(dias_semana[dia4.getDay()] + " " + dia4.getDate());
		$("#diaCuatro .maxMixExtendido").html(txtMaxMinExtendido4);
		$("#diaCuatro .condicion").html(tradClima[datos.data.weather[4].weatherCode]);
		$("#diaCuatro .imagen").html("<img src='img/"+cImg[datos.data.weather[4].weatherCode]+".png' >");
		//
	});
}



function guardarConfiguracion()
	{
		var p_Ciudad = $("#ciudadFrm").val();
		var p_Pais = $("#paisFrm").val();
		var p_Idioma = $('input[name=idiomaFrm]:checked').val();
		var p_MedidaT = $('input[name=temperaturaFrm]:checked').val();
		var p_MedidaV = $('input[name=vientoFrm]:checked').val();
		if ( p_Ciudad == '' || p_Idioma == '' || p_MedidaT == '' || p_MedidaV == '' )
		{
		    alert('Debe completar la ciudad.');
		}
		else
		{
			db.transaction (function (transaction) 
			{
		    	var sql = "INSERT INTO Configuracion (ciudad,pais,medidaTemperatura,medidaViento,id_idioma) VALUES (?,?,?,?,?)";
		    	transaction.executeSql (sql, [p_Ciudad, p_Pais, p_MedidaT, p_MedidaV, p_Idioma]);
			});
		}
		window.location.replace('index.html#pPrincipal');
		getPronostico(p_Ciudad, p_Pais, p_Idioma, p_MedidaT, p_MedidaV);

	}
