require.config({
	paths: {
        jQuery: "vendor/jquery/jquery-1.10.2.min",
		jQueryMobile: "vendor/jquery_mobile/jquery.mobile-1.3.2.min",
        Underscore: "vendor/underscore/underscore-min",
		Backbone: "vendor/backbone/backbone-min",
		eventie: "vendor/eventie/eventie",
		eventEmitter: "vendor/eventemitter/EventEmitter",
		ImagesLoaded: "vendor/imagesloaded/imagesloaded.pkgd.min"
    },
    shim: {
		jQuery: {
			exports: "$"
		},
		jQueryMobile: {
			exports: "$m",
			deps: ["jQuery"]
        },
		Underscore: {
			exports: "_"
		},
		Backbone: {
			exports: "Backbone",
			deps: ["Underscore", "jQuery"]
		},
		ImagesLoaded: {
			exports: "ImagesLoaded",
			deps: ["jQuery", "eventie", "eventEmitter"]
		}
    }
});

require([	"modules/app_registry",
			"jQuery",
			"jQueryMobile",
			"modules/pick_photo",],
				function(	AppRegistry,
							$,
							$m,
							pickPhoto) {
								
	$(document).ready(function(){
		$.mobile.page.prototype.options.domCache = false;

		pickPhoto.MozActivityPick();
	});
});
