define(["modules/app_registry",
		"jQuery",
		"jQueryMobile",
		"modules/canvas/font_height",
		"modules/canvas/pro_version_defense"],
			function(	AppRegistry,
						$,
						$m,
						FontHeight,
						ProVersionDefense) {
					
	return {

		'simple--top-left-mainfont' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				fsTemp = parseInt(canvas.height / 5.0),
				fhTemp = FontHeight("font-family: mainFont; font-size: " + fsTemp + "pt"),
				fsCity = parseInt(canvas.height / 10.0),
				fhCity = FontHeight("font-family: mainFont; font-size: " + fsCity + "pt");

			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsCity + "pt mainFont";
			ctx.fillText(AppRegistry.loc.city, 5, fhCity, canvas.width - 5);

			ctx.font = fsTemp + "pt mainFont";
			ctx.fillText(AppRegistry.weather.temp+"°C", 5, fhCity + fhTemp, canvas.width - 5);
		},
		
		'simple--top-left-mainfont-wbg' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				fsTemp = parseInt(canvas.height / 5.0),
				fhTemp = FontHeight("font-family: mainFont; font-size: " + fsTemp + "pt"),
				fsCity = parseInt(canvas.height / 10.0),
				fhCity = FontHeight("font-family: mainFont; font-size: " + fsCity + "pt");

			ctx.rect(0, 0, canvas.width, fhCity + fhTemp + 10);
			ctx.globalAlpha = 0.4;
			ctx.fillStyle = '#000000';
			ctx.fill();
			
			ctx.globalAlpha = 1.0;
			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsCity + "pt mainFont";
			ctx.fillText(AppRegistry.loc.city, 5, fhCity, canvas.width - 5);

			ctx.font = fsTemp + "pt mainFont";
			ctx.fillText(AppRegistry.weather.temp+"°C", 5, fhCity + fhTemp, canvas.width - 5);
		},
		
		'simple--bottom-left-mainfont' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				fsTemp = parseInt(canvas.height / 5.0),
				fsCity = parseInt(canvas.height / 10.0),
				fhCity = FontHeight("font-family: mainFont; font-size: " + fsCity + "pt");

			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsCity + "pt mainFont";
			ctx.fillText(AppRegistry.loc.city, 5, canvas.height - fhCity*0.3, canvas.width - 5);

			ctx.font = fsTemp + "pt mainFont";
			ctx.fillText(AppRegistry.weather.temp+"°C", 5, canvas.height - fhCity*0.3 - fhCity, canvas.width - 5);
		},
			
		'simple--bottom-left-mainfont-wbg' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				fsTemp = parseInt(canvas.height / 5.0),
				fhTemp = FontHeight("font-family: mainFont; font-size: " + fsTemp + "pt"),
				fsCity = parseInt(canvas.height / 10.0),
				fhCity = FontHeight("font-family: mainFont; font-size: " + fsCity + "pt");

			ctx.rect(0, canvas.height - (fhCity*0.3 + fhCity + fhTemp), canvas.width, canvas.height);
			ctx.globalAlpha = 0.4;
			ctx.fillStyle = '#000000';
			ctx.fill();

			ctx.globalAlpha = 1.0;
			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsCity + "pt mainFont";
			ctx.fillText(AppRegistry.loc.city, 5, canvas.height - fhCity*0.3, canvas.width - 5);

			ctx.font = fsTemp + "pt mainFont";
			ctx.fillText(AppRegistry.weather.temp+"°C", 5, canvas.height - fhCity*0.3 - fhCity, canvas.width - 5);
		},
	
		'simple--center-variousfont' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsWDesc = parseInt(canvas.height / 14.0),
				fhWDesc = FontHeight("font-family: handFont; font-size: " + fsWDesc + "pt"),
				fwWDesc = 0,
				fsCity = parseInt(canvas.height / 14.0),
				fwCity = 0,
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt");

			ctx.fillStyle = '#ffffff';
			ctx.font = fsWDesc + "pt handFont";
			
			fwWDesc = parseInt(ctx.measureText(AppRegistry.weather.desc).width);
			ctx.fillText(AppRegistry.weather.desc, canvasCenterX - parseInt(fwWDesc / 2), canvasCenterY);
			
			ctx.font = fsWDesc + "pt thinFont";
			
			ctx.strokeStyle = '#ffffff';
			ctx.lineWidth = 1;
			ctx.lineCap = 'round';
			ctx.beginPath();
			ctx.moveTo(canvasCenterX - parseInt(fwWDesc / 2) - 5, canvasCenterY + parseInt(fhWDesc / 2));
			ctx.lineTo(canvasCenterX + parseInt(fwWDesc / 2) + 5, canvasCenterY + parseInt(fhWDesc / 2));
			ctx.stroke();

			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), canvasCenterY + parseInt(fhWDesc / 2) + fhWDesc);

			if ( ! AppRegistry.config.proVersion) {
				ProVersionDefense(canvas, ctx, FontHeight);
			}
		},
			
		'simple--center-thinfont' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsWDesc = parseInt(canvas.height / 14.0),
				fhWDesc = FontHeight("font-family: thinFont; font-size: " + fsWDesc + "pt"),
				fwWDesc = 0,
				fsCity = parseInt(canvas.height / 14.0),
				fwCity = 0,
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt");

			ctx.fillStyle = '#ffffff';
			ctx.font = fsWDesc + "pt thinFont";
			
			fwWDesc = parseInt(ctx.measureText(AppRegistry.weather.desc).width);
			ctx.fillText(AppRegistry.weather.desc, canvasCenterX - parseInt(fwWDesc / 2), canvasCenterY);
			
			ctx.strokeStyle = '#ffffff';
			ctx.lineWidth = 1;
			ctx.lineCap = 'round';
			ctx.beginPath();
			ctx.moveTo(canvasCenterX - parseInt(fwWDesc / 2) - 5, canvasCenterY + parseInt(fhWDesc / 2));
			ctx.lineTo(canvasCenterX + parseInt(fwWDesc / 2) + 5, canvasCenterY + parseInt(fhWDesc / 2));
			ctx.stroke();

			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), canvasCenterY + parseInt(fhWDesc / 2) + fhWDesc);
			
			if ( ! AppRegistry.config.proVersion) {
				ProVersionDefense(canvas, ctx, FontHeight);
			}
		},
			
		'simple--center-thinfont-wtemp' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsWDesc = parseInt(canvas.height / 14.0),
				fhWDesc = FontHeight("font-family: thinFont; font-size: " + fsWDesc + "pt"),
				fwWDesc = 0,
				fsCity = parseInt(canvas.height / 14.0),
				fwCity = 0,
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt");

			ctx.fillStyle = '#ffffff';
			ctx.font = fsWDesc + "pt thinFont";
			
			fwWDesc = parseInt(ctx.measureText(AppRegistry.weather.desc + ', ' + AppRegistry.weather.temp + "°C").width);
			ctx.fillText(AppRegistry.weather.desc + ', ' + AppRegistry.weather.temp + "°C", canvasCenterX - parseInt(fwWDesc / 2), canvasCenterY);
			
			ctx.strokeStyle = '#ffffff';
			ctx.lineWidth = 1;
			ctx.lineCap = 'round';
			ctx.beginPath();
			ctx.moveTo(canvasCenterX - parseInt(fwWDesc / 2) - 5, canvasCenterY + parseInt(fhWDesc / 2));
			ctx.lineTo(canvasCenterX + parseInt(fwWDesc / 2) + 5, canvasCenterY + parseInt(fhWDesc / 2));
			ctx.stroke();

			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), canvasCenterY + parseInt(fhWDesc / 2) + fhWDesc);
			
			if ( ! AppRegistry.config.proVersion) {
				ProVersionDefense(canvas, ctx, FontHeight);
			}
		},
			
		'simple--center-temp' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				fsTemp = parseInt(canvas.height / 3.0),
				fhTemp = FontHeight("font-family: mainFont; font-size: " + fsTemp + "pt"),
				fwTemp = 0;
		
			ctx.globalAlpha = 0.7;
			ctx.fillStyle = '#ffffff';
			ctx.font = fsTemp + "pt mainFont";
			fwTemp = parseInt(ctx.measureText(AppRegistry.weather.temp + '°C').width);
			ctx.fillText(AppRegistry.weather.temp + '°C', canvasCenterX - parseInt(fwTemp / 2), canvas.height / 2 + fhTemp / 2);
			ctx.globalAlpha = 1.0;
		},
			
		'simple--bottom-temp' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				fsTemp = parseInt(canvas.height / 3.0),
				fwTemp = 0;
		
			ctx.globalAlpha = 0.5;
			ctx.fillStyle = '#ffffff';
			ctx.font = fsTemp + "pt mainFont";
			fwTemp = parseInt(ctx.measureText(AppRegistry.weather.temp + '°C').width);
			ctx.fillText(AppRegistry.weather.temp + '°C', canvasCenterX - parseInt(fwTemp / 2), canvas.height);
			ctx.globalAlpha = 1.0;
		}
	
	};
});