define(["modules/app_registry",
		"jQuery",
		"jQueryMobile"],
			function(	AppRegistry,
						$,
						$m) {
	
	var savePhoto = function(blob, photo_name) {
		var sdcard = navigator.getDeviceStorage("pictures");
		var request = sdcard.addNamed(blob, photo_name);
		request.onsuccess = function () {
			alert("The photo is in your Gallery now! (" + photo_name + ")");
		};
		request.onerror = function () {
			alert('Unable to write the file: ' + this.error.name);
		};
	};
	
	return {

		share : function(selector) {
			$("#picked-photo").get(0).toBlob(function (blob) {	
				var sdcard = navigator.getDeviceStorage("pictures");
				var photo_name = "WeatherCam_" + Math.round(new Date().getTime() / 1000) + ".png";
				var request = sdcard.delete(photo_name);
				request.onsuccess = function () {
					savePhoto(blob, photo_name);
				};
				request.onerror = function () {
					savePhoto(blob, photo_name);
				};
			});
		}
	
	};

});