define(["modules/app_registry",
		"jQuery",
		"jQueryMobile",
		"modules/router",
		"modules/options/wsimple",
		"modules/misc/geocode",
		"modules/misc/geocode_ip",
		"modules/misc/weather"],
			function(
				AppRegistry,
				$,
				$m,
				Router,
				wSimple,
				GeoCodeApi,
				GeoCodeIpApi,
				WeatherApi) {
					
	var pickImage = function() {
		var pickImg = new MozActivity({
			name: "pick",
			data: {
				type: ["image/jpg", "image/jpeg", "img/png"]
			}
		});
		pickImg.onsuccess = function () { 
			AppRegistry.image.selectedImage = window.URL.createObjectURL(this.result.blob);
			$("#edit-header").show();
			$("#select-mode").removeClass("hidden");
			wSimple.render();

			Router.routing();	
		};							
		pickImg.onerror = function () { 
			alert("Please select or shoot a photo");
			pickImage();
		};
	};
					
	return {
		
		MozActivityPick: function() {
			$('#logo, #modeMenu').show();
			
			$('#modeMenuAccurate').click(function() {
				setTimeout(function() {
					if ("geolocation" in navigator) {
						$("body").addClass('ui-disabled-override');$.mobile.showPageLoadingMsg("d", "Getting weather infos...", false);
						navigator.geolocation.getCurrentPosition(
							function(position) {
								AppRegistry.geo.lat = position.coords.latitude;
								AppRegistry.geo.lng = position.coords.longitude;

								AppRegistry.loc = GeoCodeApi(position.coords.latitude, position.coords.longitude);
								AppRegistry.weather = WeatherApi(position.coords.latitude, position.coords.longitude);

								$("body").removeClass('ui-disabled-override');$m.hidePageLoadingMsg();

								pickImage();
							},
							function(error) {
								if (typeof error.message !== "undefined") {
									if (error.code === 1) {
										alert("Next time you should Allow Geolocation to use WeatherCam properly!");
										pickImage();
									} else {
										alert("Error while retrieving current position. Error code: " + error.code + ", Message: " + error.message);
										$.mobile.changePage("#pick-photo-page");
									}
								} else {
									alert("Next time you should Allow Geolocation to use WeatherCam properly!");
									pickImage();
								}

								$("body").removeClass('ui-disabled-override');$m.hidePageLoadingMsg();
							},
							{
								enableHighAccuracy: false,
								timeout: 180000,
								maximumAge: 3600000
							}
						);
					} else {
						alert("Can't use Geolocation!");
					}
				}, 500);
			});
		
			$('#modeMenuSemiaccurate').click(function() {
				setTimeout(function() {
					$("body").addClass('ui-disabled-override');$.mobile.showPageLoadingMsg("d", "Getting weather infos...", false);
					AppRegistry.geo = GeoCodeIpApi();					
					AppRegistry.loc = GeoCodeApi(AppRegistry.geo.lat, AppRegistry.geo.lng);
					AppRegistry.weather = WeatherApi(AppRegistry.geo.lat, AppRegistry.geo.lng);
					
					pickImage();
					
					$("body").removeClass('ui-disabled-override');$m.hidePageLoadingMsg();
				}, 500);
			});

			$("#home-button").click(function() {
				$("#edit-header").hide();
				$("#slider-holder").hide();
				$("#content").html("");
				$("#select-mode ul > li").removeClass("ui-btn-active-override");
				$("#panel-simple").addClass("ui-btn-active-override");
				$("#edit-header > h1").text("← 1 →");
				AppRegistry.reset();
			});
		}

	};
});