define([], function() {
    var appRegistry = {};
	
	appRegistry.reset = function() {
		appRegistry.image.selectedImage = null;
		appRegistry.image.original.width = null;
		appRegistry.image.original.height = null;
		appRegistry.resetPatterns();
	};

	appRegistry.resetPatterns = function(type) {
		switch (type) {
			case 'speaking':
				appRegistry.pattern.selected = 'speaking--magnificent';
				break;
			case 'iconic':
				appRegistry.pattern.selected = 'iconic--center-thinFont';
				break;
			case 'simple':
			default:
				appRegistry.pattern.selected = 'simple--center-temp';
		}
	};

	appRegistry.config = {
		proVersion : true
	};

	appRegistry.geo = {
		lat : '0',
		lng : '0'
	};

	appRegistry.loc = {
		country : 'Country',
		city : 'City'
	};

	appRegistry.weather = {
		temp : '00',
		humidity : '00',
		desc : 'Sunny',
		descLong : 'Sunny',
		icon : null,
		pic : 'img/weather/Sunny.png'
	};

	appRegistry.image = {
		selectedImage : null,
		original : {
			width: null,
			height: null
		}
	};
	
    appRegistry.pattern = {
		selected : 'simple--center-temp',
		patterns : {
			simple : [
				'simple--center-temp',
				'simple--bottom-temp',
				'simple--top-left-mainfont',
				'simple--top-left-mainfont-wbg',
				'simple--bottom-left-mainfont',
				'simple--bottom-left-mainfont-wbg',
				'simple--center-variousfont',
				'simple--center-thinfont',
				'simple--center-thinfont-wtemp'
			],
			iconic : [
				'iconic--center-thinFont',
				'iconic--center-bottom-cheersFont',
				'iconic--bottom-thinFont',
				'iconic--bottom-cheersFont',
				'iconic--center-variousFont-wtemp',
				'iconic--bottom-variousFont-wtemp',
				'iconic--top-bottom-variousFont-wtemp',
				'iconic--top-bottom-variousFont',
				'iconic--top-bottom-variousFont-wtemp2'
			],
			speaking : [
				'speaking--magnificent',
				'speaking--incredible',
				'speaking--greetings-from',
				'speaking--good-morning',
				'speaking--cheers',
				'speaking--spring-is-here',
				'speaking--summer-is-here',
				'speaking--autumn-is-here',
				'speaking--winter-is-here',
				'speaking--rock-the-city'
			]
		}
	};
	
    return appRegistry;
});