define(["modules/app_registry",
		"jQuery",
		"jQueryMobile",
		"modules/canvas/font_height",
		"modules/canvas/pro_version_defense"],
			function(	AppRegistry,
						$,
						$m,
						FontHeight,
						ProVersionDefense) {
					
	return {
			
		'iconic--center-thinFont' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsCity = parseInt(canvas.height / 14.0),
				fwCity = 0,
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt");

			var imgObj = new Image();
			imgObj.onload = function() {
				var imgWidth = canvas.width / 4;
				if (canvas.height < canvas.width) {
					imgWidth = canvas.height / 4;
				}
				ctx.drawImage(imgObj, canvasCenterX - imgWidth / 2, canvasCenterY + parseInt(fhCity / 2) - imgWidth, imgWidth, imgWidth);
				
				if ( ! AppRegistry.config.proVersion) {
					ProVersionDefense(canvas, ctx, FontHeight);
				}
			};
			imgObj.src = AppRegistry.weather.pic;

			ctx.fillStyle = '#ffffff';
			ctx.font = fsCity + "pt thinFont";

			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), canvasCenterY + parseInt(fhCity / 2) + fhCity);
		},
			
		'iconic--center-bottom-cheersFont' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsCity = parseInt(canvas.height / 18.0),
				fwCity = 0,
				fhCity = FontHeight("font-family: cheersFont; font-size: " + fsCity + "pt");

			var imgObj = new Image();
			imgObj.onload = function() {
				var imgWidth = canvas.width / 4;
				if (canvas.height < canvas.width) {
					imgWidth = canvas.height / 4;
				}
				ctx.drawImage(imgObj, canvasCenterX - imgWidth / 2, canvasCenterY + parseInt(fhCity / 2) - imgWidth, imgWidth, imgWidth);
				if ( ! AppRegistry.config.proVersion) {
					ProVersionDefense(canvas, ctx, FontHeight);
				}
			};
			imgObj.src = AppRegistry.weather.pic;

			ctx.fillStyle = '#ffffff';
			ctx.font = fsCity + "pt cheersFont";

			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), canvas.height - fhCity);
		},
			
		'iconic--bottom-thinFont' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsCity = parseInt(canvas.height / 14.0),
				fwCity = 0,
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt");

			var imgObj = new Image();
			imgObj.onload = function() {
				var imgWidth = canvas.width / 4;
				if (canvas.height < canvas.width) {
					imgWidth = canvas.height / 4;
				}
				ctx.drawImage(imgObj, canvasCenterX - imgWidth / 2, canvas.height - fhCity * 2 - imgWidth, imgWidth, imgWidth);
				if ( ! AppRegistry.config.proVersion) {
					ProVersionDefense(canvas, ctx, FontHeight);
				}
			};
			imgObj.src = AppRegistry.weather.pic;

			ctx.fillStyle = '#ffffff';
			ctx.font = fsCity + "pt thinFont";

			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), canvas.height - fhCity);
		},
			
		'iconic--bottom-cheersFont' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsCity = parseInt(canvas.height / 18.0),
				fwCity = 0,
				fhCity = FontHeight("font-family: cheersFont; font-size: " + fsCity + "pt");

			var imgObj = new Image();
			imgObj.onload = function() {
				var imgWidth = canvas.width / 4;
				if (canvas.height < canvas.width) {
					imgWidth = canvas.height / 4;
				}
				ctx.drawImage(imgObj, canvasCenterX - imgWidth / 2, canvas.height - fhCity * 2 - imgWidth, imgWidth, imgWidth);
				if ( ! AppRegistry.config.proVersion) {
					ProVersionDefense(canvas, ctx, FontHeight);
				}
			};
			imgObj.src = AppRegistry.weather.pic;

			ctx.fillStyle = '#ffffff';
			ctx.font = fsCity + "pt cheersFont";

			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), canvas.height - fhCity);
		},
			
		'iconic--center-variousFont-wtemp' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsTemp = parseInt(canvas.height / 14.0),
				fhTemp = FontHeight("font-family: cheersFont; font-size: " + fsTemp + "pt"),
				fwTemp = 0,
				fsCity = parseInt(canvas.height / 14.0),
				fwCity = 0,
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt");

			var imgObj = new Image();
			imgObj.onload = function() {
				var imgWidth = canvas.width / 4;
				if (canvas.height < canvas.width) {
					imgWidth = canvas.height / 4;
				}
				ctx.drawImage(imgObj, canvasCenterX - imgWidth / 2, canvasCenterY + parseInt(fhCity / 2) - imgWidth, imgWidth, imgWidth);
				if ( ! AppRegistry.config.proVersion) {
					ProVersionDefense(canvas, ctx, FontHeight);
				}
			};
			imgObj.src = AppRegistry.weather.pic;

			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsCity + "pt thinFont";
			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), canvasCenterY + parseInt(fhCity / 2) + fhCity);
			
			ctx.font = fsTemp + "pt cheersFont";
			fwTemp = parseInt(ctx.measureText(AppRegistry.weather.temp + '°C').width);
			ctx.fillText(AppRegistry.weather.temp + '°C', canvasCenterX - parseInt(fwTemp / 2), canvasCenterY + fhCity + fhTemp + parseInt(fhCity / 2));
		},
			
		'iconic--bottom-variousFont-wtemp' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsTemp = parseInt(canvas.height / 14.0),
				fhTemp = FontHeight("font-family: cheersFont; font-size: " + fsTemp + "pt"),
				fwTemp = 0,
				fsCity = parseInt(canvas.height / 14.0),
				fwCity = 0,
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt");

			var imgObj = new Image();
			imgObj.onload = function() {
				var imgWidth = canvas.width / 4;
				if (canvas.height < canvas.width) {
					imgWidth = canvas.height / 4;
				}
				ctx.drawImage(imgObj, canvasCenterX - imgWidth / 2, canvas.height - imgWidth - fhCity - fhTemp, imgWidth, imgWidth);
				if ( ! AppRegistry.config.proVersion) {
					ProVersionDefense(canvas, ctx, FontHeight);
				}
			};
			imgObj.src = AppRegistry.weather.pic;

			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsCity + "pt thinFont";
			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), canvas.height - fhCity / 2);
			
			ctx.font = fsTemp + "pt cheersFont";
			fwTemp = parseInt(ctx.measureText(AppRegistry.weather.temp + '°C').width);
			ctx.fillText(AppRegistry.weather.temp + '°C', canvasCenterX - parseInt(fwTemp / 2), canvas.height - fhCity / 2 - fhTemp);
		},
			
		'iconic--top-bottom-variousFont-wtemp' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsTemp = parseInt(canvas.height / 14.0),
				fhTemp = FontHeight("font-family: cheersFont; font-size: " + fsTemp + "pt"),
				fwTemp = 0,
				fsCity = parseInt(canvas.height / 14.0),
				fwCity = 0,
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt");

			var imgObj = new Image();
			imgObj.onload = function() {
				var imgWidth = canvas.width / 4;
				if (canvas.height < canvas.width) {
					imgWidth = canvas.height / 4;
				}
				ctx.drawImage(imgObj, canvasCenterX - imgWidth / 2, canvas.height - imgWidth - fhTemp, imgWidth, imgWidth);
				if ( ! AppRegistry.config.proVersion) {
					ProVersionDefense(canvas, ctx, FontHeight);
				}
			};
			imgObj.src = AppRegistry.weather.pic;

			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsCity + "pt thinFont";
			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), fhCity);
			
			ctx.font = fsTemp + "pt cheersFont";
			fwTemp = parseInt(ctx.measureText(AppRegistry.weather.temp + '°C').width);
			ctx.fillText(AppRegistry.weather.temp + '°C', canvasCenterX - parseInt(fwTemp / 2), canvas.height - fhTemp / 2);
		},
			
		'iconic--top-bottom-variousFont' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsTemp = parseInt(canvas.height / 14.0),
				fhTemp = FontHeight("font-family: handFont; font-size: " + fsTemp + "pt"),
				fwTemp = 0,
				fsCity = parseInt(canvas.height / 14.0),
				fwCity = 0,
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt");

			var imgObj = new Image();
			imgObj.onload = function() {
				var imgWidth = canvas.width / 4;
				if (canvas.height < canvas.width) {
					imgWidth = canvas.height / 4;
				}
				ctx.drawImage(imgObj, canvasCenterX - imgWidth / 2, canvas.height - imgWidth - fhTemp, imgWidth, imgWidth);
				if ( ! AppRegistry.config.proVersion) {
					ProVersionDefense(canvas, ctx, FontHeight);
				}
			};
			imgObj.src = AppRegistry.weather.pic;

			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsCity + "pt thinFont";
			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), fhCity);
			
			ctx.font = fsTemp + "pt handFont";
			fwTemp = parseInt(ctx.measureText(AppRegistry.weather.desc).width);
			ctx.fillText(AppRegistry.weather.desc, canvasCenterX - parseInt(fwTemp / 2), canvas.height - fhTemp / 2);
		},
			
		'iconic--top-bottom-variousFont-wtemp2' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsTemp = parseInt(canvas.height / 14.0),
				fhTemp = FontHeight("font-family: handFont; font-size: " + fsTemp + "pt"),
				fwTemp = 0,
				fsTemp2 = parseInt(canvas.height / 14.0),
				fhTemp2 = FontHeight("font-family: cheersFont; font-size: " + fsTemp2 + "pt"),
				fwTemp2 = 0,
				fsCity = parseInt(canvas.height / 14.0),
				fwCity = 0,
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt");

			var imgObj = new Image();
			imgObj.onload = function() {
				var imgWidth = canvas.width / 4;
				if (canvas.height < canvas.width) {
					imgWidth = canvas.height / 4;
				}
				ctx.drawImage(imgObj, canvasCenterX - imgWidth / 2, canvas.height - imgWidth - fhTemp, imgWidth, imgWidth);
				if ( ! AppRegistry.config.proVersion) {
					ProVersionDefense(canvas, ctx, FontHeight);
				}
			};
			imgObj.src = AppRegistry.weather.pic;

			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsCity + "pt thinFont";
			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), fhCity);
			
			ctx.font = fsTemp + "pt cheersFont";
			fwTemp2 = parseInt(ctx.measureText(AppRegistry.weather.temp + '°C').width);
			ctx.fillText(AppRegistry.weather.temp + '°C', canvasCenterX - parseInt(fwTemp2 / 2), fhCity + fhTemp2);
			
			ctx.font = fsTemp + "pt handFont";
			fwTemp = parseInt(ctx.measureText(AppRegistry.weather.desc).width);
			ctx.fillText(AppRegistry.weather.desc, canvasCenterX - parseInt(fwTemp / 2), canvas.height - fhTemp / 2);
		}
	
	};
});