define(["modules/app_registry",
		"jQuery",
		"jQueryMobile",
		"modules/canvas/font_height",
		"modules/canvas/pro_version_defense"],
			function(	AppRegistry,
						$,
						$m,
						FontHeight,
						ProVersionDefense) {
					
	return {
			
		'speaking--magnificent' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsTop = parseInt(canvas.height / 10.0),
				fhTop = FontHeight("font-family: cheersFont; font-size: " + fsTop + "pt"),
				fwTop = 0,
				fsCity = parseInt(canvas.height / 16.0),
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt"),
				fwCity = 0,
				fsCountry = parseInt(canvas.height / 16.0),
				fhCountry = FontHeight("font-family: thinFont; font-size: " + fsCountry + "pt"),
				fwCountry = 0;

			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsTop + "pt cheersFont";
			fwTop = parseInt(ctx.measureText("Magnificent").width);
			ctx.fillText("Magnificent", canvasCenterX - parseInt(fwTop / 2), fhTop);
			
			ctx.font = fsCity + "pt thinFont";
			ctx.fillText(AppRegistry.loc.city + "|" + AppRegistry.weather.temp + "°C", 5, canvas.height - fhCity - fhCity / 3, canvas.width - 5);
			
			ctx.font = fsCountry + "pt thinFont";
			ctx.fillText(AppRegistry.loc.country, 5, canvas.height - fhCity / 3, canvas.width - 5);
			
			if ( ! AppRegistry.config.proVersion) {
				ProVersionDefense(canvas, ctx, FontHeight);
			}
		},
			
		'speaking--incredible' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsTop = parseInt(canvas.height / 10.0),
				fhTop = FontHeight("font-family: handFont; font-size: " + fsTop + "pt"),
				fwTop = 0,
				fsCity = parseInt(canvas.height / 16.0),
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt"),
				fwCity = 0,
				fsCountry = parseInt(canvas.height / 16.0),
				fhCountry = FontHeight("font-family: thinFont; font-size: " + fsCountry + "pt"),
				fwCountry = 0;

			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsTop + "pt handFont";
			fwTop = parseInt(ctx.measureText("Incredible").width);
			ctx.fillText("Incredible", canvasCenterX - parseInt(fwTop / 2), fhTop);
			
			ctx.font = fsCity + "pt thinFont";
			ctx.fillText(AppRegistry.loc.city + "|" + AppRegistry.weather.temp + "°C", 5, canvas.height - fhCity - fhCity / 3, canvas.width - 5);
			
			ctx.font = fsCountry + "pt thinFont";
			ctx.fillText(AppRegistry.loc.country, 5, canvas.height - fhCity / 3, canvas.width - 5);
			
			if ( ! AppRegistry.config.proVersion) {
				ProVersionDefense(canvas, ctx, FontHeight);
			}
		},
			
		'speaking--spring-is-here' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsTop1 = parseInt(canvas.height / 14.0),
				fhTop1 = FontHeight("font-family: mainFont; font-size: " + fsTop1 + "pt"),
				fwTop1 = 0,
				fsTop2 = parseInt(canvas.height / 10.0),
				fhTop2 = FontHeight("font-family: cheersFont; font-size: " + fsTop2 + "pt"),
				fwTop2 = 0,
				fsTop3 = parseInt(canvas.height / 18.0),
				fhTop3 = FontHeight("font-family: handFont; font-size: " + fsTop3 + "pt"),
				fwTop3 = 0,
				fsBottom = parseInt(canvas.height / 14.0),
				fhBottom = FontHeight("font-family: handFont; font-size: " + fsTop3 + "pt"),
				fwBottom = 0;

			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsTop1 + "pt mainFont";
			fwTop1 = parseInt(ctx.measureText('— ' + AppRegistry.weather.temp + '°C —').width);
			ctx.fillText('— ' + AppRegistry.weather.temp + '°C —', canvasCenterX - parseInt(fwTop1 / 2), fhTop1*1.5);
			
			ctx.font = fsTop2 + "pt cheersFont";
			fwTop2 = parseInt(ctx.measureText('SPRING').width);
			ctx.fillText('SPRING', canvasCenterX - parseInt(fwTop2 / 2), fhTop1*1.5 + fhTop2);
			
			ctx.font = fsTop3 + "pt handFont";
			fwTop3 = parseInt(ctx.measureText('is here').width);
			ctx.fillText('is here', canvasCenterX - parseInt(fwTop3 / 2), fhTop1*1.5 + fhTop2 + fhTop3);
			
			ctx.font = fsBottom + "pt handFont";
			fwBottom = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwBottom / 2), canvas.height - fhBottom);
			
			if ( ! AppRegistry.config.proVersion) {
				ProVersionDefense(canvas, ctx, FontHeight);
			}
		},
			
		'speaking--summer-is-here' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsTop1 = parseInt(canvas.height / 14.0),
				fhTop1 = FontHeight("font-family: mainFont; font-size: " + fsTop1 + "pt"),
				fwTop1 = 0,
				fsTop2 = parseInt(canvas.height / 10.0),
				fhTop2 = FontHeight("font-family: cheersFont; font-size: " + fsTop2 + "pt"),
				fwTop2 = 0,
				fsTop3 = parseInt(canvas.height / 18.0),
				fhTop3 = FontHeight("font-family: handFont; font-size: " + fsTop3 + "pt"),
				fwTop3 = 0,
				fsBottom = parseInt(canvas.height / 14.0),
				fhBottom = FontHeight("font-family: handFont; font-size: " + fsTop3 + "pt"),
				fwBottom = 0;

			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsTop1 + "pt mainFont";
			fwTop1 = parseInt(ctx.measureText('— ' + AppRegistry.weather.temp + '°C —').width);
			ctx.fillText('— ' + AppRegistry.weather.temp + '°C —', canvasCenterX - parseInt(fwTop1 / 2), fhTop1*1.5);
			
			ctx.font = fsTop2 + "pt cheersFont";
			fwTop2 = parseInt(ctx.measureText('SPRING').width);
			ctx.fillText('SUMMER', canvasCenterX - parseInt(fwTop2 / 2), fhTop1*1.5 + fhTop2);
			
			ctx.font = fsTop3 + "pt handFont";
			fwTop3 = parseInt(ctx.measureText('is here').width);
			ctx.fillText('is here', canvasCenterX - parseInt(fwTop3 / 2), fhTop1*1.5 + fhTop2 + fhTop3);
			
			ctx.font = fsBottom + "pt handFont";
			fwBottom = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwBottom / 2), canvas.height - fhBottom);
			
			if ( ! AppRegistry.config.proVersion) {
				ProVersionDefense(canvas, ctx, FontHeight);
			}
		},
			
		'speaking--winter-is-here' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsTop1 = parseInt(canvas.height / 14.0),
				fhTop1 = FontHeight("font-family: mainFont; font-size: " + fsTop1 + "pt"),
				fwTop1 = 0,
				fsTop2 = parseInt(canvas.height / 10.0),
				fhTop2 = FontHeight("font-family: cheersFont; font-size: " + fsTop2 + "pt"),
				fwTop2 = 0,
				fsTop3 = parseInt(canvas.height / 18.0),
				fhTop3 = FontHeight("font-family: handFont; font-size: " + fsTop3 + "pt"),
				fwTop3 = 0,
				fsBottom = parseInt(canvas.height / 14.0),
				fhBottom = FontHeight("font-family: handFont; font-size: " + fsTop3 + "pt"),
				fwBottom = 0;

			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsTop1 + "pt mainFont";
			fwTop1 = parseInt(ctx.measureText('— ' + AppRegistry.weather.temp + '°C —').width);
			ctx.fillText('— ' + AppRegistry.weather.temp + '°C —', canvasCenterX - parseInt(fwTop1 / 2), fhTop1*1.5);
			
			ctx.font = fsTop2 + "pt cheersFont";
			fwTop2 = parseInt(ctx.measureText('SPRING').width);
			ctx.fillText('WINTER', canvasCenterX - parseInt(fwTop2 / 2), fhTop1*1.5 + fhTop2);
			
			ctx.font = fsTop3 + "pt handFont";
			fwTop3 = parseInt(ctx.measureText('is coming').width);
			ctx.fillText('is coming', canvasCenterX - parseInt(fwTop3 / 2), fhTop1*1.5 + fhTop2 + fhTop3);
			
			ctx.font = fsBottom + "pt handFont";
			fwBottom = parseInt(ctx.measureText('to ' + AppRegistry.loc.city).width);
			ctx.fillText('to ' + AppRegistry.loc.city, canvasCenterX - parseInt(fwBottom / 2), canvas.height - fhBottom);
			
			if ( ! AppRegistry.config.proVersion) {
				ProVersionDefense(canvas, ctx, FontHeight);
			}
		},
			
		'speaking--autumn-is-here' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsTop1 = parseInt(canvas.height / 14.0),
				fhTop1 = FontHeight("font-family: mainFont; font-size: " + fsTop1 + "pt"),
				fwTop1 = 0,
				fsTop2 = parseInt(canvas.height / 10.0),
				fhTop2 = FontHeight("font-family: cheersFont; font-size: " + fsTop2 + "pt"),
				fwTop2 = 0,
				fsTop3 = parseInt(canvas.height / 18.0),
				fhTop3 = FontHeight("font-family: handFont; font-size: " + fsTop3 + "pt"),
				fwTop3 = 0,
				fsBottom = parseInt(canvas.height / 14.0),
				fhBottom = FontHeight("font-family: handFont; font-size: " + fsTop3 + "pt"),
				fwBottom = 0;

			ctx.fillStyle = '#ffffff';
			
			ctx.font = fsTop1 + "pt mainFont";
			fwTop1 = parseInt(ctx.measureText('— ' + AppRegistry.weather.temp + '°C —').width);
			ctx.fillText('— ' + AppRegistry.weather.temp + '°C —', canvasCenterX - parseInt(fwTop1 / 2), fhTop1*1.5);
			
			ctx.font = fsTop2 + "pt cheersFont";
			fwTop2 = parseInt(ctx.measureText('SPRING').width);
			ctx.fillText('Autumn', canvasCenterX - parseInt(fwTop2 / 2), fhTop1*1.5 + fhTop2);
			
			ctx.font = fsTop3 + "pt handFont";
			fwTop3 = parseInt(ctx.measureText('is here').width);
			ctx.fillText('is here', canvasCenterX - parseInt(fwTop3 / 2), fhTop1*1.5 + fhTop2 + fhTop3);
			
			ctx.font = fsBottom + "pt handFont";
			fwBottom = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwBottom / 2), canvas.height - fhBottom);
			
			if ( ! AppRegistry.config.proVersion) {
				ProVersionDefense(canvas, ctx, FontHeight);
			}
		},
			
		'speaking--greetings-from' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsDesc = parseInt(canvas.height / 18.0),
				fhDesc = FontHeight("font-family: handFont; font-size: " + fsDesc + "pt"),
				fwDesc = 0,
				fsCity = parseInt(canvas.height / 12.0),
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt"),
				fwCity = 0;

			ctx.fillStyle = '#FA7A6E';
			ctx.font = fsDesc + "pt handFont";
			fwDesc = parseInt(ctx.measureText('Greetings from').width);
			ctx.fillText('Greetings from', canvasCenterX - parseInt(fwDesc / 2), canvas.height - fhDesc - fhCity);
			
			ctx.fillStyle = '#ffffff';
			ctx.font = fsCity + "pt thinFont";
			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), canvas.height - fhCity);
			
			if ( ! AppRegistry.config.proVersion) {
				ProVersionDefense(canvas, ctx, FontHeight);
			}
		},
			
		'speaking--good-morning' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsTemp = parseInt(canvas.height / 3.0),
				fhTemp = FontHeight("font-family: mainFont; font-size: " + fsTemp + "pt"),
				fwTemp = 0,
				fsDesc = parseInt(canvas.height / 12.0),
				fhDesc = FontHeight("font-family: cheersFont; font-size: " + fsDesc + "pt"),
				fwDesc = 0,
				fsCity = parseInt(canvas.height / 16.0),
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt"),
				fwCity = 0;

			ctx.globalAlpha = 0.35;
			ctx.fillStyle = '#ffffff';
			ctx.font = fsTemp + "pt mainFont";
			fwTemp = parseInt(ctx.measureText(AppRegistry.weather.temp + '°C').width);
			ctx.fillText(AppRegistry.weather.temp + '°C', canvasCenterX - parseInt(fwTemp / 2), canvas.height);
			ctx.globalAlpha = 1.0;

			ctx.fillStyle = '#ffffff';
			ctx.font = fsDesc + "pt cheersFont";
			fwDesc = parseInt(ctx.measureText('Good Morning').width);
			ctx.fillText('Good Morning', canvasCenterX - parseInt(fwDesc / 2), canvas.height - fhDesc - fhCity);
			
			ctx.fillStyle = '#ffffff';
			ctx.font = fsCity + "pt thinFont";
			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), canvas.height - fhCity);
			
			if ( ! AppRegistry.config.proVersion) {
				ProVersionDefense(canvas, ctx, FontHeight);
			}
		},
			
		'speaking--cheers' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsTemp = parseInt(canvas.height / 3.0),
				fhTemp = FontHeight("font-family: mainFont; font-size: " + fsTemp + "pt"),
				fwTemp = 0,
				fsDesc = parseInt(canvas.height / 12.0),
				fhDesc = FontHeight("font-family: cheersFont; font-size: " + fsDesc + "pt"),
				fwDesc = 0,
				fsCity = parseInt(canvas.height / 16.0),
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt"),
				fwCity = 0;

			ctx.globalAlpha = 0.35;
			ctx.fillStyle = '#ffffff';
			ctx.font = fsTemp + "pt mainFont";
			fwTemp = parseInt(ctx.measureText(AppRegistry.weather.temp + '°C').width);
			ctx.fillText(AppRegistry.weather.temp + '°C', canvasCenterX - parseInt(fwTemp / 2), canvas.height);
			ctx.globalAlpha = 1.0;

			ctx.fillStyle = '#ffffff';
			ctx.font = fsDesc + "pt cheersFont";
			fwDesc = parseInt(ctx.measureText('Cheers!').width);
			ctx.fillText('Cheers!', canvasCenterX - parseInt(fwDesc / 2), canvas.height - fhDesc - fhCity);
			
			ctx.fillStyle = '#ffffff';
			ctx.font = fsCity + "pt thinFont";
			fwCity = parseInt(ctx.measureText(AppRegistry.loc.city).width);
			ctx.fillText(AppRegistry.loc.city, canvasCenterX - parseInt(fwCity / 2), canvas.height - fhCity);
			
			if ( ! AppRegistry.config.proVersion) {
				ProVersionDefense(canvas, ctx, FontHeight);
			}
		},
			
		'speaking--rock-the-city' : function(canvas) {
			var ctx = canvas.getContext("2d"),
				canvasCenterX = parseInt(canvas.width / 2),
				canvasCenterY = parseInt(canvas.height / 2),
				fsBottom = parseInt(canvas.height / 10.0),
				fhBottom = FontHeight("font-family: cheersFont; font-size: " + fsBottom + "pt"),
				fwBottom = 0,
				fsCity = parseInt(canvas.height / 16.0),
				fhCity = FontHeight("font-family: thinFont; font-size: " + fsCity + "pt"),
				fwCity = 0;

			ctx.fillStyle = '#ffffff';
			ctx.font = fsCity + "pt thinFont";
			ctx.fillText(AppRegistry.loc.city + "|" + AppRegistry.weather.temp + "°C", 5, fhCity * 2, canvas.width - 5);
			
			ctx.fillStyle = '#DE1B1B';
			ctx.font = fsBottom + "pt cheersFont";
			fwBottom = parseInt(ctx.measureText("Rock The City").width);
			ctx.fillText("Rock The City", canvasCenterX - parseInt(fwBottom / 2), canvas.height - fhBottom / 3);
		}
	
	};
});