define(["jQuery", "jQueryMobile"], function($, $m) {
	
	/**
	 * @see http://bugs.openweathermap.org/projects/api/wiki/Weather_Condition_Codes
	 */
	var getWeatherDesc = function(code) {
		var result;
		
		switch (code) {
			case 200:
			case 201:
			case 202:
			case 210:
			case 211:
			case 212:
			case 221:
			case 230:
			case 231:
			case 232:
			case 771:
			case 781:
			case 900:
			case 901:
			case 902:
			case 960:
			case 961:
			case 962:	
				result = 'Stormy';
				break;
			case 300:
			case 301:
			case 302:
			case 310:
			case 311:
			case 312:
			case 313:
			case 314:
			case 321:
				result = 'Drizzly';
				break;
			case 500:
			case 501:
			case 502:
			case 503:
			case 504:
			case 511:
			case 520:
			case 521:
			case 522:
			case 531:
				result = 'Rainy';
				break;
			case 611:
			case 612:
			case 615:
			case 616:
				result = 'Sleety';
				break;
			case 600:
			case 601:
			case 602:
			case 620:
			case 621:
			case 622:
				result = 'Snowy';
				break;
			case 700:
			case 711:
			case 721:
			case 731:
			case 741:
			case 751:
			case 761:
			case 762:
				result = 'Foggy';
				break;
			case 800:
			case 904:
			case 951:
				result = 'Sunny';
				break;
			case 801:
			case 802:
			case 803:
				result = 'PartlyCloudy';
				break;
			case 804:
			case 903:
			case 905:
			case 950:
			case 952:
			case 953:
			case 954:
			case 955:
			case 956:
			case 957:
			case 958:
			case 959:
				result = 'Cloudy';
				break;
			case 906:
				result = 'IceRainy';
				break;
			default:
				result = 'Sunny';
		}
		return result;
	};
	
	return function(lat, lng) {
		var result = {
			temp : 'n/a',
			humidity : 'n/a',
			desc : 'n/a',
			descLong : 'n/a',
			icon : null,
			pic : 'img/weather/Sunny.png'
		};
		
		$.ajaxSetup({
			xhrFields: {
				mozSystem: true
			},
			async: false
		});
		
		$.getJSON("http://api.openweathermap.org/data/2.5/weather?lat="+lat+"&lon="+lng+"&APPID=2a16430b51abde12921c88eefc6cb214", function(response) {
		})
			.done(function(response) {
				var errors = [];

				if (response.hasOwnProperty('main')) {
					result.temp = parseInt(parseInt(response.main.temp) - 273.15);
					result.humidity = response.main.humidity;
				} else {
					errors.push("Can't get main weather info!");
				}
			
				if (response.hasOwnProperty('weather') && typeof response.weather[0] !== 'undefined') {
					result.desc = getWeatherDesc(response.weather[0].id);
					result.descLong = response.weather[0].description;
					result.icon = "http://openweathermap.org/img/w/"+response.weather[0].icon+".png";
					result.pic = "img/weather/"+result.desc+".png";
				} else {
					errors.push("Can't get additional weather info!");
				}
			})
			.fail(function() {
				$("body").removeClass('ui-disabled-override');$m.hidePageLoadingMsg();
				alert("Can't get weather informations!");
				$.mobile.changePage("#pick-photo-page");
			})
			.always(function() {
			});
		
		$.ajaxSetup({ async: true });

		return result;
	};

});