define(["modules/app_registry",
		"jQuery",
		"jQueryMobile",
		"modules/canvas/create_main",
		"modules/canvas/draw/wsimple"],
			function(	AppRegistry,
						$,
						$m,
						MainCanvas,
						wSimple) {	
	
	var renderImg = function(imgSrc, argumentsObj, fadeIn) {
		MainCanvas("picked-photo", imgSrc, "#content", "", argumentsObj);
		$("#picked-photo").hide();
		$("#picked-photo").fadeIn(fadeIn);
	};
	
	return {

		render : function() {
			var imgSrc = AppRegistry.image.selectedImage,
				swipeIndex = 0,
				argumentsObj = {
					onLoadFunc : function (id, params, canvas) {
						wSimple[AppRegistry.pattern.selected](canvas);
					}, params : {}
				};

			renderImg(imgSrc, argumentsObj, 2000);

			$("#picked-photo").swiperight(function() {
				renderImg(imgSrc, argumentsObj, 500);

				if (--swipeIndex < 0) {
					swipeIndex = AppRegistry.pattern.patterns.simple.length - 1;
				}
				AppRegistry.pattern.selected = AppRegistry.pattern.patterns.simple[swipeIndex];
				$("#edit-header > h1").text("← "+(swipeIndex+1)+" →");
			});

			$("#picked-photo").swipeleft(function() {
				renderImg(imgSrc, argumentsObj, 500);

				if (++swipeIndex > AppRegistry.pattern.patterns.simple.length - 1) {
					swipeIndex = 0;
				}
				AppRegistry.pattern.selected = AppRegistry.pattern.patterns.simple[swipeIndex];
				$("#edit-header > h1").text("← "+(swipeIndex+1)+" →");
			});
		}
	};
});